/*
 * Decompiled with CFR 0.152.
 */
package com.burrows.easaddon;

import com.burrows.easaddon.EASBlockEntity;
import com.burrows.easaddon.RegistryHandler;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EASBlock
extends Block
implements EntityBlock {
    private static final Logger LOGGER = LogManager.getLogger((String)"EASAddon");
    private static Class<?> tornadoSensorCls;
    private static Class<?> metarCls;

    public EASBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        LOGGER.info("EASBlock: newBlockEntity @ {}", (Object)pos);
        return new EASBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        if (type == RegistryHandler.EAS_BLOCK_ENTITY.get()) {
            LOGGER.info("EASBlock: scheduling ticker @ {} (clientSide={})", (Object)this.posToString(level, state), (Object)level.isClientSide());
            return (lvl, pos, st, be) -> EASBlockEntity.tick(lvl, pos, st, (EASBlockEntity)be);
        }
        return null;
    }

    private String posToString(Level level, BlockState state) {
        return state.toString();
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        boolean anySupercellInRange;
        boolean anyTornadoInRange;
        boolean metarDetected;
        boolean tornadoPowered;
        block12: {
            if (level.isClientSide) {
                return InteractionResult.SUCCESS;
            }
            tornadoPowered = false;
            metarDetected = false;
            BooleanProperty POWERED = BlockStateProperties.POWERED;
            for (Direction dir : Direction.values()) {
                BlockPos adj = pos.relative(dir);
                BlockState st = level.getBlockState(adj);
                Block b = st.getBlock();
                if (tornadoSensorCls != null && tornadoSensorCls.isInstance(b)) {
                    boolean pw = st.hasProperty((Property)POWERED) && (Boolean)st.getValue((Property)POWERED) != false;
                    tornadoPowered |= pw;
                }
                if (metarCls == null || !metarCls.isInstance(b)) continue;
                metarDetected = true;
            }
            anyTornadoInRange = false;
            anySupercellInRange = false;
            try {
                Class<?> gbe = Class.forName("dev.protomanly.pmweather.event.GameBusEvents");
                Field managersF = gbe.getField("MANAGERS");
                Map managers = (Map)managersF.get(null);
                Object handler = managers.get(level.dimension());
                if (handler == null) break block12;
                Method getStorms = handler.getClass().getMethod("getStorms", new Class[0]);
                List storms = (List)getStorms.invoke(handler, new Object[0]);
                for (Object storm : storms) {
                    double dz;
                    double d;
                    double dy;
                    double d2;
                    int type = storm.getClass().getField("stormType").getInt(storm);
                    int stage = storm.getClass().getField("stage").getInt(storm);
                    Vec3 stormPos = (Vec3)storm.getClass().getField("position").get(storm);
                    int windspeed = storm.getClass().getField("windspeed").getInt(storm);
                    double dx = stormPos.x - (double)pos.getX();
                    if (dx * dx + d2 * (dy = stormPos.y - (double)pos.getY()) + d * (dz = stormPos.z - (double)pos.getZ()) > 10000.0) continue;
                    if (type == 0) {
                        if (stage >= 3) {
                            anyTornadoInRange = true;
                            continue;
                        }
                        anySupercellInRange = true;
                        continue;
                    }
                    if (type == 1) continue;
                }
            }
            catch (Exception e) {
                LOGGER.warn("EAS: failed to reflect storms \u2192 {}", (Object)e.toString());
            }
        }
        if (anyTornadoInRange || !tornadoPowered) {
            // empty if block
        }
        if (anySupercellInRange || metarDetected) {
            // empty if block
        }
        if (tornadoPowered || anyTornadoInRange) {
            // empty if block
        }
        if (!metarDetected || anySupercellInRange) {
            // empty if block
        }
        return InteractionResult.CONSUME;
    }

    static {
        try {
            tornadoSensorCls = Class.forName("dev.protomanly.pmweather.block.TornadoSensorBlock");
        }
        catch (ClassNotFoundException e) {
            LOGGER.warn("TornadoSensorBlock class not found; tornado integration disabled");
        }
        try {
            metarCls = Class.forName("dev.protomanly.pmweather.block.MetarBlock");
        }
        catch (ClassNotFoundException e) {
            LOGGER.warn("MetarBlock class not found; supercell integration disabled");
        }
    }
}

