/*
 * Decompiled with CFR 0.152.
 */
package com.burrows.easaddon;

import com.burrows.easaddon.EASBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public class EasTransmitterItem
extends Item {
    public EasTransmitterItem(Item.Properties props) {
        super(props);
    }

    public InteractionResult useOn(UseOnContext ctx) {
        Level world = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        Player player = ctx.getPlayer();
        if (!world.isClientSide() && world.getBlockState(pos).getBlock() instanceof EASBlock) {
            ItemStack stack = ctx.getItemInHand();
            CustomData component = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
            CompoundTag tag = component != null ? component.copyTag() : new CompoundTag();
            tag.putLong("boundPos", pos.asLong());
            tag.putString("boundDim", world.dimension().location().toString());
            stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
            if (player != null) {
                player.sendSystemMessage((Component)Component.literal((String)("\u00a76Transmitter bound to EAS at " + String.valueOf(pos))));
            }
            return InteractionResult.CONSUME;
        }
        return super.useOn(ctx);
    }
}

