/*
 * Decompiled with CFR 0.152.
 */
package com.burrows.easaddon.client;

import com.burrows.easaddon.AlertPolygon;
import com.burrows.easaddon.AlertPolygonManager;
import com.burrows.easaddon.RadarOverlayBlockEntity;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.logging.LogUtils;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.slf4j.Logger;

public class RadarOverlayRenderer
implements BlockEntityRenderer<RadarOverlayBlockEntity> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<Long, CachedPolygonData> polygonCache = new ConcurrentHashMap<Long, CachedPolygonData>();
    private static final Map<Long, Boolean> loggedPolygons = new ConcurrentHashMap<Long, Boolean>();
    private static final float DISPLAY_RANGE = 0.05f;
    private static final float BASE_SIZE = 0.02f;
    private static final float SIZE_MULTIPLIER = 50.0f;
    private static final float RENDER_HEIGHT = 0.01f;
    private static final float ROTATION_CORRECTION = -90.0f;

    public RadarOverlayRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(RadarOverlayBlockEntity be, float partialTicks, PoseStack poseStack, MultiBufferSource buffers, int packedLight, int packedOverlay) {
        BlockPos pos = be.getBlockPos();
        Collection<AlertPolygon> polys = AlertPolygonManager.getPolygonsAt(pos);
        if (polys.isEmpty()) {
            return;
        }
        Matrix4fStack mvStack = RenderSystem.getModelViewStack();
        mvStack.pushMatrix();
        mvStack.mul((Matrix4fc)poseStack.last().pose());
        mvStack.translate(0.5f, 0.05f, 0.5f);
        RenderSystem.applyModelViewMatrix();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        RenderSystem.disableDepthTest();
        Tesselator tess = Tesselator.getInstance();
        BufferBuilder buf = tess.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        for (AlertPolygon poly : polys) {
            CachedPolygonData cached = this.getCachedPolygonData(poly);
            Vector3f[] corners = cached.corners;
            buf.addVertex(corners[0].x, corners[0].y, corners[0].z).setColor(cached.r, cached.g, cached.b, cached.a);
            buf.addVertex(corners[3].x, corners[3].y, corners[3].z).setColor(cached.r, cached.g, cached.b, cached.a);
            buf.addVertex(corners[2].x, corners[2].y, corners[2].z).setColor(cached.r, cached.g, cached.b, cached.a);
            buf.addVertex(corners[1].x, corners[1].y, corners[1].z).setColor(cached.r, cached.g, cached.b, cached.a);
        }
        MeshData mesh = buf.build();
        if (mesh != null) {
            BufferUploader.drawWithShader((MeshData)mesh);
        }
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
        mvStack.popMatrix();
        RenderSystem.applyModelViewMatrix();
        if (System.currentTimeMillis() % 5000L < 50L) {
            this.cleanupCache();
        }
    }

    private CachedPolygonData getCachedPolygonData(AlertPolygon poly) {
        long cacheKey = poly.stormId;
        CachedPolygonData cached = polygonCache.get(cacheKey);
        if (cached == null || this.needsRecalculation(poly, cached)) {
            cached = this.calculatePolygonData(poly);
            polygonCache.put(cacheKey, cached);
            if (!loggedPolygons.getOrDefault(cacheKey, false).booleanValue()) {
                LOGGER.debug("RadarOverlayRenderer: Cached new polygon data for storm {}", (Object)poly.stormId);
                loggedPolygons.put(cacheKey, true);
            }
        }
        return cached;
    }

    private boolean needsRecalculation(AlertPolygon poly, CachedPolygonData cached) {
        return System.currentTimeMillis() - cached.lastUpdateTime > 1000L;
    }

    private CachedPolygonData calculatePolygonData(AlertPolygon poly) {
        float worldX = (float)(poly.centerX * (double)0.05f);
        float worldZ = (float)(poly.centerZ * (double)0.05f);
        float hw = Math.max(poly.halfWidth * 0.05f * 50.0f, 0.02f);
        float hh = Math.max(poly.halfHeight * 0.05f * 50.0f, 0.02f);
        float correctedRotation = poly.rotationDeg + -90.0f;
        double radians = Math.toRadians(correctedRotation);
        float cos = (float)Math.cos(radians);
        float sin = (float)Math.sin(radians);
        Vector3f[] corners = new Vector3f[]{new Vector3f(-hw * cos - -hh * sin + worldX, 0.01f, -hw * sin + -hh * cos + worldZ), new Vector3f(hw * cos - -hh * sin + worldX, 0.01f, hw * sin + -hh * cos + worldZ), new Vector3f(hw * cos - hh * sin + worldX, 0.01f, hw * sin + hh * cos + worldZ), new Vector3f(-hw * cos - hh * sin + worldX, 0.01f, -hw * sin + hh * cos + worldZ)};
        float[] color = this.calculatePolygonColor(poly);
        return new CachedPolygonData(corners, color[0], color[1], color[2], color[3]);
    }

    private float[] calculatePolygonColor(AlertPolygon poly) {
        float b;
        float g;
        float r;
        int validatedStormType = Math.max(0, Math.min(1, poly.stormType));
        int validatedStormStage = Math.max(1, Math.min(3, poly.stormStage));
        int validatedLevel = Math.max(0, Math.min(3, poly.level));
        float a = 0.6f;
        if (validatedStormType == 0) {
            if (validatedStormStage >= 3) {
                if (validatedLevel >= 3) {
                    r = 0.5f;
                    g = 0.0f;
                    b = 0.5f;
                } else if (validatedLevel >= 2) {
                    r = 0.8f;
                    g = 0.0f;
                    b = 0.0f;
                } else {
                    r = 1.0f;
                    g = 0.0f;
                    b = 0.0f;
                }
            } else {
                r = 1.0f;
                g = 1.0f;
                b = 0.0f;
            }
        } else {
            r = 1.0f;
            g = 1.0f;
            b = 0.0f;
        }
        return new float[]{r, g, b, a};
    }

    private void cleanupCache() {
        long currentTime = System.currentTimeMillis();
        polygonCache.entrySet().removeIf(entry -> currentTime - ((CachedPolygonData)entry.getValue()).lastUpdateTime > 30000L);
        if (polygonCache.isEmpty()) {
            loggedPolygons.clear();
        }
    }

    private static class CachedPolygonData {
        final Vector3f[] corners;
        final float r;
        final float g;
        final float b;
        final float a;
        final long lastUpdateTime;

        CachedPolygonData(Vector3f[] corners, float r, float g, float b, float a) {
            this.corners = corners;
            this.r = r;
            this.g = g;
            this.b = b;
            this.a = a;
            this.lastUpdateTime = System.currentTimeMillis();
        }
    }
}

