/*
 * Decompiled with CFR 0.152.
 */
package com.burrows.easaddon;

import com.burrows.easaddon.AlertPolygon;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AlertPolygonManager {
    private static final Logger LOGGER = LogManager.getLogger((String)"EASAddon");
    private static final Map<BlockPos, List<AlertPolygon>> polygonMap = new ConcurrentHashMap<BlockPos, List<AlertPolygon>>();

    public static void addPolygon(BlockPos pos, AlertPolygon polygon) {
        List list = polygonMap.computeIfAbsent(pos, k -> new ArrayList());
        list.removeIf(existing -> existing.stormId == polygon.stormId);
        list.add(polygon);
    }

    public static Collection<AlertPolygon> getPolygonsAt(BlockPos pos) {
        Collection polys = polygonMap.getOrDefault(pos, Collections.emptyList());
        return polys;
    }

    public static void clearPolygons(BlockPos pos) {
        polygonMap.remove(pos);
    }

    public static void retainPolygons(BlockPos pos, Set<Long> keepIds) {
        List<AlertPolygon> list = polygonMap.get(pos);
        if (list == null) {
            return;
        }
        boolean changed = list.removeIf(poly -> !keepIds.contains(poly.stormId));
        if (changed) {
            // empty if block
        }
    }

    public static void writePolygons(BlockPos pos, CompoundTag tag) {
        List<AlertPolygon> polygons = polygonMap.get(pos);
        if (polygons == null || polygons.isEmpty()) {
            return;
        }
        ListTag list = new ListTag();
        for (AlertPolygon poly : polygons) {
            CompoundTag polyTag = new CompoundTag();
            polyTag.putLong("stormId", poly.stormId);
            polyTag.putDouble("centerX", poly.centerX);
            polyTag.putDouble("centerZ", poly.centerZ);
            polyTag.putFloat("halfWidth", poly.halfWidth);
            polyTag.putFloat("halfHeight", poly.halfHeight);
            polyTag.putFloat("rotation", poly.rotationDeg);
            polyTag.putInt("stormType", poly.stormType);
            polyTag.putInt("stormStage", poly.stormStage);
            polyTag.putInt("level", poly.level);
            list.add((Object)polyTag);
        }
        tag.put("polygons", (Tag)list);
    }

    public static void readPolygons(BlockPos pos, CompoundTag tag) {
        if (!tag.contains("polygons")) {
            return;
        }
        ListTag list = tag.getList("polygons", 10);
        ArrayList<AlertPolygon> polygons = new ArrayList<AlertPolygon>();
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag polyTag = list.getCompound(i);
            AlertPolygon poly = new AlertPolygon(polyTag.getLong("stormId"), polyTag.getDouble("centerX"), polyTag.getDouble("centerZ"), polyTag.getFloat("halfWidth"), polyTag.getFloat("halfHeight"), polyTag.getFloat("rotation"), polyTag.getInt("level"), polyTag.getInt("stormType"), polyTag.getInt("stormStage"));
            polygons.add(poly);
        }
        if (!polygons.isEmpty()) {
            polygonMap.put(pos, polygons);
        }
    }

    public static void debugPrintState() {
        for (Map.Entry<BlockPos, List<AlertPolygon>> entry : polygonMap.entrySet()) {
        }
    }
}

