/*
 * Decompiled with CFR 0.152.
 */
package com.burrows.easaddon;

import com.burrows.easaddon.AlertPolygon;
import com.burrows.easaddon.AlertPolygonManager;
import com.burrows.easaddon.EasTransmitterItem;
import com.burrows.easaddon.RadarOverlayBlock;
import com.burrows.easaddon.RadarOverlayBlockEntity;
import com.burrows.easaddon.RegistryHandler;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EASBlockEntity
extends BlockEntity {
    private static final Logger LOGGER = LogManager.getLogger((String)"EASAddon");
    private int tickCounter = 0;
    private final Map<Long, Integer> trackedStormsById = new HashMap<Long, Integer>();

    public EASBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)RegistryHandler.EAS_BLOCK_ENTITY.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, EASBlockEntity be) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        if (++be.tickCounter >= 200) {
            be.tickCounter = 0;
            be.checkStorms(server, pos);
        }
        if (be.tickCounter % 200 == 0) {
            be.cleanupOrphanedOverlays(server, pos);
        }
    }

    private void ensureRadarOverlays(ServerLevel level, BlockPos easPos) {
        LOGGER.info("EAS: Ensuring radar overlays are placed for EAS at {}", (Object)easPos);
        for (Direction dir : Direction.values()) {
            BlockPos radarPos = easPos.relative(dir);
            BlockState radarState = level.getBlockState(radarPos);
            try {
                Class<?> radarCls = Class.forName("dev.protomanly.pmweather.block.RadarBlock");
                if (!radarCls.isInstance(radarState.getBlock())) continue;
                BlockPos overlayPos = radarPos.above();
                BlockState overlayState = level.getBlockState(overlayPos);
                LOGGER.info("EAS: Found radar at {}, checking overlay at {}", (Object)radarPos, (Object)overlayPos);
                LOGGER.info("EAS: Current block at overlay position: {}", (Object)overlayState.getBlock().getClass().getName());
                boolean isNewRadar = false;
                if (overlayState.isAir() || !overlayState.is((Block)RegistryHandler.RADAR_OVERLAY_BLOCK.get())) {
                    LOGGER.info("EAS: Placing radar overlay block at {}", (Object)overlayPos);
                    level.setBlock(overlayPos, ((RadarOverlayBlock)((Object)RegistryHandler.RADAR_OVERLAY_BLOCK.get())).defaultBlockState(), 3);
                    isNewRadar = true;
                } else {
                    LOGGER.info("EAS: Radar overlay already exists at {}", (Object)overlayPos);
                }
                this.createMissingPolygonsForRadar(level, easPos, radarPos, overlayPos, isNewRadar);
            }
            catch (ClassNotFoundException e) {
                LOGGER.info("EAS: PMWeather not installed, skipping radar detection");
            }
        }
    }

    private void cleanupOrphanedOverlays(ServerLevel level, BlockPos easPos) {
        for (Direction dir : Direction.values()) {
            BlockPos radarPos = easPos.relative(dir);
            BlockPos overlayPos = radarPos.above();
            BlockState radarState = level.getBlockState(radarPos);
            BlockState overlayState = level.getBlockState(overlayPos);
            if (!overlayState.is((Block)RegistryHandler.RADAR_OVERLAY_BLOCK.get())) continue;
            boolean hasRadarBelow = false;
            try {
                Class<?> radarCls = Class.forName("dev.protomanly.pmweather.block.RadarBlock");
                hasRadarBelow = radarCls.isInstance(radarState.getBlock());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (hasRadarBelow) continue;
            level.destroyBlock(overlayPos, false);
            AlertPolygonManager.clearPolygons(overlayPos);
            LOGGER.info("EAS: Cleaned up orphaned radar overlay at {}", (Object)overlayPos);
        }
    }

    private void createMissingPolygonsForRadar(ServerLevel level, BlockPos easPos, BlockPos radarPos, BlockPos overlayPos, boolean isNewRadar) {
        if (this.trackedStormsById.isEmpty()) {
            return;
        }
        LOGGER.info("EAS: Checking for missing polygons at radar {} (overlay at {})", (Object)radarPos, (Object)overlayPos);
        try {
            Class<?> gbe = Class.forName("dev.protomanly.pmweather.event.GameBusEvents");
            Field managersF = gbe.getField("MANAGERS");
            Map managers = (Map)managersF.get(null);
            Object handler = managers.get(level.dimension());
            if (handler == null) {
                return;
            }
            Method getStorms = handler.getClass().getMethod("getStorms", new Class[0]);
            List storms = (List)getStorms.invoke(handler, new Object[0]);
            Collection<AlertPolygon> existingPolygons = AlertPolygonManager.getPolygonsAt(overlayPos);
            HashSet<Long> existingStormIds = new HashSet<Long>();
            for (AlertPolygon poly : existingPolygons) {
                existingStormIds.add(poly.stormId);
            }
            LOGGER.info("EAS: Found {} existing polygons at {}, storm IDs: {}", (Object)existingPolygons.size(), (Object)overlayPos, existingStormIds);
            for (AlertPolygon storm : storms) {
                float halfH;
                float halfW;
                long stormId = storm.getClass().getField("ID").getLong(storm);
                int type = storm.getClass().getField("stormType").getInt(storm);
                int stage = storm.getClass().getField("stage").getInt(storm);
                Vec3 stormPos = (Vec3)storm.getClass().getField("position").get(storm);
                int windspeed = storm.getClass().getField("windspeed").getInt(storm);
                Vec3 velocity = (Vec3)storm.getClass().getField("velocity").get(storm);
                if (stormPos.distanceToSqr((double)easPos.getX(), (double)easPos.getY(), (double)easPos.getZ()) > 262144.0 || !this.trackedStormsById.containsKey(stormId)) continue;
                if (existingStormIds.contains(stormId)) {
                    LOGGER.info("EAS: Polygon for storm {} already exists at radar {}", (Object)stormId, (Object)radarPos);
                    continue;
                }
                boolean shouldCreatePolygon = false;
                int polygonLevel = 0;
                if (type == 0) {
                    if (stage >= 3) {
                        shouldCreatePolygon = true;
                        polygonLevel = Math.max(1, this.computeAlertLevel(type, stage, windspeed));
                    } else if (stage >= 1) {
                        shouldCreatePolygon = true;
                        polygonLevel = stage;
                    }
                } else if (type == 1 && stage >= 1) {
                    shouldCreatePolygon = true;
                    polygonLevel = stage;
                }
                if (!shouldCreatePolygon) continue;
                LOGGER.info("EAS: Creating missing polygon for storm {} at radar {} (type={}, stage={}, level={})", (Object)stormId, (Object)radarPos, (Object)type, (Object)stage, (Object)polygonLevel);
                double radarRange = 1024.0;
                double worldDx = stormPos.x - ((double)radarPos.getX() + 0.5);
                double worldDz = stormPos.z - ((double)radarPos.getZ() + 0.5);
                double cx = 0.5 + worldDx / (radarRange * 2.0);
                double cz = 0.5 + worldDz / (radarRange * 2.0);
                cx = Math.max(0.0, Math.min(1.0, cx));
                cz = Math.max(0.0, Math.min(1.0, cz));
                LOGGER.info("EAS: Storm at world pos ({}, {}) -> Radar at ({}, {}) -> World offset ({}, {}) -> Display coords ({}, {})", (Object)stormPos.x, (Object)stormPos.z, (Object)((double)radarPos.getX() + 0.5), (Object)((double)radarPos.getZ() + 0.5), (Object)worldDx, (Object)worldDz, (Object)cx, (Object)cz);
                if (type == 0 && stage >= 3) {
                    halfW = 0.15f;
                    halfH = 0.1f;
                } else if (type == 0) {
                    halfW = 0.25f;
                    halfH = 0.2f;
                } else {
                    halfW = 0.4f;
                    halfH = 0.15f;
                }
                float movementAngle = (float)Math.toDegrees(Math.atan2(velocity.x, -velocity.z));
                movementAngle = (movementAngle + 360.0f) % 360.0f;
                float rotation = type == 1 ? (movementAngle + 90.0f) % 360.0f : movementAngle % 360.0f;
                AlertPolygon poly = new AlertPolygon(stormId, cx, cz, halfW, halfH, rotation, polygonLevel, type, stage);
                LOGGER.info("EAS: Created missing polygon: stormId={}, center=({},{}), size={}x{}, rotation={}, level={}", (Object)stormId, (Object)cx, (Object)cz, (Object)Float.valueOf(halfW * 2.0f), (Object)Float.valueOf(halfH * 2.0f), (Object)Float.valueOf(rotation), (Object)polygonLevel);
                AlertPolygonManager.addPolygon(overlayPos, poly);
                BlockEntity overlayBE = level.getBlockEntity(overlayPos);
                if (!(overlayBE instanceof RadarOverlayBlockEntity)) continue;
                RadarOverlayBlockEntity radarOverlay = (RadarOverlayBlockEntity)overlayBE;
                radarOverlay.setChanged();
                radarOverlay.requestClientUpdate();
                LOGGER.info("EAS: Missing polygon sent to radar overlay at {}", (Object)overlayPos);
            }
        }
        catch (Exception e) {
            LOGGER.error("EAS: createMissingPolygonsForRadar failed \u2014 {}", (Object)e.toString());
        }
    }

    private void updatePolygonAlertLevels(ServerLevel level, BlockPos easPos, long stormId, int type, int stage, int newAlertLevel) {
        LOGGER.info("EAS: Updating polygon alert levels for storm {} to level {}", (Object)stormId, (Object)newAlertLevel);
        boolean polygonUpdated = false;
        block2: for (Direction dir : Direction.values()) {
            BlockPos radarPos = easPos.relative(dir);
            BlockState radarState = level.getBlockState(radarPos);
            try {
                Class<?> radarCls = Class.forName("dev.protomanly.pmweather.block.RadarBlock");
                if (!radarCls.isInstance(radarState.getBlock())) continue;
                BlockPos overlayPos = radarPos.above();
                Collection<AlertPolygon> existingPolygons = AlertPolygonManager.getPolygonsAt(overlayPos);
                for (AlertPolygon existingPoly : existingPolygons) {
                    if (existingPoly.stormId != stormId) continue;
                    LOGGER.info("EAS: Found polygon for storm {} at radar {} - updating level {} -> {}", (Object)stormId, (Object)radarPos, (Object)existingPoly.level, (Object)newAlertLevel);
                    int polygonLevel = newAlertLevel;
                    if (type == 0) {
                        if (stage >= 3) {
                            polygonLevel = Math.max(1, newAlertLevel);
                        } else if (stage >= 1) {
                            polygonLevel = stage;
                        }
                    } else if (type == 1 && stage >= 1) {
                        polygonLevel = stage;
                    }
                    AlertPolygon updatedPoly = new AlertPolygon(stormId, existingPoly.centerX, existingPoly.centerZ, existingPoly.halfWidth, existingPoly.halfHeight, existingPoly.rotationDeg, polygonLevel, type, stage);
                    AlertPolygonManager.addPolygon(overlayPos, updatedPoly);
                    polygonUpdated = true;
                    LOGGER.info("EAS: Updated polygon for storm {} at radar {} - new level: {}", (Object)stormId, (Object)radarPos, (Object)polygonLevel);
                    BlockEntity overlayBE = level.getBlockEntity(overlayPos);
                    if (!(overlayBE instanceof RadarOverlayBlockEntity)) continue block2;
                    RadarOverlayBlockEntity radarOverlay = (RadarOverlayBlockEntity)overlayBE;
                    radarOverlay.setChanged();
                    radarOverlay.requestClientUpdate();
                    LOGGER.info("EAS: Client update sent for polygon level change at {}", (Object)overlayPos);
                    continue block2;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (!polygonUpdated) {
            LOGGER.warn("EAS: No existing polygon found for storm {} to update alert level", (Object)stormId);
        }
    }

    private void checkStorms(ServerLevel level, BlockPos easPos) {
        Class<?> metarCls;
        try {
            metarCls = Class.forName("dev.protomanly.pmweather.block.MetarBlock");
        }
        catch (ClassNotFoundException e) {
            return;
        }
        boolean metarAdjacent = false;
        for (Direction dir : Direction.values()) {
            BlockPos adj = easPos.relative(dir);
            BlockState st = level.getBlockState(adj);
            if (metarCls == null || !metarCls.isInstance(st.getBlock())) continue;
            metarAdjacent = true;
            break;
        }
        if (!metarAdjacent) {
            return;
        }
        this.ensureRadarOverlays(level, easPos);
        try {
            Class<?> gbe = Class.forName("dev.protomanly.pmweather.event.GameBusEvents");
            Field managersF = gbe.getField("MANAGERS");
            Map managers = (Map)managersF.get(null);
            Object handler = managers.get(level.dimension());
            if (handler == null) {
                return;
            }
            Method getStorms = handler.getClass().getMethod("getStorms", new Class[0]);
            List storms = (List)getStorms.invoke(handler, new Object[0]);
            HashSet<Long> allCurrentStormIds = new HashSet<Long>();
            HashSet<Long> inRangeStormIds = new HashSet<Long>();
            for (Object storm : storms) {
                long stormId = storm.getClass().getField("ID").getLong(storm);
                int type = storm.getClass().getField("stormType").getInt(storm);
                int stage = storm.getClass().getField("stage").getInt(storm);
                Vec3 stormPos = (Vec3)storm.getClass().getField("position").get(storm);
                int windspeed = storm.getClass().getField("windspeed").getInt(storm);
                Vec3 velocity = (Vec3)storm.getClass().getField("velocity").get(storm);
                double horizontalSpeed = Math.sqrt(velocity.x * velocity.x + velocity.z * velocity.z);
                int movementSpeedMPH = (int)(horizontalSpeed * 20.0 * 2.23694 / 6.0);
                allCurrentStormIds.add(stormId);
                if (!(stormPos.distanceToSqr((double)easPos.getX(), (double)easPos.getY(), (double)easPos.getZ()) <= 262144.0)) continue;
                inRangeStormIds.add(stormId);
                int newLevel = this.computeAlertLevel(type, stage, windspeed);
                Integer oldLevel = this.trackedStormsById.get(stormId);
                if (oldLevel == null && newLevel > 0) {
                    this.handleStormDetection(level, easPos, stormId, stormPos, type, stage, windspeed, movementSpeedMPH, velocity);
                    this.trackedStormsById.put(stormId, newLevel);
                    continue;
                }
                if (oldLevel != null && newLevel != oldLevel && newLevel > 0) {
                    LOGGER.info("EAS: Storm {} alert level changed: {} -> {} (windspeed: {} MPH)", (Object)stormId, (Object)oldLevel, (Object)newLevel, (Object)windspeed);
                    this.handleStormDetection(level, easPos, stormId, stormPos, type, stage, windspeed, movementSpeedMPH, velocity);
                    this.updatePolygonAlertLevels(level, easPos, stormId, type, stage, newLevel);
                    this.trackedStormsById.put(stormId, newLevel);
                    continue;
                }
                if (oldLevel == null || newLevel != 0) continue;
                LOGGER.info("EAS: Storm {} no longer meets alert criteria (windspeed: {} MPH)", (Object)stormId, (Object)windspeed);
                this.trackedStormsById.remove(stormId);
            }
            boolean hasAnyPolygonsRemaining = false;
            for (Direction dir : Direction.values()) {
                BlockPos radarPos = easPos.relative(dir);
                BlockState radarState = level.getBlockState(radarPos);
                try {
                    BlockEntity be;
                    Class<?> radarCls = Class.forName("dev.protomanly.pmweather.block.RadarBlock");
                    if (!radarCls.isInstance(radarState.getBlock())) continue;
                    BlockPos overlayPos = radarPos.above();
                    Collection<AlertPolygon> currentPolygons = AlertPolygonManager.getPolygonsAt(overlayPos);
                    int polygonCountBefore = currentPolygons.size();
                    HashSet<Long> visibleStormIds = new HashSet<Long>();
                    double radarRange = 1024.0;
                    if (!storms.isEmpty()) {
                        for (Object storm : storms) {
                            double worldDz;
                            long stormId = storm.getClass().getField("ID").getLong(storm);
                            Vec3 stormPos = (Vec3)storm.getClass().getField("position").get(storm);
                            double worldDx = stormPos.x - ((double)radarPos.getX() + 0.5);
                            double distanceFromRadar = Math.sqrt(worldDx * worldDx + (worldDz = stormPos.z - ((double)radarPos.getZ() + 0.5)) * worldDz);
                            if (!(distanceFromRadar <= radarRange) || !this.trackedStormsById.containsKey(stormId)) continue;
                            visibleStormIds.add(stormId);
                        }
                    }
                    LOGGER.info("EAS: Radar at {} - Before cleanup: {} polygons, Visible tracked storms: {}", (Object)radarPos, (Object)polygonCountBefore, (Object)visibleStormIds.size());
                    AlertPolygonManager.retainPolygons(overlayPos, visibleStormIds);
                    Collection<AlertPolygon> remainingPolygons = AlertPolygonManager.getPolygonsAt(overlayPos);
                    int polygonCountAfter = remainingPolygons.size();
                    if (polygonCountAfter > 0) {
                        hasAnyPolygonsRemaining = true;
                    }
                    if (polygonCountBefore == polygonCountAfter || !((be = level.getBlockEntity(overlayPos)) instanceof RadarOverlayBlockEntity)) continue;
                    RadarOverlayBlockEntity roe = (RadarOverlayBlockEntity)be;
                    roe.setChanged();
                    roe.requestClientUpdate();
                    LOGGER.info("EAS: Polygon cleanup at radar {} - {} -> {} polygons, client update sent", (Object)radarPos, (Object)polygonCountBefore, (Object)polygonCountAfter);
                }
                catch (ClassNotFoundException radarCls) {
                    // empty catch block
                }
            }
            HashSet<Long> previouslyTracked = new HashSet<Long>(this.trackedStormsById.keySet());
            this.trackedStormsById.keySet().retainAll(inRangeStormIds);
            HashSet<Long> removedStorms = new HashSet<Long>(previouslyTracked);
            removedStorms.removeAll(this.trackedStormsById.keySet());
            if (!removedStorms.isEmpty()) {
                LOGGER.info("EAS: Removed {} storms from tracking: {}", (Object)removedStorms.size(), removedStorms);
            }
            if (!storms.isEmpty()) {
                for (Object storm : storms) {
                    long stormId = storm.getClass().getField("ID").getLong(storm);
                    int type = storm.getClass().getField("stormType").getInt(storm);
                    int stage = storm.getClass().getField("stage").getInt(storm);
                    Vec3 stormPos = (Vec3)storm.getClass().getField("position").get(storm);
                    Vec3 velocity = (Vec3)storm.getClass().getField("velocity").get(storm);
                    if (!this.trackedStormsById.containsKey(stormId)) continue;
                    block13: for (Direction dir : Direction.values()) {
                        BlockPos radarPos = easPos.relative(dir);
                        BlockState radarState = level.getBlockState(radarPos);
                        try {
                            Collection<AlertPolygon> existingPolygons;
                            double worldDz;
                            Class<?> radarCls = Class.forName("dev.protomanly.pmweather.block.RadarBlock");
                            if (!radarCls.isInstance(radarState.getBlock())) continue;
                            BlockPos overlayPos = radarPos.above();
                            double radarRange = 1024.0;
                            double worldDx = stormPos.x - ((double)radarPos.getX() + 0.5);
                            double distanceFromRadar = Math.sqrt(worldDx * worldDx + (worldDz = stormPos.z - ((double)radarPos.getZ() + 0.5)) * worldDz);
                            if (distanceFromRadar > radarRange) {
                                BlockEntity overlayBE;
                                existingPolygons = AlertPolygonManager.getPolygonsAt(overlayPos);
                                boolean removed = false;
                                for (AlertPolygon existingPoly : existingPolygons) {
                                    if (existingPoly.stormId != stormId) continue;
                                    HashSet<Long> keepIds = new HashSet<Long>();
                                    for (AlertPolygon poly : existingPolygons) {
                                        if (poly.stormId == stormId) continue;
                                        keepIds.add(poly.stormId);
                                    }
                                    AlertPolygonManager.retainPolygons(overlayPos, keepIds);
                                    removed = true;
                                    LOGGER.info("EAS: Removed polygon for storm {} from radar {} (out of range)", (Object)stormId, (Object)radarPos);
                                    break;
                                }
                                if (!removed || !((overlayBE = level.getBlockEntity(overlayPos)) instanceof RadarOverlayBlockEntity)) continue;
                                RadarOverlayBlockEntity radarOverlay = (RadarOverlayBlockEntity)overlayBE;
                                radarOverlay.setChanged();
                                radarOverlay.requestClientUpdate();
                                continue;
                            }
                            existingPolygons = AlertPolygonManager.getPolygonsAt(overlayPos);
                            for (AlertPolygon existingPoly : existingPolygons) {
                                if (existingPoly.stormId != stormId) continue;
                                double newCx = 0.5 + worldDx / (radarRange * 2.0);
                                double newCz = 0.5 + worldDz / (radarRange * 2.0);
                                newCx = Math.max(0.0, Math.min(1.0, newCx));
                                newCz = Math.max(0.0, Math.min(1.0, newCz));
                                if (!(Math.abs(existingPoly.centerX - newCx) > 0.001) && !(Math.abs(existingPoly.centerZ - newCz) > 0.001)) continue block13;
                                float movementAngle = (float)Math.toDegrees(Math.atan2(velocity.x, -velocity.z));
                                movementAngle = (movementAngle + 360.0f) % 360.0f;
                                float newRotation = type == 1 ? (movementAngle + 90.0f) % 360.0f : movementAngle % 360.0f;
                                AlertPolygon updatedPoly = new AlertPolygon(stormId, newCx, newCz, existingPoly.halfWidth, existingPoly.halfHeight, newRotation, existingPoly.level, type, stage);
                                AlertPolygonManager.addPolygon(overlayPos, updatedPoly);
                                BlockEntity overlayBE = level.getBlockEntity(overlayPos);
                                if (overlayBE instanceof RadarOverlayBlockEntity) {
                                    RadarOverlayBlockEntity radarOverlay = (RadarOverlayBlockEntity)overlayBE;
                                    radarOverlay.setChanged();
                                    radarOverlay.requestClientUpdate();
                                }
                                LOGGER.info("EAS: Updated polygon position for storm {} at radar {}: ({}, {}) -> ({}, {})", (Object)stormId, (Object)radarPos, (Object)existingPoly.centerX, (Object)existingPoly.centerZ, (Object)newCx, (Object)newCz);
                                continue block13;
                            }
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                    }
                }
            }
            LOGGER.info("EAS: Storm check complete - Tracking {} storms, {} in range, polygons remaining: {}", (Object)this.trackedStormsById.size(), (Object)inRangeStormIds.size(), (Object)hasAnyPolygonsRemaining);
        }
        catch (Exception e) {
            LOGGER.error("EAS: checkStorms failed \u2014 {}", (Object)e.toString());
        }
    }

    private int computeAlertLevel(int type, int stage, int windspeed) {
        if (type == 0) {
            if (stage >= 3) {
                if (windspeed > 190) {
                    return 3;
                }
                if (windspeed >= 137) {
                    return 2;
                }
                return 1;
            }
            if (stage == 2) {
                return 1;
            }
        } else if (type == 1) {
            if (stage == 3) {
                return 3;
            }
            if (stage == 2) {
                return 2;
            }
            if (stage == 1) {
                return 1;
            }
        }
        return 0;
    }

    private String getWindDirection(Vec3 velocity) {
        double dx = velocity.x;
        double dz = velocity.z;
        double angle = Math.toDegrees(Math.atan2(dx, -dz));
        angle = (angle + 360.0) % 360.0;
        String[] directions = new String[]{"N", "NE", "E", "SE", "S", "SW", "W", "NW"};
        int index = (int)((angle + 22.5) / 45.0) % 8;
        return directions[index];
    }

    private float getWindDirectionAngle(Vec3 v) {
        double angle = Math.toDegrees(Math.atan2(v.x, -v.z));
        return (float)((angle + 360.0) % 360.0);
    }

    private void handleStormDetection(ServerLevel level, BlockPos easPos, long stormId, Vec3 stormPos, int type, int stage, int windspeed, int movementSpeedMPH, Vec3 velocity) {
        String dimensionId = level.dimension().location().toString();
        String windDirection = this.getWindDirection(velocity);
        String time = LocalTime.now().format(DateTimeFormatter.ofPattern("HH:mm"));
        String windInfo = String.format("%s @ %d MPH", windDirection, movementSpeedMPH);
        SoundEvent alertSound = (SoundEvent)RegistryHandler.EAS_ALERT.get();
        int alertLevel = this.computeAlertLevel(type, stage, windspeed);
        boolean shouldCreatePolygon = false;
        int polygonLevel = 0;
        if (type == 0) {
            if (stage >= 3) {
                shouldCreatePolygon = true;
                polygonLevel = Math.max(1, alertLevel);
            } else if (stage >= 1) {
                shouldCreatePolygon = true;
                polygonLevel = stage;
            }
        } else if (type == 1 && stage >= 1) {
            shouldCreatePolygon = true;
            polygonLevel = stage;
        }
        if (shouldCreatePolygon) {
            LOGGER.info("EAS: Creating polygon for storm {} (type={}, stage={}, alertLevel={}) at EAS position {}", (Object)stormId, (Object)type, (Object)stage, (Object)alertLevel, (Object)easPos);
            boolean polygonExists = false;
            for (Direction dir : Direction.values()) {
                BlockPos overlayPos = easPos.relative(dir).above();
                Collection<AlertPolygon> existingPolygons = AlertPolygonManager.getPolygonsAt(overlayPos);
                for (AlertPolygon existing : existingPolygons) {
                    if (existing.stormId != stormId) continue;
                    polygonExists = true;
                    LOGGER.info("EAS: Polygon for storm {} already exists at {}, skipping creation", (Object)stormId, (Object)overlayPos);
                    break;
                }
                if (polygonExists) break;
            }
            if (!polygonExists) {
                for (Direction dir : Direction.values()) {
                    BlockPos radarPos = easPos.relative(dir);
                    BlockState radarState = level.getBlockState(radarPos);
                    try {
                        float halfH;
                        float halfW;
                        Class<?> radarCls = Class.forName("dev.protomanly.pmweather.block.RadarBlock");
                        if (!radarCls.isInstance(radarState.getBlock())) continue;
                        BlockPos overlayPos = radarPos.above();
                        double radarRange = 1024.0;
                        double worldDx = stormPos.x - ((double)radarPos.getX() + 0.5);
                        double worldDz = stormPos.z - ((double)radarPos.getZ() + 0.5);
                        double cx = 0.5 + worldDx / (radarRange * 2.0);
                        double cz = 0.5 + worldDz / (radarRange * 2.0);
                        cx = Math.max(0.0, Math.min(1.0, cx));
                        cz = Math.max(0.0, Math.min(1.0, cz));
                        LOGGER.info("EAS: Storm at world pos ({}, {}) -> Radar at ({}, {}) -> World offset ({}, {}) -> Display coords ({}, {})", (Object)stormPos.x, (Object)stormPos.z, (Object)((double)radarPos.getX() + 0.5), (Object)((double)radarPos.getZ() + 0.5), (Object)worldDx, (Object)worldDz, (Object)cx, (Object)cz);
                        if (type == 0 && stage >= 3) {
                            halfW = 0.15f;
                            halfH = 0.1f;
                        } else if (type == 0) {
                            halfW = 0.25f;
                            halfH = 0.2f;
                        } else {
                            halfW = 0.4f;
                            halfH = 0.15f;
                        }
                        float movementAngle = (float)Math.toDegrees(Math.atan2(velocity.x, -velocity.z));
                        movementAngle = (movementAngle + 360.0f) % 360.0f;
                        float rotation = type == 1 ? (movementAngle + 90.0f) % 360.0f : movementAngle % 360.0f;
                        AlertPolygon poly = new AlertPolygon(stormId, cx, cz, halfW, halfH, rotation, polygonLevel, type, stage);
                        LOGGER.info("EAS: Created polygon for radar at {}: stormId={}, center=({},{}), size={}x{}, rotation={}, level={}, type={}, stage={}", (Object)radarPos, (Object)stormId, (Object)cx, (Object)cz, (Object)Float.valueOf(halfW * 2.0f), (Object)Float.valueOf(halfH * 2.0f), (Object)Float.valueOf(rotation), (Object)polygonLevel, (Object)type, (Object)stage);
                        AlertPolygonManager.addPolygon(overlayPos, poly);
                        BlockEntity overlayBE = level.getBlockEntity(overlayPos);
                        if (!(overlayBE instanceof RadarOverlayBlockEntity)) continue;
                        RadarOverlayBlockEntity radarOverlay = (RadarOverlayBlockEntity)overlayBE;
                        radarOverlay.setChanged();
                        radarOverlay.requestClientUpdate();
                        LOGGER.info("EAS: Polygon sent to radar overlay at {}", (Object)overlayPos);
                    }
                    catch (ClassNotFoundException e) {
                        LOGGER.info("EAS: PMWeather not installed, skipping radar detection");
                    }
                }
            }
        }
        for (ServerPlayer player : level.players()) {
            Component msg;
            if (!this.isPlayerBound(player, easPos, dimensionId)) continue;
            if ((switch (type) {
                case 0 -> {
                    if (stage >= 3) {
                        yield this.createTornadoMessage(alertLevel, time, windInfo);
                    }
                    yield this.createSupercellMessage(stage, time, windInfo);
                }
                case 1 -> this.createSquallMessage(stage, time, windInfo);
                default -> msg = null;
            }) == null) continue;
            player.sendSystemMessage(msg);
            player.playNotifySound(alertSound, SoundSource.MASTER, 1.0f, 1.0f);
        }
    }

    private Component createSquallMessage(int stage, String time, String windInfo) {
        String template = switch (stage) {
            case 1 -> "\u00a73--EAS BULLETIN--\u00a7r\nThe National Weather Service has issued a SEVERE THUNDERSTORM WARNING for your local area.\nAt %s, severe thunderstorms were located along a line, moving at %s\n\u00a74HAZARD:\u00a7r 60 mile per hour wind gusts and quarter size hail.\n\u00a74SOURCE:\u00a7r Radar indicated\n\u00a74IMPACT:\u00a7r Hail may damage entities and players.\n";
            case 2 -> "\u00a73--EAS BULLETIN--\u00a7r\nThe National Weather Service has issued a SEVERE THUNDERSTORM WARNING for your local area.\nAt %s, severe thunderstorms were located along a line, moving at %s\n\u00a74HAZARD:\u00a7r 70 mile per hour wind gusts and golf ball size hail.\n\u00a74SOURCE:\u00a7r Radar indicated\n\u00a74IMPACT:\u00a7r Hail may damage entities and players.\n";
            case 3 -> "\u00a73--EAS BULLETIN--\u00a7r\nThe National Weather Service has issued a SEVERE THUNDERSTORM WARNING for your local area.\nAt %s, severe thunderstorms were located along a line, moving at %s\n\u00a74These are DESTRUCTIVE STORMS for your local area.\u00a7r\n\u00a74HAZARD:\u00a7r 80 mile per hour or greater wind gusts and baseball size hail.\n\u00a74SOURCE:\u00a7r Radar indicated\n\u00a74IMPACT:\u00a7r Hail may damage entities and players.\n";
            default -> null;
        };
        return template != null ? Component.literal((String)String.format(template, time, windInfo)) : null;
    }

    private Component createSupercellMessage(int stage, String time, String windInfo) {
        String template = switch (stage) {
            case 1 -> "\u00a73--EAS BULLETIN--\u00a7r\nThe National Weather Service has issued a SEVERE THUNDERSTORM WARNING for your local area.\nAt %s, a severe thunderstorm was located near your area, moving at %s\n\u00a74HAZARD:\u00a7r 60 mile per hour wind gusts and quarter size hail.\n\u00a74SOURCE:\u00a7r Radar indicated\n\u00a74IMPACT:\u00a7r Hail may damage entities and players.\n";
            case 2 -> "\u00a73--EAS BULLETIN--\u00a7r\nThe National Weather Service has issued a SEVERE THUNDERSTORM WARNING for your local area.\nAt %s, a severe thunderstorm was located near your area, moving at %s\n\u00a74HAZARD:\u00a7r 70 mile per hour wind gusts and golf ball size hail.\n\u00a74SOURCE:\u00a7r Radar indicated\n\u00a74IMPACT:\u00a7r Hail may damage entities and players. \u00a7cA tornado may form at any moment.\nFor your protection, move into a sturdy building.\u00a7r\n";
            default -> null;
        };
        return template != null ? Component.literal((String)String.format(template, time, windInfo)) : null;
    }

    private Component createTornadoMessage(int alertLevel, String time, String windInfo) {
        switch (alertLevel) {
            case 1: {
                return Component.literal((String)String.format("\u00a7c--EAS BULLETIN--\u00a7r\nThe National Weather Service has issued a TORNADO WARNING for your local area.\nAt %s, a severe thunderstorm capable of producing a tornado was located near your area,\nmoving at %s\n\u00a74HAZARD:\u00a7r Tornado\n\u00a74SOURCE:\u00a7r Radar confirmed Tornado\n\u00a74IMPACT:\u00a7r Flying debris will be dangerous and may suffocate people. Homes may be damaged. If you are caught by the tornado, you may not be let go of for some time and may sustain fall damage.\n", time, windInfo));
            }
            case 2: {
                return Component.literal((String)String.format("\u00a7c--EAS BULLETIN--\u00a7r\nThe National Weather Service has issued a TORNADO WARNING for your local area.\n\u00a74This is a PARTICULARLY DANGEROUS SITUATION.\u00a7r\nAt %s, a confirmed large tornado was located near your area, moving at %s\n\u00a74HAZARD:\u00a7r Damaging tornado\n\u00a74SOURCE:\u00a7r Radar confirmed Tornado\n\u00a74IMPACT:\u00a7r Flying debris will be deadly and may suffocate people. Homes may be destroyed. If you are caught by the tornado, you may not be let go of for some time and may sustain fall damage once it dissipates.\n", time, windInfo));
            }
            case 3: {
                return Component.literal((String)String.format("\u00a74--TORNADO EMERGENCY FOR YOUR LOCAL AREA--\u00a7r\nThe National Weather Service has issued a TORNADO WARNING for your local area.\nAt %s, a confirmed large and extremely dangerous tornado was located near your area,\nmoving %s\n\u00a74This is a TORNADO EMERGENCY for your local area. Take shelter now!\u00a7r\n\u00a74HAZARD:\u00a7r Deadly tornado\n\u00a74SOURCE:\u00a7r Radar confirmed tornado\n\u00a74IMPACT:\u00a7r Flying debris will be dangerous and will suffocate people. Homes and towns will be damaged or destroyed, making it completely unrecognizable to survivors. If you are caught by the tornado, you may not be let go of for some time and WILL sustain deadly fall damage.\n", time, windInfo));
            }
        }
        return Component.literal((String)"\u00a7eNo current tornado threat detected.");
    }

    private boolean isPlayerBound(ServerPlayer player, BlockPos easPos, String dimensionId) {
        for (ItemStack stack : player.getInventory().items) {
            CompoundTag tag;
            CustomData data;
            if (!(stack.getItem() instanceof EasTransmitterItem) || (data = (CustomData)stack.get(DataComponents.CUSTOM_DATA)) == null || (tag = data.copyTag()).getLong("boundPos") != easPos.asLong() || !tag.getString("boundDim").equals(dimensionId)) continue;
            return true;
        }
        return false;
    }

    private void sendPolygonToRadarOverlays(ServerLevel level, BlockPos easPos, AlertPolygon polygon) {
        LOGGER.info("EAS: Attempting to send polygon from EAS at {} to nearby radars", (Object)easPos);
        for (Direction dir : Direction.values()) {
            BlockPos radarPos = easPos.relative(dir);
            BlockState radarState = level.getBlockState(radarPos);
            LOGGER.info("EAS: Checking position {} (direction {}) for radar block", (Object)radarPos, (Object)dir);
            LOGGER.info("EAS: Block at {} is: {}", (Object)radarPos, (Object)radarState.getBlock().getClass().getName());
            try {
                Class<?> radarCls = Class.forName("dev.protomanly.pmweather.block.RadarBlock");
                if (radarCls.isInstance(radarState.getBlock())) {
                    LOGGER.info("EAS: Found radar block at {}!", (Object)radarPos);
                    BlockPos overlayPos = radarPos.above();
                    LOGGER.info("EAS: Looking for radar overlay at {} (above radar)", (Object)overlayPos);
                    BlockEntity overlayBE = level.getBlockEntity(overlayPos);
                    LOGGER.info("EAS: Block entity at overlay position: {}", (Object)(overlayBE != null ? overlayBE.getClass().getName() : "null"));
                    if (overlayBE instanceof RadarOverlayBlockEntity) {
                        RadarOverlayBlockEntity radarOverlay = (RadarOverlayBlockEntity)overlayBE;
                        LOGGER.info("EAS: Found radar overlay! Sending polygon...");
                        AlertPolygonManager.addPolygon(overlayPos, polygon);
                        LOGGER.info("EAS: Polygon added to manager for position {}", (Object)overlayPos);
                        radarOverlay.setChanged();
                        radarOverlay.requestClientUpdate();
                        LOGGER.info("EAS: Client update requested for radar overlay at {}", (Object)overlayPos);
                        int polyCount = AlertPolygonManager.getPolygonsAt(overlayPos).size();
                        LOGGER.info("EAS: Polygon manager now has {} polygons for position {}", (Object)polyCount, (Object)overlayPos);
                        continue;
                    }
                    LOGGER.warn("EAS: No radar overlay block entity found at {} (above radar at {})", (Object)overlayPos, (Object)radarPos);
                    BlockState overlayState = level.getBlockState(overlayPos);
                    if (!overlayState.isAir()) continue;
                    LOGGER.info("EAS: Placing missing radar overlay block at {}", (Object)overlayPos);
                    level.setBlock(overlayPos, ((RadarOverlayBlock)((Object)RegistryHandler.RADAR_OVERLAY_BLOCK.get())).defaultBlockState(), 3);
                    BlockEntity newOverlayBE = level.getBlockEntity(overlayPos);
                    if (!(newOverlayBE instanceof RadarOverlayBlockEntity)) continue;
                    RadarOverlayBlockEntity newRadarOverlay = (RadarOverlayBlockEntity)newOverlayBE;
                    AlertPolygonManager.addPolygon(overlayPos, polygon);
                    newRadarOverlay.setChanged();
                    newRadarOverlay.requestClientUpdate();
                    LOGGER.info("EAS: Successfully placed and configured new radar overlay at {}", (Object)overlayPos);
                    continue;
                }
                LOGGER.info("EAS: Block at {} is not a radar block", (Object)radarPos);
            }
            catch (ClassNotFoundException e) {
                LOGGER.info("EAS: PMWeather not installed, skipping radar detection");
            }
        }
        LOGGER.info("EAS: Finished checking all directions for radar blocks");
    }

    private record StormKey(BlockPos pos, int type) {
    }
}

