/*
 * Decompiled with CFR 0.152.
 */
package com.burrows.easaddon;

import com.burrows.easaddon.AlertPolygonManager;
import com.burrows.easaddon.RadarOverlayBlockEntity;
import com.mojang.serialization.MapCodec;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.apache.logging.log4j.LogManager;
import org.jetbrains.annotations.Nullable;

public class RadarOverlayBlock
extends BaseEntityBlock {
    public RadarOverlayBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new RadarOverlayBlockEntity(pos, state);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        BlockPos radarPos = pos.below();
        BlockState radarState = level.getBlockState(radarPos);
        Block radarBlock = radarState.getBlock();
        try {
            Class<?> radarCls = Class.forName("dev.protomanly.pmweather.block.RadarBlock");
            if (radarCls.isInstance(radarBlock)) {
                BlockHitResult radarHit = new BlockHitResult(hit.getLocation(), hit.getDirection(), radarPos, hit.isInside());
                Method useMethod = radarCls.getDeclaredMethod("useWithoutItem", BlockState.class, Level.class, BlockPos.class, Player.class, BlockHitResult.class);
                useMethod.setAccessible(true);
                return (InteractionResult)useMethod.invoke((Object)radarBlock, radarState, level, radarPos, player, radarHit);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            LogManager.getLogger((String)"EASAddon").warn("EAS: Failed to pass interaction to radar block: {}", (Object)e.getMessage());
        }
        return InteractionResult.PASS;
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        super.neighborChanged(state, level, pos, neighborBlock, neighborPos, movedByPiston);
        if (!level.isClientSide()) {
            this.checkRadarBelow(level, pos);
        }
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        super.tick(state, level, pos, random);
        this.checkRadarBelow((Level)level, pos);
    }

    private void checkRadarBelow(Level level, BlockPos overlayPos) {
        BlockPos radarPos = overlayPos.below();
        BlockState radarState = level.getBlockState(radarPos);
        boolean isRadarBlock = false;
        try {
            Class<?> radarCls = Class.forName("dev.protomanly.pmweather.block.RadarBlock");
            isRadarBlock = radarCls.isInstance(radarState.getBlock());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (!isRadarBlock) {
            level.destroyBlock(overlayPos, false);
            AlertPolygonManager.clearPolygons(overlayPos);
            LogManager.getLogger((String)"EASAddon").info("EAS: Removed radar overlay at {} - no radar block found below", (Object)overlayPos);
        }
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return MapCodec.unit((Object)((Object)this));
    }
}

