/*
 * Decompiled with CFR 0.152.
 */
package com.burrows.easaddon;

import com.burrows.easaddon.AlertPolygonManager;
import com.burrows.easaddon.RegistryHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class RadarOverlayBlockEntity
extends BlockEntity {
    private static final Logger LOGGER = LogManager.getLogger((String)"EASAddon");

    public RadarOverlayBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)RegistryHandler.RADAR_OVERLAY_BE.get(), pos, state);
        LOGGER.info("RadarOverlayBlockEntity: Created at position {}", (Object)pos);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.saveAdditional(tag, lookupProvider);
        LOGGER.info("RadarOverlayBlockEntity: saveAdditional called for position {}", (Object)this.worldPosition);
        AlertPolygonManager.writePolygons(this.worldPosition, tag);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.loadAdditional(tag, lookupProvider);
        LOGGER.info("RadarOverlayBlockEntity: loadAdditional called for position {}", (Object)this.worldPosition);
        if (tag.contains("polygons")) {
            LOGGER.info("RadarOverlayBlockEntity: Found polygons tag, reading polygons");
            AlertPolygonManager.readPolygons(this.worldPosition, tag);
        } else {
            LOGGER.info("RadarOverlayBlockEntity: No polygons tag found in NBT");
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider lookupProvider) {
        LOGGER.info("RadarOverlayBlockEntity: getUpdateTag called for position {}", (Object)this.worldPosition);
        CompoundTag tag = super.getUpdateTag(lookupProvider);
        this.saveAdditional(tag, lookupProvider);
        if (tag.contains("polygons")) {
            LOGGER.info("RadarOverlayBlockEntity: getUpdateTag includes polygons tag");
        } else {
            LOGGER.warn("RadarOverlayBlockEntity: getUpdateTag does NOT include polygons tag");
        }
        return tag;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        super.onDataPacket(net, pkt, lookupProvider);
        LOGGER.info("RadarOverlayBlockEntity: onDataPacket called for position {}", (Object)this.worldPosition);
        CompoundTag tag = pkt.getTag();
        if (tag != null && tag.contains("polygons")) {
            LOGGER.info("RadarOverlayBlockEntity: Data packet contains polygons, reading them");
            AlertPolygonManager.readPolygons(this.worldPosition, tag);
            AlertPolygonManager.debugPrintState();
        } else {
            LOGGER.info("RadarOverlayBlockEntity: Data packet has no polygons - clearing all polygons for this position");
            AlertPolygonManager.clearPolygons(this.worldPosition);
        }
    }

    public void requestClientUpdate() {
        LOGGER.info("RadarOverlayBlockEntity: requestClientUpdate called for position {}", (Object)this.worldPosition);
        if (this.level != null) {
            int polyCount = AlertPolygonManager.getPolygonsAt(this.worldPosition).size();
            LOGGER.info("RadarOverlayBlockEntity: About to sync {} polygons to client", (Object)polyCount);
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 2);
            LOGGER.info("RadarOverlayBlockEntity: Block update sent for position {}", (Object)this.worldPosition);
        } else {
            LOGGER.warn("RadarOverlayBlockEntity: Cannot request client update - level is null");
        }
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider registries) {
        super.handleUpdateTag(tag, registries);
        LOGGER.info("RadarOverlayBlockEntity: Handling update tag for position {}", (Object)this.getBlockPos());
        if (tag.contains("polygons")) {
            LOGGER.info("RadarOverlayBlockEntity: Update tag contains polygons, reading them");
            AlertPolygonManager.readPolygons(this.getBlockPos(), tag);
        } else {
            LOGGER.info("RadarOverlayBlockEntity: Update tag has no polygons - clearing all polygons for this position");
            AlertPolygonManager.clearPolygons(this.getBlockPos());
        }
    }

    public void setRemoved() {
        super.setRemoved();
        LOGGER.info("RadarOverlayBlockEntity: Block entity removed, clearing polygons for position {}", (Object)this.getBlockPos());
        AlertPolygonManager.clearPolygons(this.getBlockPos());
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        LOGGER.info("RadarOverlayBlockEntity: getUpdatePacket called for position {}", (Object)this.worldPosition);
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }
}

