/*
 * Decompiled with CFR 0.152.
 */
package com.burrows.easaddon;

import com.burrows.easaddon.EASBlock;
import com.burrows.easaddon.EASBlockEntity;
import com.burrows.easaddon.EasTransmitterItem;
import com.burrows.easaddon.RadarOverlayBlock;
import com.burrows.easaddon.RadarOverlayBlockEntity;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.RegisterEvent;

public class RegistryHandler {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((ResourceKey)Registries.BLOCK, (String)"easaddon");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((ResourceKey)Registries.ITEM, (String)"easaddon");
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((ResourceKey)Registries.BLOCK_ENTITY_TYPE, (String)"easaddon");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"easaddon");
    public static final DeferredRegister<SoundEvent> SOUNDS = DeferredRegister.create((ResourceKey)Registries.SOUND_EVENT, (String)"easaddon");
    public static final DeferredHolder<Block, EASBlock> EAS_BLOCK = BLOCKS.register("eas_block", () -> new EASBlock(BlockBehaviour.Properties.of().strength(1.5f).lightLevel(s -> 3)));
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<EASBlockEntity>> EAS_BLOCK_ENTITY = BLOCK_ENTITIES.register("eas_block_entity", () -> BlockEntityType.Builder.of(EASBlockEntity::new, (Block[])new Block[]{(Block)EAS_BLOCK.get()}).build(null));
    public static final DeferredHolder<Item, Item> EAS_BLOCK_ITEM = ITEMS.register("eas_block", () -> new BlockItem((Block)EAS_BLOCK.get(), new Item.Properties()));
    public static final DeferredHolder<Item, EasTransmitterItem> EAS_TRANSMITTER = ITEMS.register("eas_transmitter", () -> new EasTransmitterItem(new Item.Properties().stacksTo(1)));
    public static final DeferredHolder<SoundEvent, SoundEvent> EAS_ALERT = SOUNDS.register("eas_alert", () -> SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.parse((String)"easaddon:eas_alert")));
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> MAIN_TAB = CREATIVE_TABS.register("main", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"itemGroup.easaddon.main")).icon(() -> new ItemStack((ItemLike)EAS_BLOCK_ITEM.get())).displayItems((params, output) -> {
        output.accept((ItemLike)EAS_BLOCK_ITEM.get());
        output.accept((ItemLike)EAS_TRANSMITTER.get());
    }).build());
    public static final DeferredHolder<Block, RadarOverlayBlock> RADAR_OVERLAY_BLOCK = BLOCKS.register("radar_overlay", () -> new RadarOverlayBlock(BlockBehaviour.Properties.of().noCollission().strength(0.1f).noOcclusion().lightLevel(s -> 0)));
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<RadarOverlayBlockEntity>> RADAR_OVERLAY_BE = BLOCK_ENTITIES.register("radar_overlay", () -> BlockEntityType.Builder.of(RadarOverlayBlockEntity::new, (Block[])new Block[]{(Block)RADAR_OVERLAY_BLOCK.get()}).build(null));
    public static final DeferredHolder<Item, BlockItem> RADAR_OVERLAY_ITEM = ITEMS.register("radar_overlay", () -> new BlockItem((Block)RADAR_OVERLAY_BLOCK.get(), new Item.Properties()));
    private static boolean blocksRegistered = false;
    private static boolean itemsRegistered = false;
    private static boolean blockEntitiesRegistered = false;

    public static void register(IEventBus modEventBus) {
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        BLOCK_ENTITIES.register(modEventBus);
        CREATIVE_TABS.register(modEventBus);
        SOUNDS.register(modEventBus);
        modEventBus.addListener(RegistryHandler::onRegistryEvent);
    }

    private static void onRegistryEvent(RegisterEvent event) {
        if (event.getRegistryKey().equals(Registries.BLOCK)) {
            blocksRegistered = true;
        }
        if (event.getRegistryKey().equals(Registries.ITEM)) {
            itemsRegistered = true;
        }
        if (event.getRegistryKey().equals(Registries.BLOCK_ENTITY_TYPE)) {
            blockEntitiesRegistered = true;
        }
    }

    public static void verifyRegistration() {
    }
}

