/*
 * Decompiled with CFR 0.152.
 */
package com.burrows.easaddon.client;

import com.burrows.easaddon.AlertPolygon;
import com.burrows.easaddon.AlertPolygonManager;
import com.burrows.easaddon.RadarOverlayBlockEntity;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.slf4j.Logger;

public class RadarOverlayRenderer
implements BlockEntityRenderer<RadarOverlayBlockEntity> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<Long, CachedPolygonData> polygonCache = new ConcurrentHashMap<Long, CachedPolygonData>();
    private static final Map<Long, Boolean> loggedPolygons = new ConcurrentHashMap<Long, Boolean>();
    private static final float RADAR_DISPLAY_SIZE = 1.0f;
    private static final float RENDER_HEIGHT = 0.05f;
    private static final float ROTATION_CORRECTION = 180.0f;
    private static final float MIN_POLYGON_SIZE = 0.2f;
    private static final float LINE_WIDTH = 0.015f;
    private static final Map<Long, String> polygonDataHash = new ConcurrentHashMap<Long, String>();

    public RadarOverlayRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(RadarOverlayBlockEntity be, float partialTicks, PoseStack poseStack, MultiBufferSource buffers, int packedLight, int packedOverlay) {
        ArrayList<AlertPolygon> polys;
        BlockPos pos = be.getBlockPos();
        Collection<AlertPolygon> originalPolys = AlertPolygonManager.getPolygonsAt(pos);
        if (originalPolys.isEmpty()) {
            this.clearAllCaches();
            return;
        }
        try {
            polys = new ArrayList<AlertPolygon>(originalPolys);
        }
        catch (Exception e) {
            LOGGER.warn("RadarOverlayRenderer: Failed to copy polygon collection, skipping render: {}", (Object)e.getMessage());
            return;
        }
        if (polys.isEmpty()) {
            this.clearAllCaches();
            return;
        }
        Set activeStormIds = polys.stream().map(p -> p.stormId).collect(Collectors.toSet());
        int removedCacheEntries = 0;
        for (Long stormId : new ArrayList<Long>(polygonCache.keySet())) {
            if (activeStormIds.contains(stormId)) continue;
            polygonCache.remove(stormId);
            polygonDataHash.remove(stormId);
            loggedPolygons.remove(stormId);
            ++removedCacheEntries;
        }
        if (removedCacheEntries > 0) {
            LOGGER.info("RadarOverlayRenderer: Removed {} cached storm entries that are no longer active", (Object)removedCacheEntries);
        }
        if (!polys.isEmpty()) {
            AlertPolygon alertPolygon = (AlertPolygon)polys.get(0);
        }
        Matrix4fStack mvStack = RenderSystem.getModelViewStack();
        mvStack.pushMatrix();
        mvStack.mul((Matrix4fc)poseStack.last().pose());
        mvStack.translate(0.0f, 0.05f, 0.0f);
        RenderSystem.applyModelViewMatrix();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.disableCull();
        Tesselator tess = Tesselator.getInstance();
        BufferBuilder buf = tess.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        for (AlertPolygon poly : polys) {
            try {
                CachedPolygonData cached = this.getCachedPolygonData(poly);
                this.renderPolygonOutline(buf, cached.corners, cached.r, cached.g, cached.b, cached.a);
            }
            catch (Exception e) {
                LOGGER.warn("RadarOverlayRenderer: Failed to render polygon {}: {}", (Object)poly.stormId, (Object)e.getMessage());
            }
        }
        MeshData mesh = buf.build();
        if (mesh != null) {
            BufferUploader.drawWithShader((MeshData)mesh);
        }
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
        mvStack.popMatrix();
        RenderSystem.applyModelViewMatrix();
        if (System.currentTimeMillis() % 5000L < 50L) {
            this.cleanupCache();
        }
    }

    private void clearAllCaches() {
        polygonCache.clear();
        polygonDataHash.clear();
        loggedPolygons.clear();
    }

    private void renderPolygonOutline(BufferBuilder buf, Vector3f[] corners, float r, float g, float b, float a) {
        for (int i = 0; i < 4; ++i) {
            Vector3f start = corners[i];
            Vector3f end = corners[(i + 1) % 4];
            float dx = end.x - start.x;
            float dz = end.z - start.z;
            float length = (float)Math.sqrt(dx * dx + dz * dz);
            if ((double)length < 1.0E-5) continue;
            float invLength = 1.0f / length;
            float dirX = dx * invLength;
            float dirZ = dz * invLength;
            float perpX = -dirZ * 0.015f;
            float perpZ = dirX * 0.015f;
            float extension = 0.0075f;
            Vector3f extendedStart = new Vector3f(start.x - dirX * extension, start.y, start.z - dirZ * extension);
            Vector3f extendedEnd = new Vector3f(end.x + dirX * extension, end.y, end.z + dirZ * extension);
            Vector3f topLeft = new Vector3f(extendedStart.x + perpX, extendedStart.y, extendedStart.z + perpZ);
            Vector3f bottomLeft = new Vector3f(extendedStart.x - perpX, extendedStart.y, extendedStart.z - perpZ);
            Vector3f bottomRight = new Vector3f(extendedEnd.x - perpX, extendedEnd.y, extendedEnd.z - perpZ);
            Vector3f topRight = new Vector3f(extendedEnd.x + perpX, extendedEnd.y, extendedEnd.z + perpZ);
            buf.addVertex(topLeft.x, topLeft.y, topLeft.z).setColor(r, g, b, a);
            buf.addVertex(topRight.x, topRight.y, topRight.z).setColor(r, g, b, a);
            buf.addVertex(bottomRight.x, bottomRight.y, bottomRight.z).setColor(r, g, b, a);
            buf.addVertex(bottomLeft.x, bottomLeft.y, bottomLeft.z).setColor(r, g, b, a);
        }
    }

    private CachedPolygonData getCachedPolygonData(AlertPolygon poly) {
        long cacheKey = poly.stormId;
        CachedPolygonData cached = polygonCache.get(cacheKey);
        if (cached == null || this.needsRecalculation(poly, cached)) {
            cached = this.calculatePolygonData(poly);
            polygonCache.put(cacheKey, cached);
            if (!loggedPolygons.getOrDefault(cacheKey, false).booleanValue()) {
                LOGGER.info("RadarOverlayRenderer: Cached new polygon data for storm {} at display coords ({}, {})", new Object[]{poly.stormId, poly.centerX, poly.centerZ});
                loggedPolygons.put(cacheKey, true);
            }
        }
        return cached;
    }

    private boolean needsRecalculation(AlertPolygon poly, CachedPolygonData cached) {
        String lastHash;
        String currentHash = String.format("%.3f,%.3f,%.3f,%.3f,%.1f,%d,%d,%d", poly.centerX, poly.centerZ, Float.valueOf(poly.halfWidth), Float.valueOf(poly.halfHeight), Float.valueOf(poly.rotationDeg), poly.level, poly.stormType, poly.stormStage);
        if (!currentHash.equals(lastHash = polygonDataHash.get(poly.stormId))) {
            polygonDataHash.put(poly.stormId, currentHash);
            return true;
        }
        return System.currentTimeMillis() - cached.lastUpdateTime > 5000L;
    }

    private CachedPolygonData calculatePolygonData(AlertPolygon poly) {
        float worldX = (float)(poly.centerX * 1.0);
        float worldZ = (float)(poly.centerZ * 1.0);
        float baseWidth = Math.max(poly.halfWidth * 1.0f, 0.2f);
        float baseHeight = Math.max(poly.halfHeight * 1.0f, 0.2f);
        float baseHw = baseWidth * 1.5f;
        float hh = baseHeight * 0.75f;
        LOGGER.info("RadarOverlayRenderer: Storm {} - Input coords: ({}, {}), World coords: ({}, {}), Base Size: {}x{}, Final Size: {}x{}", new Object[]{poly.stormId, poly.centerX, poly.centerZ, Float.valueOf(worldX), Float.valueOf(worldZ), Float.valueOf(baseWidth * 2.0f), Float.valueOf(baseHeight * 2.0f), Float.valueOf(baseHw * 2.0f), Float.valueOf(hh * 2.0f)});
        float correctedRotation = poly.rotationDeg + 180.0f;
        double radians = Math.toRadians(correctedRotation);
        float cos = (float)Math.cos(radians);
        float sin = (float)Math.sin(radians);
        Vector3f[] corners = new Vector3f[4];
        if (poly.stormType == 0) {
            float hh2 = baseHeight * 1.5f;
            float trapezoidal_factor = 0.36f;
            float front_width_multiplier = 1.0f - trapezoidal_factor;
            float back_width_multiplier = 1.0f + trapezoidal_factor;
            float front_hw = baseWidth * 0.75f * front_width_multiplier;
            float back_hw = baseWidth * 0.75f * back_width_multiplier;
            corners[0] = new Vector3f(-front_hw * cos - -hh2 * sin + worldX, 0.05f, -front_hw * sin + -hh2 * cos + worldZ);
            corners[1] = new Vector3f(front_hw * cos - -hh2 * sin + worldX, 0.05f, front_hw * sin + -hh2 * cos + worldZ);
            corners[2] = new Vector3f(back_hw * cos - hh2 * sin + worldX, 0.05f, back_hw * sin + hh2 * cos + worldZ);
            corners[3] = new Vector3f(-back_hw * cos - hh2 * sin + worldX, 0.05f, -back_hw * sin + hh2 * cos + worldZ);
            LOGGER.info("RadarOverlayRenderer: Storm {} - Trapezoid shape: Front width: {}, Back width: {}, Length: {}", new Object[]{poly.stormId, Float.valueOf(front_hw * 2.0f), Float.valueOf(back_hw * 2.0f), Float.valueOf(hh2 * 2.0f)});
        } else {
            float correctedRotation1 = poly.rotationDeg + 90.0f;
            double radians1 = Math.toRadians(correctedRotation1);
            float cos1 = (float)Math.cos(radians1);
            float sin1 = (float)Math.sin(radians1);
            float hw = baseHw;
            float hh2 = baseHeight * 1.5f;
            corners[0] = new Vector3f(-hw * cos1 - -hh2 * sin1 + worldX, 0.05f, -hw * sin1 + -hh2 * cos1 + worldZ);
            corners[1] = new Vector3f(hw * cos1 - -hh2 * sin1 + worldX, 0.05f, hw * sin1 + -hh2 * cos1 + worldZ);
            corners[2] = new Vector3f(hw * cos1 - hh2 * sin1 + worldX, 0.05f, hw * sin1 + hh2 * cos1 + worldZ);
            corners[3] = new Vector3f(-hw * cos1 - hh2 * sin1 + worldX, 0.05f, -hw * sin1 + hh2 * cos1 + worldZ);
            LOGGER.info("RadarOverlayRenderer: Storm {} - Rectangle shape: Width: {}, Height: {}", new Object[]{poly.stormId, Float.valueOf(hw * 2.0f), Float.valueOf(hh2 * 2.0f)});
        }
        LOGGER.info("RadarOverlayRenderer: Storm {} - Final corners: FL({}, {}, {}), FR({}, {}, {}), BR({}, {}, {}), BL({}, {}, {})", new Object[]{poly.stormId, Float.valueOf(corners[0].x), Float.valueOf(corners[0].y), Float.valueOf(corners[0].z), Float.valueOf(corners[1].x), Float.valueOf(corners[1].y), Float.valueOf(corners[1].z), Float.valueOf(corners[2].x), Float.valueOf(corners[2].y), Float.valueOf(corners[2].z), Float.valueOf(corners[3].x), Float.valueOf(corners[3].y), Float.valueOf(corners[3].z)});
        float[] color = this.calculatePolygonColor(poly);
        return new CachedPolygonData(corners, color[0], color[1], color[2], color[3]);
    }

    private float[] calculatePolygonColor(AlertPolygon poly) {
        float b;
        float g;
        float r;
        int validatedStormType = Math.max(0, Math.min(1, poly.stormType));
        int validatedStormStage = Math.max(1, Math.min(3, poly.stormStage));
        int validatedLevel = Math.max(0, Math.min(3, poly.level));
        float a = 0.6f;
        if (validatedStormType == 0) {
            if (validatedStormStage == 3) {
                if (validatedLevel >= 3) {
                    r = 0.5f;
                    g = 0.0f;
                    b = 0.5f;
                } else if (validatedLevel >= 2) {
                    r = 0.8f;
                    g = 0.0f;
                    b = 0.0f;
                } else {
                    r = 1.0f;
                    g = 0.0f;
                    b = 0.0f;
                }
            } else if (validatedStormStage <= 2) {
                r = 1.0f;
                g = 1.0f;
                b = 0.0f;
            } else {
                r = 1.0f;
                g = 1.0f;
                b = 0.0f;
            }
        } else if (validatedStormType == 1) {
            r = 1.0f;
            g = 1.0f;
            b = 0.0f;
        } else {
            r = 1.0f;
            g = 1.0f;
            b = 1.0f;
        }
        LOGGER.info("RadarOverlayRenderer: Storm type is validated as {}, stormType returns {}", (Object)validatedStormType, (Object)poly.stormType);
        return new float[]{r, g, b, a};
    }

    private void cleanupCache() {
        long currentTime = System.currentTimeMillis();
        polygonCache.entrySet().removeIf(entry -> currentTime - ((CachedPolygonData)entry.getValue()).lastUpdateTime > 30000L);
        polygonDataHash.keySet().retainAll(polygonCache.keySet());
        if (polygonCache.isEmpty()) {
            loggedPolygons.clear();
            polygonDataHash.clear();
        }
    }

    private static class CachedPolygonData {
        final Vector3f[] corners;
        final float r;
        final float g;
        final float b;
        final float a;
        final long lastUpdateTime;

        CachedPolygonData(Vector3f[] corners, float r, float g, float b, float a) {
            this.corners = corners;
            this.r = r;
            this.g = g;
            this.b = b;
            this.a = a;
            this.lastUpdateTime = System.currentTimeMillis();
        }
    }
}

