/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.inline_tooltips;

import cc.cassian.inline_tooltips.Platform;
import cc.cassian.inline_tooltips.config.ModConfig;
import cc.cassian.inline_tooltips.helpers.ModHelpers;
import cc.cassian.inline_tooltips.helpers.SharpnessHelpers;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.objects.AtlasSprite;
import net.minecraft.network.chat.contents.objects.ObjectInfo;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.Bees;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.LodestoneTracker;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LightBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.text.WordUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InlineTooltips {
    public static final String MOD_ID = "inline_tooltips";
    public static final ModConfig CONFIG = (ModConfig)ModConfig.createToml((Path)Platform.INSTANCE.getConfigDir(), (String)"", (String)"inline_tooltips", ModConfig.class);
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"inline_tooltips");

    public static void addTooltips(ItemStack itemStack, Item.TooltipContext tooltipContext, TooltipFlag tooltipFlag, List<Component> list) {
        MutableComponent component = Component.empty();
        if (!ModHelpers.hasShiftDown()) {
            InlineTooltips.addAttributeTooltips(itemStack, list, component);
        }
        InlineTooltips.addBeeTooltips(itemStack, list, component);
        InlineTooltips.addFuelTooltips(itemStack, list, component);
        InlineTooltips.addHoneyTooltips(itemStack, list, component);
        InlineTooltips.addLightLevelTooltips(itemStack, list, component);
        if (!component.equals((Object)Component.empty())) {
            list.add((Component)component);
        }
        if (InlineTooltips.CONFIG.textTooltips.lodestoneTooltip && itemStack.has(DataComponents.LODESTONE_TRACKER)) {
            LodestoneTracker state = (LodestoneTracker)itemStack.get(DataComponents.LODESTONE_TRACKER);
            if (state == null || state.target().isEmpty()) {
                return;
            }
            InlineTooltips.addCoordinates((GlobalPos)state.target().get(), list, "target", ModHelpers.getColour(InlineTooltips.CONFIG.textTooltips.lodestoneCompassTooltipColor, ChatFormatting.GOLD));
        }
        if (InlineTooltips.CONFIG.textTooltips.recoveryCompassTooltip && itemStack.is(Items.RECOVERY_COMPASS)) {
            Optional lastDeath = Minecraft.getInstance().player.getLastDeathLocation();
            if (lastDeath.isEmpty()) {
                return;
            }
            InlineTooltips.addCoordinates((GlobalPos)lastDeath.get(), list, "target", ModHelpers.getColour(InlineTooltips.CONFIG.textTooltips.recoveryCompassTooltipColor, ChatFormatting.AQUA));
        }
        if (InlineTooltips.CONFIG.textTooltips.compassTooltip && itemStack.is(Items.COMPASS) && !itemStack.has(DataComponents.LODESTONE_TRACKER)) {
            BlockPos pos = Minecraft.getInstance().player.blockPosition();
            InlineTooltips.addCoordinates(pos, list, "position", ModHelpers.getColour(InlineTooltips.CONFIG.textTooltips.compassTooltipColor, ChatFormatting.RED));
        }
        if (InlineTooltips.CONFIG.textTooltips.durabilityTooltip && !tooltipFlag.isAdvanced() && itemStack.isDamaged() && itemStack.has(DataComponents.DAMAGE)) {
            list.add((Component)Component.translatable((String)"item.durability", (Object[])new Object[]{itemStack.getMaxDamage() - itemStack.getDamageValue(), itemStack.getMaxDamage()}).withColor(ModHelpers.getColour(InlineTooltips.CONFIG.textTooltips.durabilityTooltipColor, ChatFormatting.GRAY).intValue()));
        }
        if ((InlineTooltips.CONFIG.clockTooltip.current_time || InlineTooltips.CONFIG.clockTooltip.day_count) && itemStack.is(Items.CLOCK)) {
            list.add((Component)Component.literal((String)InlineTooltips.getTime(Minecraft.getInstance().level.getDayTime())).withColor(ModHelpers.getColour(InlineTooltips.CONFIG.clockTooltip.text_color, ChatFormatting.GOLD).intValue()));
        }
    }

    private static void addCoordinates(GlobalPos globalPos, List<Component> list, String target, Integer colour) {
        InlineTooltips.addCoordinates(globalPos.pos(), list, target, colour);
        list.add((Component)Component.translatable((String)"gui.inline_tooltips.dimension").withStyle(ChatFormatting.GRAY).append((Component)Component.translatableWithFallback((String)globalPos.dimension().location().toLanguageKey("dimension"), (String)WordUtils.capitalizeFully((String)globalPos.dimension().location().getPath())).withColor(colour.intValue())));
    }

    private static void addCoordinates(BlockPos pos, List<Component> list, String target, Integer colour) {
        list.add((Component)Component.translatable((String)("gui.inline_tooltips." + target)).withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)"X: %d, Y: %d, Z: %d".formatted(pos.getX(), pos.getY(), pos.getZ())).withColor(colour.intValue())));
    }

    public static String getTime(float dayTime) {
        StringBuilder currentTime = new StringBuilder();
        if (InlineTooltips.CONFIG.clockTooltip.day_count) {
            int day = (int)(dayTime / 24000.0f);
            currentTime.append(I18n.get((String)"gui.c.day", (Object[])new Object[]{day}));
            if (InlineTooltips.CONFIG.clockTooltip.current_time) {
                currentTime.append(", ");
            }
        }
        if (InlineTooltips.CONFIG.clockTooltip.current_time) {
            int time = (int)(dayTime + 6000.0f) % 24000;
            int m = (int)((float)time % 1000.0f / 1000.0f * 60.0f);
            int hour = time / 1000;
            String a = "";
            if (InlineTooltips.CONFIG.clockTooltip.twenty_four_hour_clock) {
                String string = a = time < 12000 ? " AM" : " PM";
                if ((hour %= 12) == 0) {
                    hour = 12;
                }
            }
            currentTime.append(hour).append(":").append(m < 10 ? "0" : "").append(m).append(a);
        }
        return currentTime.toString();
    }

    private static void addAttributeTooltips(ItemStack itemStack, List<Component> list, MutableComponent component) {
        if (InlineTooltips.CONFIG.iconTooltips.attributeTooltips) {
            for (EquipmentSlotGroup equipmentSlotGroup : EquipmentSlotGroup.values()) {
                itemStack.forEachModifier(equipmentSlotGroup, (holder, attributeModifier, display) -> {
                    if (display != ItemAttributeModifiers.Display.hidden()) {
                        LocalPlayer player = Minecraft.getInstance().player;
                        AtomicReference<Double> amount = new AtomicReference<Double>(attributeModifier.amount());
                        if (player != null) {
                            amount.set(switch (attributeModifier.operation()) {
                                default -> throw new MatchException(null, null);
                                case AttributeModifier.Operation.ADD_VALUE -> attributeModifier.amount() + player.getAttributeBaseValue(holder);
                                case AttributeModifier.Operation.ADD_MULTIPLIED_BASE, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL -> attributeModifier.amount() * player.getAttributeBaseValue(holder);
                            });
                        }
                        amount.set(SharpnessHelpers.addSharpnessDamage(itemStack, amount.get(), (Player)player, attributeModifier));
                        ResourceLocation icon = ((ResourceKey)holder.unwrapKey().orElseThrow()).location();
                        if (amount.get() != 0.0) {
                            InlineTooltips.addIcon(icon, amount.get(), list, component);
                        }
                    }
                });
            }
        }
    }

    private static void addBeeTooltips(ItemStack itemStack, List<Component> list, MutableComponent component) {
        if (itemStack.has(DataComponents.BEES) && InlineTooltips.CONFIG.iconTooltips.beesTooltip) {
            Bees bees = (Bees)itemStack.get(DataComponents.BEES);
            if (bees == null) {
                return;
            }
            InlineTooltips.addIcon(InlineTooltips.id("bees"), bees.bees().size(), list, component);
        }
    }

    private static void addFuelTooltips(ItemStack itemStack, List<Component> list, MutableComponent component) {
        ClientLevel level;
        if (InlineTooltips.CONFIG.iconTooltips.fuelTooltip && (level = Minecraft.getInstance().level) != null && level.fuelValues().isFuel(itemStack)) {
            InlineTooltips.addIcon(InlineTooltips.id("fuel"), (float)level.fuelValues().burnDuration(itemStack) / 200.0f, list, component);
        }
    }

    private static void addHoneyTooltips(ItemStack itemStack, List<Component> list, MutableComponent component) {
        if (InlineTooltips.CONFIG.iconTooltips.honeyTooltip && itemStack.has(DataComponents.BLOCK_STATE)) {
            BlockItemStateProperties state = (BlockItemStateProperties)itemStack.get(DataComponents.BLOCK_STATE);
            if (state == null) {
                return;
            }
            Integer honey = (Integer)state.get((Property)BeehiveBlock.HONEY_LEVEL);
            if (honey == null) {
                return;
            }
            InlineTooltips.addIcon(InlineTooltips.id("honey"), honey.intValue(), list, component);
        }
    }

    private static void addLightLevelTooltips(ItemStack itemStack, List<Component> list, MutableComponent component) {
        Item item;
        if (InlineTooltips.CONFIG.iconTooltips.lightLevelTooltip && (item = itemStack.getItem()) instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            if (blockItem.getBlock() == Blocks.LIGHT) {
                Integer light;
                BlockItemStateProperties stateComponent = (BlockItemStateProperties)itemStack.get(DataComponents.BLOCK_STATE);
                Integer n = light = stateComponent != null ? (Integer)stateComponent.get((Property)LightBlock.LEVEL) : null;
                if (light != null && light != 0) {
                    InlineTooltips.addIcon(InlineTooltips.id("light"), light.intValue(), list, component);
                }
            } else {
                BlockState state = blockItem.getBlock().defaultBlockState();
                int light = state.getLightEmission();
                if (light != 0) {
                    InlineTooltips.addIcon(InlineTooltips.id("light"), light, list, component);
                }
            }
        }
    }

    private static void addIcon(ResourceLocation attribute, double amount, List<Component> list, MutableComponent component) {
        ResourceLocation icon = ResourceLocation.fromNamespaceAndPath((String)attribute.getNamespace(), (String)("inline_tooltip_icons/" + attribute.getPath()));
        MutableComponent iconComponent = Component.object((ObjectInfo)new AtlasSprite(AtlasSprite.DEFAULT_ATLAS, icon));
        iconComponent.append(ModHelpers.format(amount) + " ");
        if (ModHelpers.hasAltDown() && InlineTooltips.CONFIG.developerOptions.debugInfo) {
            iconComponent.append((Component)Component.literal((String)" (%s)".formatted(attribute)));
            list.add((Component)iconComponent);
        } else {
            component.append((Component)iconComponent);
        }
    }

    public static void init() {
    }

    public static ResourceLocation id(String id) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)id);
    }
}

