/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.inline_tooltips;

import cc.cassian.inline_tooltips.Platform;
import cc.cassian.inline_tooltips.config.ModConfig;
import cc.cassian.inline_tooltips.helpers.ModHelpers;
import cc.cassian.inline_tooltips.helpers.SharpnessHelpers;
import com.samsthenerd.inline.api.InlineData;
import com.samsthenerd.inline.api.data.SpriteInlineData;
import com.samsthenerd.inline.impl.InlineStyle;
import com.samsthenerd.inline.utils.Spritelike;
import com.samsthenerd.inline.utils.TextureSprite;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.item.component.LodestoneTracker;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.text.WordUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InlineTooltips {
    public static final String MOD_ID = "inline_tooltips";
    public static final ModConfig CONFIG = (ModConfig)ModConfig.createToml((Path)Platform.INSTANCE.getConfigDir(), (String)"", (String)"inline_tooltips", ModConfig.class);
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"inline_tooltips");

    public static void addTooltips(ItemStack itemStack, Item.TooltipContext tooltipContext, TooltipFlag tooltipFlag, List<Component> list) {
        if (!ModHelpers.hasShiftDown()) {
            ClientLevel level;
            MutableComponent component = Component.empty();
            if (InlineTooltips.CONFIG.iconTooltips.attributeTooltips) {
                for (EquipmentSlotGroup equipmentSlotGroup : EquipmentSlotGroup.values()) {
                    itemStack.forEachModifier(equipmentSlotGroup, (holder, attributeModifier) -> {
                        LocalPlayer player = Minecraft.getInstance().player;
                        AtomicReference<Double> amount = new AtomicReference<Double>(attributeModifier.amount());
                        if (player != null) {
                            amount.set(switch (attributeModifier.operation()) {
                                default -> throw new MatchException(null, null);
                                case AttributeModifier.Operation.ADD_VALUE -> attributeModifier.amount() + player.getAttributeBaseValue(holder);
                                case AttributeModifier.Operation.ADD_MULTIPLIED_BASE, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL -> attributeModifier.amount() * player.getAttributeBaseValue(holder);
                            });
                        }
                        amount.set(SharpnessHelpers.addSharpnessDamage(itemStack, amount.get(), (Player)player, attributeModifier));
                        ResourceLocation icon = ((ResourceKey)holder.unwrapKey().orElseThrow()).location();
                        if (amount.get() != 0.0) {
                            InlineTooltips.addIcon(icon, amount.get(), tooltipFlag, list, component);
                        }
                    });
                }
            }
            if (itemStack.has(DataComponents.BEES) && InlineTooltips.CONFIG.iconTooltips.beesTooltip) {
                List bees = (List)itemStack.get(DataComponents.BEES);
                if (bees == null) {
                    return;
                }
                InlineTooltips.addIcon(ResourceLocation.withDefaultNamespace((String)"bees"), bees.size(), tooltipFlag, list, component);
            }
            if (InlineTooltips.CONFIG.iconTooltips.fuelTooltip && (level = Minecraft.getInstance().level) != null && AbstractFurnaceBlockEntity.isFuel((ItemStack)itemStack)) {
                InlineTooltips.addIcon(ResourceLocation.withDefaultNamespace((String)"fuel"), (float)((Integer)AbstractFurnaceBlockEntity.getFuel().get(itemStack.getItem())).intValue() / 200.0f, tooltipFlag, list, component);
            }
            if (InlineTooltips.CONFIG.iconTooltips.honeyTooltip && itemStack.has(DataComponents.BLOCK_STATE)) {
                BlockItemStateProperties state = (BlockItemStateProperties)itemStack.get(DataComponents.BLOCK_STATE);
                if (state == null) {
                    return;
                }
                Integer honey = (Integer)state.get((Property)BeehiveBlock.HONEY_LEVEL);
                if (honey == null) {
                    return;
                }
                InlineTooltips.addIcon(ResourceLocation.withDefaultNamespace((String)"honey"), honey.intValue(), tooltipFlag, list, component);
            }
            if (!component.equals((Object)Component.empty())) {
                list.add((Component)component);
            }
        }
        if (InlineTooltips.CONFIG.textTooltips.lodestoneTooltip && itemStack.has(DataComponents.LODESTONE_TRACKER)) {
            LodestoneTracker state = (LodestoneTracker)itemStack.get(DataComponents.LODESTONE_TRACKER);
            if (state == null || state.target().isEmpty()) {
                return;
            }
            GlobalPos globalPos = (GlobalPos)state.target().get();
            BlockPos pos = globalPos.pos();
            list.add((Component)Component.translatable((String)"gui.inline_tooltips.target").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)"X: %d, Y: %d, Z: %d".formatted(pos.getX(), pos.getY(), pos.getZ())).withStyle(ChatFormatting.GOLD)));
            list.add((Component)Component.translatable((String)"gui.inline_tooltips.dimension").withStyle(ChatFormatting.GRAY).append((Component)Component.translatableWithFallback((String)globalPos.dimension().location().toLanguageKey("dimension"), (String)WordUtils.capitalizeFully((String)globalPos.dimension().location().getPath())).withStyle(ChatFormatting.GOLD)));
        }
        if (InlineTooltips.CONFIG.textTooltips.compassTooltip && itemStack.is(Items.COMPASS) && !itemStack.has(DataComponents.LODESTONE_TRACKER)) {
            BlockPos pos = Minecraft.getInstance().player.blockPosition();
            list.add((Component)Component.translatable((String)"gui.inline_tooltips.position").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)"X: %d, Y: %d, Z: %d".formatted(pos.getX(), pos.getY(), pos.getZ())).withStyle(ChatFormatting.GOLD)));
        }
        if (InlineTooltips.CONFIG.textTooltips.durabilityTooltip && !tooltipFlag.isAdvanced() && itemStack.isDamaged() && itemStack.has(DataComponents.DAMAGE)) {
            list.add((Component)Component.translatable((String)"item.durability", (Object[])new Object[]{itemStack.getMaxDamage() - itemStack.getDamageValue(), itemStack.getMaxDamage()}).withStyle(ChatFormatting.GRAY));
        }
    }

    private static void addIcon(ResourceLocation attribute, double amount, TooltipFlag tooltipFlag, List<Component> list, MutableComponent component) {
        ResourceLocation icon = ResourceLocation.fromNamespaceAndPath((String)attribute.getNamespace(), (String)"textures/inline_tooltip_icons/%s.png".formatted(attribute.getPath().replace("generic.", "")));
        Style style = InlineStyle.fromInlineData((InlineData)new SpriteInlineData((Spritelike)new TextureSprite(icon)));
        MutableComponent iconComponent = Component.literal((String)".").setStyle(style);
        iconComponent.append(ModHelpers.format(amount) + " ");
        if (ModHelpers.hasAltDown() && InlineTooltips.CONFIG.developerOptions.debugInfo) {
            iconComponent.append((Component)Component.literal((String)" (%s)".formatted(attribute)));
            list.add((Component)iconComponent);
        } else {
            component.append((Component)iconComponent);
        }
    }

    public static void init() {
    }

    public static ResourceLocation id(String id) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)id);
    }
}

