/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.inline_tooltips;

import cc.cassian.inline_tooltips.Platform;
import cc.cassian.inline_tooltips.compat.ModCompat;
import cc.cassian.inline_tooltips.config.ModConfig;
import cc.cassian.inline_tooltips.helpers.ModHelpers;
import cc.cassian.inline_tooltips.helpers.SharpnessHelpers;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.objects.AtlasSprite;
import net.minecraft.network.chat.contents.objects.ObjectInfo;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.Bees;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.LodestoneTracker;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LightBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.text.WordUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InlineTooltips {
    public static final String MOD_ID = "inline_tooltips";
    public static final ModConfig CONFIG = (ModConfig)ModConfig.createToml((Path)Platform.INSTANCE.getConfigDir(), (String)"", (String)"inline_tooltips", ModConfig.class);
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"inline_tooltips");
    private static final ResourceLocation UNDEFINED = InlineTooltips.id("inline_tooltips", "textures/inline_tooltip_icons/empty.png");

    public static void addTooltips(ItemStack itemStack, Item.TooltipContext tooltipContext, TooltipFlag tooltipFlag, List<Component> list) {
        LocalPlayer player = Minecraft.getInstance().player;
        MutableComponent component = Component.empty();
        InlineTooltips.addAttributeTooltips(itemStack, list, component);
        InlineTooltips.addBeeTooltips(itemStack, list, component);
        InlineTooltips.addFoodTooltips(itemStack, list, component);
        InlineTooltips.addFuelTooltips(itemStack, list, component);
        InlineTooltips.addHoneyTooltips(itemStack, list, component);
        InlineTooltips.addLightLevelTooltips(itemStack, list, component);
        if (!component.equals((Object)Component.empty())) {
            list.add((Component)component);
        }
        if (InlineTooltips.CONFIG.textTooltips.lodestoneTooltip && itemStack.has(DataComponents.LODESTONE_TRACKER)) {
            LodestoneTracker state = (LodestoneTracker)itemStack.get(DataComponents.LODESTONE_TRACKER);
            if (state == null || state.target().isEmpty()) {
                return;
            }
            GlobalPos pos = (GlobalPos)state.target().get();
            InlineTooltips.addCoordinates(pos, list, "target", ModHelpers.getColour(InlineTooltips.CONFIG.textTooltips.lodestoneCompassTooltipColor, ChatFormatting.GOLD));
        }
        if (InlineTooltips.CONFIG.textTooltips.recoveryCompassTooltip && itemStack.is(Items.RECOVERY_COMPASS) && player != null) {
            Optional lastDeath = player.getLastDeathLocation();
            if (lastDeath.isEmpty()) {
                return;
            }
            InlineTooltips.addCoordinates((GlobalPos)lastDeath.get(), list, "target", ModHelpers.getColour(InlineTooltips.CONFIG.textTooltips.recoveryCompassTooltipColor, ChatFormatting.AQUA));
        }
        if (InlineTooltips.CONFIG.textTooltips.compassTooltip && itemStack.is(Items.COMPASS) && !itemStack.has(DataComponents.LODESTONE_TRACKER) && player != null) {
            BlockPos pos = player.blockPosition();
            InlineTooltips.addCoordinates(pos, list, "position", ModHelpers.getColour(InlineTooltips.CONFIG.textTooltips.compassTooltipColor, ChatFormatting.RED));
        }
        if (InlineTooltips.CONFIG.durabilityTooltip.enable && !tooltipFlag.isAdvanced() && (InlineTooltips.CONFIG.durabilityTooltip.always_show || itemStack.isDamaged()) && itemStack.isDamageableItem() && (itemStack.has(DataComponents.DAMAGE) || InlineTooltips.CONFIG.durabilityTooltip.always_show)) {
            list.add((Component)Component.translatable((String)"item.durability", (Object[])new Object[]{itemStack.getMaxDamage() - itemStack.getDamageValue(), itemStack.getMaxDamage()}).withStyle(ModHelpers.getColour(InlineTooltips.CONFIG.durabilityTooltip.text_color, ChatFormatting.GRAY)));
        }
        if ((InlineTooltips.CONFIG.clockTooltip.current_time || InlineTooltips.CONFIG.clockTooltip.day_count) && itemStack.is(Items.CLOCK) && player != null) {
            list.add((Component)Component.literal((String)InlineTooltips.getTime(Minecraft.getInstance().level.getDayTime())).withStyle(ModHelpers.getColour(InlineTooltips.CONFIG.clockTooltip.text_color, ChatFormatting.GOLD)));
        }
    }

    private static void addCoordinates(GlobalPos globalPos, List<Component> list, String target, ChatFormatting colour) {
        InlineTooltips.addCoordinates(globalPos.pos(), list, target, colour);
        list.add((Component)Component.translatable((String)"gui.inline_tooltips.dimension").withStyle(ChatFormatting.GRAY).append((Component)Component.translatableWithFallback((String)globalPos.dimension().location().toLanguageKey("dimension"), (String)WordUtils.capitalizeFully((String)globalPos.dimension().location().getPath())).withStyle(colour)));
    }

    private static void addCoordinates(BlockPos pos, List<Component> list, String target, ChatFormatting colour) {
        list.add((Component)Component.translatable((String)("gui.inline_tooltips." + target)).withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)"X: %d, Y: %d, Z: %d".formatted(pos.getX(), pos.getY(), pos.getZ())).withStyle(colour)));
    }

    public static String getTime(float dayTime) {
        StringBuilder currentTime = new StringBuilder();
        if (InlineTooltips.CONFIG.clockTooltip.day_count) {
            int day = (int)(dayTime / 24000.0f);
            currentTime.append(I18n.get((String)"gui.c.day", (Object[])new Object[]{day}));
            if (InlineTooltips.CONFIG.clockTooltip.current_time) {
                currentTime.append(", ");
            }
        }
        if (InlineTooltips.CONFIG.clockTooltip.current_time) {
            int time = (int)(dayTime + 6000.0f) % 24000;
            int m = (int)((float)time % 1000.0f / 1000.0f * 60.0f);
            int hour = time / 1000;
            String a = "";
            if (InlineTooltips.CONFIG.clockTooltip.twenty_four_hour_clock) {
                String string = a = time < 12000 ? " AM" : " PM";
                if ((hour %= 12) == 0) {
                    hour = 12;
                }
            }
            currentTime.append(hour).append(":").append(m < 10 ? "0" : "").append(m).append(a);
        }
        return currentTime.toString();
    }

    private static void addAttributeTooltips(ItemStack itemStack, List<Component> list, MutableComponent component) {
        if (InlineTooltips.CONFIG.iconTooltips.attributeTooltips) {
            for (EquipmentSlotGroup equipmentSlotGroup : EquipmentSlotGroup.values()) {
                itemStack.forEachModifier(equipmentSlotGroup, (holder, attributeModifier, display) -> {
                    if (display != ItemAttributeModifiers.Display.hidden()) {
                        LocalPlayer player = Minecraft.getInstance().player;
                        double attributeModifierAmount = attributeModifier.amount();
                        AtomicReference<Double> amount = new AtomicReference<Double>(attributeModifierAmount);
                        if (player != null && player.getAttributes().hasAttribute(holder)) {
                            amount.set(switch (attributeModifier.operation()) {
                                default -> throw new MatchException(null, null);
                                case AttributeModifier.Operation.ADD_VALUE -> attributeModifierAmount + player.getAttributeBaseValue(holder);
                                case AttributeModifier.Operation.ADD_MULTIPLIED_BASE, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL -> attributeModifierAmount * player.getAttributeBaseValue(holder);
                            });
                        }
                        amount.set(SharpnessHelpers.addSharpnessDamage(itemStack, amount.get(), (Player)player, attributeModifier));
                        ResourceLocation icon = ((ResourceKey)holder.unwrapKey().orElseThrow()).location();
                        if (amount.get() != 0.0) {
                            InlineTooltips.addIcon(icon, amount.get(), list, component, Component.translatable((String)("item.modifiers." + equipmentSlotGroup.name().toLowerCase(Locale.ROOT))), ModHelpers.getColour(InlineTooltips.CONFIG.iconTooltips.attributeTooltipColor, ChatFormatting.DARK_GREEN));
                        }
                    }
                });
            }
        }
    }

    private static void addBeeTooltips(ItemStack itemStack, List<Component> list, MutableComponent component) {
        if (itemStack.has(DataComponents.BEES) && InlineTooltips.CONFIG.iconTooltips.beesTooltip) {
            Bees bees = (Bees)itemStack.get(DataComponents.BEES);
            if (bees == null) {
                return;
            }
            InlineTooltips.addIcon(InlineTooltips.id("bees"), bees.bees().size(), list, component, null, ModHelpers.getColour(InlineTooltips.CONFIG.iconTooltips.beeTooltipColor, ChatFormatting.GOLD));
        }
    }

    private static void addFuelTooltips(ItemStack itemStack, List<Component> list, MutableComponent component) {
        ClientLevel level;
        if (InlineTooltips.CONFIG.iconTooltips.fuelTooltip && (level = Minecraft.getInstance().level) != null && level.fuelValues().isFuel(itemStack)) {
            InlineTooltips.addIcon(InlineTooltips.id("fuel"), InlineTooltips.getFuelValue((Level)level, itemStack) / 200.0, list, component, Component.translatable((String)"item.modifiers.furnace"), ModHelpers.getColour(InlineTooltips.CONFIG.iconTooltips.fuelTooltipColor, ChatFormatting.GOLD));
        }
    }

    private static void addFoodTooltips(ItemStack itemStack, List<Component> list, MutableComponent component) {
        if (itemStack.has(DataComponents.FOOD) && (!ModCompat.APPLE_SKIN || InlineTooltips.CONFIG.developerOptions.showFoodTooltipWithAppleSkinInstalled) && InlineTooltips.CONFIG.iconTooltips.foodTooltip) {
            FoodProperties foodProperties = (FoodProperties)itemStack.get(DataComponents.FOOD);
            if (foodProperties == null) {
                return;
            }
            if (InlineTooltips.CONFIG.iconTooltips.foodTooltip) {
                InlineTooltips.addIcon(InlineTooltips.id("food"), foodProperties.nutrition(), list, component, Component.translatable((String)"item.modifiers.eaten"), ModHelpers.getColour(InlineTooltips.CONFIG.iconTooltips.foodTooltipColor, ChatFormatting.GOLD));
            }
            if (InlineTooltips.CONFIG.iconTooltips.saturationTooltip) {
                InlineTooltips.addIcon(InlineTooltips.id("saturation"), foodProperties.saturation(), list, component, Component.translatable((String)"item.modifiers.eaten"), ModHelpers.getColour(InlineTooltips.CONFIG.iconTooltips.saturationTooltipColor, ChatFormatting.GOLD));
            }
        }
    }

    private static double getFuelValue(Level level, ItemStack itemStack) {
        int value = itemStack.getBurnTime(null, level.fuelValues());
        return value;
    }

    private static void addHoneyTooltips(ItemStack itemStack, List<Component> list, MutableComponent component) {
        if (InlineTooltips.CONFIG.iconTooltips.honeyTooltip && itemStack.has(DataComponents.BLOCK_STATE)) {
            BlockItemStateProperties state = (BlockItemStateProperties)itemStack.get(DataComponents.BLOCK_STATE);
            if (state == null) {
                return;
            }
            Integer honey = (Integer)state.get((Property)BeehiveBlock.HONEY_LEVEL);
            if (honey == null) {
                return;
            }
            InlineTooltips.addIcon(InlineTooltips.id("honey"), honey.intValue(), list, component, null, ModHelpers.getColour(InlineTooltips.CONFIG.iconTooltips.honeyTooltipColor, ChatFormatting.GOLD));
        }
    }

    private static void addLightLevelTooltips(ItemStack itemStack, List<Component> list, MutableComponent component) {
        Item item;
        if (InlineTooltips.CONFIG.iconTooltips.lightLevelTooltip && (item = itemStack.getItem()) instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            if (blockItem.getBlock() == Blocks.LIGHT) {
                Integer light;
                BlockItemStateProperties stateComponent = (BlockItemStateProperties)itemStack.get(DataComponents.BLOCK_STATE);
                Integer n = light = stateComponent != null ? (Integer)stateComponent.get((Property)LightBlock.LEVEL) : null;
                if (light != null && light != 0) {
                    InlineTooltips.addIcon(InlineTooltips.id("light"), light.intValue(), list, component, Component.translatable((String)"item.modifiers.placed"), ModHelpers.getColour(InlineTooltips.CONFIG.iconTooltips.lightLevelTooltipColor, ChatFormatting.GOLD));
                }
            } else {
                BlockState state = blockItem.getBlock().defaultBlockState();
                int light = state.getLightEmission();
                if (light != 0) {
                    InlineTooltips.addIcon(InlineTooltips.id("light"), light, list, component, Component.translatable((String)"item.modifiers.placed"), ModHelpers.getColour(InlineTooltips.CONFIG.iconTooltips.lightLevelTooltipColor, ChatFormatting.GOLD));
                }
            }
        }
    }

    private static void addIcon(ResourceLocation attribute, double amount, List<Component> list, MutableComponent component, MutableComponent usedText, ChatFormatting attributeColor) {
        if (ModHelpers.hasShiftDown() && usedText != null && !list.contains(usedText.withStyle(ChatFormatting.GRAY))) {
            list.add((Component)Component.empty());
            list.add((Component)usedText.withStyle(ChatFormatting.GRAY));
        }
        ResourceLocation icon = InlineTooltips.id(attribute.getNamespace(), "inline_tooltip_icons/" + attribute.getPath());
        MutableComponent iconComponent = Component.object((ObjectInfo)new AtlasSprite(AtlasSprite.DEFAULT_ATLAS, icon));
        String spacing = new String(new char[InlineTooltips.CONFIG.general.spacing]).replace("\u0000", " ");
        String expandedSpacing = new String(new char[InlineTooltips.CONFIG.general.expandedSpacing]).replace("\u0000", " ");
        if (ModHelpers.hasAltDown() && InlineTooltips.CONFIG.developerOptions.debugInfo) {
            iconComponent.append(ModHelpers.format(amount) + " ");
            iconComponent.append((Component)Component.literal((String)" (%s | %s)".formatted(attribute, icon)));
            list.add((Component)iconComponent);
        } else if (ModHelpers.hasShiftDown()) {
            iconComponent.append(expandedSpacing);
            String key = attribute.toLanguageKey("tooltip");
            if (I18n.exists((String)key)) {
                iconComponent.append((Component)Component.translatable((String)key, (Object[])new Object[]{ModHelpers.format(amount)}).withStyle(attributeColor));
            } else if (!InlineTooltips.CONFIG.developerOptions.debugInfo) {
                iconComponent.append((Component)Component.literal((String)"%s %s".formatted(ModHelpers.format(amount), WordUtils.capitalizeFully((String)attribute.getPath().replace("_", " ")))).withStyle(attributeColor));
            } else {
                iconComponent.append((Component)Component.literal((String)"%s %s".formatted(ModHelpers.format(amount), key)).withStyle(attributeColor));
            }
            list.add((Component)iconComponent);
        } else {
            iconComponent.append(ModHelpers.format(amount) + spacing);
            component.append((Component)iconComponent);
        }
    }

    public static void init() {
    }

    public static ResourceLocation id(String id) {
        return InlineTooltips.id(MOD_ID, id);
    }

    public static ResourceLocation id(String namespace, String id) {
        return ResourceLocation.fromNamespaceAndPath((String)namespace, (String)id);
    }
}

