package cc.cassian.inline_tooltips;

import cc.cassian.inline_tooltips.config.ModConfig;
import cc.cassian.inline_tooltips.helpers.ModHelpers;
import cc.cassian.inline_tooltips.helpers.SharpnessHelpers;
//? if =1.21.1 {
import com.samsthenerd.inline.api.InlineAPI;
import com.samsthenerd.inline.api.InlineData;
import com.samsthenerd.inline.api.data.SpriteInlineData;
import com.samsthenerd.inline.impl.InlineStyle;
import com.samsthenerd.inline.utils.TextureSprite;
import org.apache.commons.lang3.text.WordUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2609;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4208;
import net.minecraft.class_4481;
import net.minecraft.class_5250;
import net.minecraft.class_9274;
import net.minecraft.class_9334;

public class InlineTooltips {
	public static final String MOD_ID = "inline_tooltips";
    public static final ModConfig CONFIG = ModConfig.createToml(Platform.INSTANCE.getConfigDir(),"", MOD_ID, ModConfig.class);

	// This logger is used to write text to the console and the log file.
	// It is considered best practice to use your mod id as the logger's name.
	// That way, it's clear which mod wrote info, warnings, and errors.
	public static final Logger LOGGER = LoggerFactory.getLogger(MOD_ID);


    public static void addTooltips(class_1799 itemStack, class_1792.class_9635 tooltipContext, class_1836 tooltipFlag, List<class_2561> list) {
        if (!ModHelpers.hasShiftDown()) {
            var component = class_2561.method_43473();
            // Attribute Modifiers
            if (CONFIG.iconTooltips.attributeTooltips) {
                for (class_9274 equipmentSlotGroup : class_9274.values()) {
                    //? if >1.21.8 {
                    /*itemStack.forEachModifier(equipmentSlotGroup, (holder, attributeModifier, display) -> {
                        *///?} else {
                    itemStack.method_60617(equipmentSlotGroup, (holder, attributeModifier) -> {
                        //?}
                        //? if >1.21.8
                        /*if (display != ItemAttributeModifiers.Display.hidden()) {*/
                            var player = class_310.method_1551().field_1724;
                            AtomicReference<Double> amount = new AtomicReference<>(attributeModifier.comp_2449());
                            if (player != null) {
                                amount.set(switch (attributeModifier.comp_2450()) {
                                    case field_6328 -> attributeModifier.comp_2449() + player.method_45326(holder);
                                    case field_6330, field_6331 ->
                                            attributeModifier.comp_2449() * player.method_45326(holder);
                                });
                            }
                            amount.set(SharpnessHelpers.addSharpnessDamage(itemStack, amount.get(), player, attributeModifier));
                            var icon = holder.method_40230().orElseThrow().method_29177();
                            if (amount.get()!=0)
                                addIcon(icon, amount.get(), tooltipFlag, list, component);
                        //? if >1.21.8
                        /*}*/
                    });
                }
            }
            if (itemStack.method_57826(class_9334.field_49624) && CONFIG.iconTooltips.beesTooltip) {
                var bees = itemStack.method_57824(class_9334.field_49624);
                if (bees == null) return;
                addIcon(class_2960.method_60656("bees"), bees
                        //? if >1.21.8
                        /*.bees()*/
                        .size(), tooltipFlag, list, component);

            }
            if (CONFIG.iconTooltips.fuelTooltip) {
                var level = class_310.method_1551().field_1687;
                if (level != null &&
                        //? if >1.21.8 {
                        /*level.fuelValues()
                        *///?} else {
                        class_2609
                        //?}
                                .method_11195(itemStack)) {
                    addIcon(class_2960.method_60656("fuel"),
                            //? if >1.21.8 {
                            /*level.fuelValues().burnDuration(itemStack)
                             *///?} else {
                            class_2609.method_11196().get(itemStack.method_7909())
                            //?}
                             /200f, tooltipFlag, list, component);
                }
            }
            if (CONFIG.iconTooltips.honeyTooltip && itemStack.method_57826(class_9334.field_49623)) {
                var state = itemStack.method_57824(class_9334.field_49623);
                if (state == null) return;
                var honey = state.method_57418(class_4481.field_20420);
                if (honey == null) return;
                addIcon(class_2960.method_60656("honey"), honey, tooltipFlag, list, component);
            }
            // Add icon
            if (!component.equals(class_2561.method_43473()))
                list.add(component);
        }
        if (CONFIG.textTooltips.lodestoneTooltip && itemStack.method_57826(class_9334.field_49614)) {
            var state = itemStack.method_57824(class_9334.field_49614);
            if (state == null || state.comp_2402().isEmpty()) return;
            class_4208 globalPos = state.comp_2402().get();
            var pos = globalPos.comp_2208();
            list.add(
                    class_2561.method_43471("gui.inline_tooltips.target").method_27692(class_124.field_1080).method_10852(
                            class_2561.method_43470("X: %d, Y: %d, Z: %d".formatted(pos.method_10263(), pos.method_10264(), pos.method_10260())).method_27692(class_124.field_1065)));
            list.add(
                    class_2561.method_43471("gui.inline_tooltips.dimension").method_27692(class_124.field_1080).method_10852(
                            class_2561.method_48321(globalPos.comp_2207().method_29177().method_42093("dimension"), WordUtils.capitalizeFully(globalPos.comp_2207().method_29177().method_12832())).method_27692(class_124.field_1065)));
        }
        if (CONFIG.textTooltips.compassTooltip && itemStack.method_31574(class_1802.field_8251) && !itemStack.method_57826(class_9334.field_49614)) {
            var pos = class_310.method_1551().field_1724.method_24515();
            list.add(
                    class_2561.method_43471("gui.inline_tooltips.position").method_27692(class_124.field_1080).method_10852(
                            class_2561.method_43470("X: %d, Y: %d, Z: %d".formatted(pos.method_10263(), pos.method_10264(), pos.method_10260())).method_27692(class_124.field_1065)));
        }
        if (CONFIG.textTooltips.durabilityTooltip && !tooltipFlag.method_8035() && itemStack.method_7986() && itemStack.method_57826(class_9334.field_49629)) {
            list.add(class_2561.method_43469("item.durability", itemStack.method_7936() - itemStack.method_7919(), itemStack.method_7936()).method_27692(class_124.field_1080));
        }
    }

    private static void addIcon(class_2960 attribute, double amount, class_1836 tooltipFlag, List<class_2561> list, class_5250 component) {
        //? if >1.21.8 {
        /*ResourceLocation icon = ResourceLocation.fromNamespaceAndPath(attribute.getNamespace(), "inline_tooltip_icons/"+ attribute.getPath());
        MutableComponent iconComponent = Component.object(new AtlasSprite(AtlasSprite.DEFAULT_ATLAS, icon));
        *///?} else {
        class_2960 icon = class_2960.method_60655(attribute.method_12836(), "textures/inline_tooltip_icons/%s.png".formatted(attribute.method_12832().replace("generic.", "")));
        var style = InlineStyle.fromInlineData(new SpriteInlineData(new TextureSprite(icon)));;
        class_5250 iconComponent = class_2561.method_43470(".").method_10862(style);
        //?}
        iconComponent.method_27693(ModHelpers.format(amount) + " ");
        if (ModHelpers.hasAltDown() && InlineTooltips.CONFIG.developerOptions.debugInfo) {
            iconComponent.method_10852(class_2561.method_43470(" (%s)".formatted(attribute)));
            list.add(iconComponent);
        } else {
            component.method_10852(iconComponent);
        }
    }

    public static void init() {

    }

    public static class_2960 id(String id) {
        return class_2960.method_60655(MOD_ID, id);
    }
}