/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.inline_tooltips;

import cc.cassian.inline_tooltips.Platform;
import cc.cassian.inline_tooltips.config.ModConfig;
import cc.cassian.inline_tooltips.helpers.ModHelpers;
import cc.cassian.inline_tooltips.helpers.SharpnessHelpers;
import com.samsthenerd.inline.api.InlineData;
import com.samsthenerd.inline.api.data.SpriteInlineData;
import com.samsthenerd.inline.impl.InlineStyle;
import com.samsthenerd.inline.utils.Spritelike;
import com.samsthenerd.inline.utils.TextureSprite;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2609;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4208;
import net.minecraft.class_4481;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6089;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_9274;
import net.minecraft.class_9275;
import net.minecraft.class_9291;
import net.minecraft.class_9334;
import org.apache.commons.lang3.text.WordUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InlineTooltips {
    public static final String MOD_ID = "inline_tooltips";
    public static final ModConfig CONFIG = (ModConfig)ModConfig.createToml((Path)Platform.INSTANCE.getConfigDir(), (String)"", (String)"inline_tooltips", ModConfig.class);
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"inline_tooltips");

    public static void addTooltips(class_1799 itemStack, class_1792.class_9635 tooltipContext, class_1836 tooltipFlag, List<class_2561> list) {
        class_5250 component = class_2561.method_43473();
        if (!ModHelpers.hasShiftDown()) {
            InlineTooltips.addAttributeTooltips(itemStack, list, component);
        }
        InlineTooltips.addBeeTooltips(itemStack, list, component);
        InlineTooltips.addFuelTooltips(itemStack, list, component);
        InlineTooltips.addHoneyTooltips(itemStack, list, component);
        InlineTooltips.addLightLevelTooltips(itemStack, list, component);
        if (!component.equals((Object)class_2561.method_43473())) {
            list.add((class_2561)component);
        }
        if (InlineTooltips.CONFIG.textTooltips.lodestoneTooltip && itemStack.method_57826(class_9334.field_49614)) {
            class_9291 state = (class_9291)itemStack.method_57824(class_9334.field_49614);
            if (state == null || state.comp_2402().isEmpty()) {
                return;
            }
            InlineTooltips.addCoordinates((class_4208)state.comp_2402().get(), list, "target", ModHelpers.getColour(InlineTooltips.CONFIG.textTooltips.lodestoneCompassTooltipColor, class_124.field_1065));
        }
        if (InlineTooltips.CONFIG.textTooltips.recoveryCompassTooltip && itemStack.method_31574(class_1802.field_38747)) {
            Optional lastDeath = class_310.method_1551().field_1724.method_43122();
            if (lastDeath.isEmpty()) {
                return;
            }
            InlineTooltips.addCoordinates((class_4208)lastDeath.get(), list, "target", ModHelpers.getColour(InlineTooltips.CONFIG.textTooltips.recoveryCompassTooltipColor, class_124.field_1075));
        }
        if (InlineTooltips.CONFIG.textTooltips.compassTooltip && itemStack.method_31574(class_1802.field_8251) && !itemStack.method_57826(class_9334.field_49614)) {
            class_2338 pos = class_310.method_1551().field_1724.method_24515();
            InlineTooltips.addCoordinates(pos, list, "position", ModHelpers.getColour(InlineTooltips.CONFIG.textTooltips.compassTooltipColor, class_124.field_1061));
        }
        if (InlineTooltips.CONFIG.textTooltips.durabilityTooltip && !tooltipFlag.method_8035() && itemStack.method_7986() && itemStack.method_57826(class_9334.field_49629)) {
            list.add((class_2561)class_2561.method_43469((String)"item.durability", (Object[])new Object[]{itemStack.method_7936() - itemStack.method_7919(), itemStack.method_7936()}).method_54663(ModHelpers.getColour(InlineTooltips.CONFIG.textTooltips.durabilityTooltipColor, class_124.field_1080).intValue()));
        }
        if ((InlineTooltips.CONFIG.clockTooltip.current_time || InlineTooltips.CONFIG.clockTooltip.day_count) && itemStack.method_31574(class_1802.field_8557)) {
            list.add((class_2561)class_2561.method_43470((String)InlineTooltips.getTime(class_310.method_1551().field_1687.method_8532())).method_54663(ModHelpers.getColour(InlineTooltips.CONFIG.clockTooltip.text_color, class_124.field_1065).intValue()));
        }
    }

    private static void addCoordinates(class_4208 globalPos, List<class_2561> list, String target, Integer colour) {
        InlineTooltips.addCoordinates(globalPos.comp_2208(), list, target, colour);
        list.add((class_2561)class_2561.method_43471((String)"gui.inline_tooltips.dimension").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_48321((String)globalPos.comp_2207().method_29177().method_42093("dimension"), (String)WordUtils.capitalizeFully((String)globalPos.comp_2207().method_29177().method_12832())).method_54663(colour.intValue())));
    }

    private static void addCoordinates(class_2338 pos, List<class_2561> list, String target, Integer colour) {
        list.add((class_2561)class_2561.method_43471((String)("gui.inline_tooltips." + target)).method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)"X: %d, Y: %d, Z: %d".formatted(pos.method_10263(), pos.method_10264(), pos.method_10260())).method_54663(colour.intValue())));
    }

    public static String getTime(float dayTime) {
        StringBuilder currentTime = new StringBuilder();
        if (InlineTooltips.CONFIG.clockTooltip.day_count) {
            int day = (int)(dayTime / 24000.0f);
            currentTime.append(class_1074.method_4662((String)"gui.c.day", (Object[])new Object[]{day}));
            if (InlineTooltips.CONFIG.clockTooltip.current_time) {
                currentTime.append(", ");
            }
        }
        if (InlineTooltips.CONFIG.clockTooltip.current_time) {
            int time = (int)(dayTime + 6000.0f) % 24000;
            int m = (int)((float)time % 1000.0f / 1000.0f * 60.0f);
            int hour = time / 1000;
            String a = "";
            if (InlineTooltips.CONFIG.clockTooltip.twenty_four_hour_clock) {
                String string = a = time < 12000 ? " AM" : " PM";
                if ((hour %= 12) == 0) {
                    hour = 12;
                }
            }
            currentTime.append(hour).append(":").append(m < 10 ? "0" : "").append(m).append(a);
        }
        return currentTime.toString();
    }

    private static void addAttributeTooltips(class_1799 itemStack, List<class_2561> list, class_5250 component) {
        if (InlineTooltips.CONFIG.iconTooltips.attributeTooltips) {
            for (class_9274 equipmentSlotGroup : class_9274.values()) {
                itemStack.method_60617(equipmentSlotGroup, (holder, attributeModifier) -> {
                    class_746 player = class_310.method_1551().field_1724;
                    AtomicReference<Double> amount = new AtomicReference<Double>(attributeModifier.comp_2449());
                    if (player != null) {
                        amount.set(switch (attributeModifier.comp_2450()) {
                            default -> throw new MatchException(null, null);
                            case class_1322.class_1323.field_6328 -> attributeModifier.comp_2449() + player.method_45326(holder);
                            case class_1322.class_1323.field_6330, class_1322.class_1323.field_6331 -> attributeModifier.comp_2449() * player.method_45326(holder);
                        });
                    }
                    amount.set(SharpnessHelpers.addSharpnessDamage(itemStack, amount.get(), (class_1657)player, attributeModifier));
                    class_2960 icon = ((class_5321)holder.method_40230().orElseThrow()).method_29177();
                    if (amount.get() != 0.0) {
                        InlineTooltips.addIcon(icon, amount.get(), list, component);
                    }
                });
            }
        }
    }

    private static void addBeeTooltips(class_1799 itemStack, List<class_2561> list, class_5250 component) {
        if (itemStack.method_57826(class_9334.field_49624) && InlineTooltips.CONFIG.iconTooltips.beesTooltip) {
            List bees = (List)itemStack.method_57824(class_9334.field_49624);
            if (bees == null) {
                return;
            }
            InlineTooltips.addIcon(InlineTooltips.id("bees"), bees.size(), list, component);
        }
    }

    private static void addFuelTooltips(class_1799 itemStack, List<class_2561> list, class_5250 component) {
        class_638 level;
        if (InlineTooltips.CONFIG.iconTooltips.fuelTooltip && (level = class_310.method_1551().field_1687) != null && class_2609.method_11195((class_1799)itemStack)) {
            InlineTooltips.addIcon(InlineTooltips.id("fuel"), (float)((Integer)class_2609.method_11196().get(itemStack.method_7909())).intValue() / 200.0f, list, component);
        }
    }

    private static void addHoneyTooltips(class_1799 itemStack, List<class_2561> list, class_5250 component) {
        if (InlineTooltips.CONFIG.iconTooltips.honeyTooltip && itemStack.method_57826(class_9334.field_49623)) {
            class_9275 state = (class_9275)itemStack.method_57824(class_9334.field_49623);
            if (state == null) {
                return;
            }
            Integer honey = (Integer)state.method_57418((class_2769)class_4481.field_20420);
            if (honey == null) {
                return;
            }
            InlineTooltips.addIcon(InlineTooltips.id("honey"), honey.intValue(), list, component);
        }
    }

    private static void addLightLevelTooltips(class_1799 itemStack, List<class_2561> list, class_5250 component) {
        class_1792 class_17922;
        if (InlineTooltips.CONFIG.iconTooltips.lightLevelTooltip && (class_17922 = itemStack.method_7909()) instanceof class_1747) {
            class_1747 blockItem = (class_1747)class_17922;
            if (blockItem.method_7711() == class_2246.field_31037) {
                Integer light;
                class_9275 stateComponent = (class_9275)itemStack.method_57824(class_9334.field_49623);
                Integer n = light = stateComponent != null ? (Integer)stateComponent.method_57418((class_2769)class_6089.field_31187) : null;
                if (light != null && light != 0) {
                    InlineTooltips.addIcon(InlineTooltips.id("light"), light.intValue(), list, component);
                }
            } else {
                class_2680 state = blockItem.method_7711().method_9564();
                int light = state.method_26213();
                if (light != 0) {
                    InlineTooltips.addIcon(InlineTooltips.id("light"), light, list, component);
                }
            }
        }
    }

    private static void addIcon(class_2960 attribute, double amount, List<class_2561> list, class_5250 component) {
        class_2960 icon = class_2960.method_60655((String)attribute.method_12836(), (String)"textures/inline_tooltip_icons/%s.png".formatted(attribute.method_12832().replace("generic.", "")));
        class_2583 style = InlineStyle.fromInlineData((InlineData)new SpriteInlineData((Spritelike)new TextureSprite(icon)));
        class_5250 iconComponent = class_2561.method_43470((String)".").method_10862(style);
        iconComponent.method_27693(ModHelpers.format(amount) + " ");
        if (ModHelpers.hasAltDown() && InlineTooltips.CONFIG.developerOptions.debugInfo) {
            iconComponent.method_10852((class_2561)class_2561.method_43470((String)" (%s)".formatted(attribute)));
            list.add((class_2561)iconComponent);
        } else {
            component.method_10852((class_2561)iconComponent);
        }
    }

    public static void init() {
    }

    public static class_2960 id(String id) {
        return class_2960.method_60655((String)MOD_ID, (String)id);
    }
}

