package cc.cassian.inline_tooltips;

import cc.cassian.inline_tooltips.compat.ModCompat;
import cc.cassian.inline_tooltips.config.ModConfig;
import cc.cassian.inline_tooltips.helpers.ModHelpers;
import cc.cassian.inline_tooltips.helpers.SharpnessHelpers;
//? if =1.21.1 || 1.20.1 {
import com.samsthenerd.inline.api.InlineAPI;
import com.samsthenerd.inline.api.InlineData;
import com.samsthenerd.inline.api.data.SpriteInlineData;
import com.samsthenerd.inline.impl.InlineStyle;
import com.samsthenerd.inline.utils.TextureSprite;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2609;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4208;
import net.minecraft.class_4481;
import net.minecraft.class_5250;
import net.minecraft.class_6089;
import net.minecraft.class_9274;
import net.minecraft.class_9334;
import net.minecraft.world.item.*;
import org.apache.commons.lang3.text.WordUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicReference;

public class InlineTooltips {
	public static final String MOD_ID = "inline_tooltips";
    public static final ModConfig CONFIG = ModConfig.createToml(Platform.INSTANCE.getConfigDir(),"", MOD_ID, ModConfig.class);

	// This logger is used to write text to the console and the log file.
	// It is considered best practice to use your mod id as the logger's name.
	// That way, it's clear which mod wrote info, warnings, and errors.
	public static final Logger LOGGER = LoggerFactory.getLogger(MOD_ID);


    public static void addTooltips(class_1799 itemStack,
                                   //? if >1.21
                                   class_1792.class_9635 tooltipContext,
                                   class_1836 tooltipFlag, List<class_2561> list) {
        var player = class_310.method_1551().field_1724;
        // Add icon tooltips
        var component = class_2561.method_43473();
        // Attribute Modifiers
        addAttributeTooltips(itemStack, list, component);
        addBeeTooltips(itemStack, list, component);
        addFoodTooltips(itemStack, list, component);
        addFuelTooltips(itemStack, list, component);
        addHoneyTooltips(itemStack, list, component);
        addLightLevelTooltips(itemStack, list, component);
        // Add icon
        if (!component.equals(class_2561.method_43473()))
            list.add(component);
        // Add text tooltips
        if (CONFIG.textTooltips.lodestoneTooltip &&
                //? if >1.21 {
                 itemStack.method_57826(class_9334.field_49614)
                //?} else {
                /*CompassItem.isLodestoneCompass(itemStack)
                *///?}
        ) {
            //? if >1.21 {
            var state = itemStack.method_57824(class_9334.field_49614);
            if (state == null || state.comp_2402().isEmpty()) return;
            var pos = state.comp_2402().get();
            //?} else {
            /*var pos = CompassItem.getLodestonePosition(itemStack.getTag());
            *///?}
            addCoordinates(pos, list, "target", ModHelpers.getColour(CONFIG.textTooltips.lodestoneCompassTooltipColor, class_124.field_1065));
        }
        if (CONFIG.textTooltips.recoveryCompassTooltip && itemStack.method_31574(class_1802.field_38747) && player != null) {
            var lastDeath = player.method_43122();
            if (lastDeath.isEmpty()) return;
            addCoordinates(lastDeath.get(), list, "target", ModHelpers.getColour(CONFIG.textTooltips.recoveryCompassTooltipColor, class_124.field_1075));
        }
        if (CONFIG.textTooltips.compassTooltip && itemStack.method_31574(class_1802.field_8251) && !
                //? if >1.21 {
                itemStack.method_57826(class_9334.field_49614)
                //?} else {
                /*CompassItem.isLodestoneCompass(itemStack)
                *///?}
                && player != null) {
            var pos = player.method_24515();
            addCoordinates(pos, list, "position", ModHelpers.getColour(CONFIG.textTooltips.compassTooltipColor, class_124.field_1061));
        }
        if (CONFIG.textTooltips.durabilityTooltip && !tooltipFlag.method_8035() && itemStack.method_7986()
                //? if >1.21
                && itemStack.method_57826(class_9334.field_49629)
        ) {
            list.add(class_2561.method_43469("item.durability", itemStack.method_7936() - itemStack.method_7919(), itemStack.method_7936()).method_27692(ModHelpers.getColour(CONFIG.textTooltips.durabilityTooltipColor, class_124.field_1080)));
        }
        if ((CONFIG.clockTooltip.current_time || CONFIG.clockTooltip.day_count) && itemStack.method_31574(class_1802.field_8557) && player != null) {
            list.add(class_2561.method_43470(getTime(class_310.method_1551().field_1687.method_8532())).method_27692(ModHelpers.getColour(CONFIG.clockTooltip.text_color, class_124.field_1065)));
        }
    }

    private static void addCoordinates(class_4208 globalPos, List<class_2561> list, String target, class_124 colour) {
        addCoordinates(globalPos.comp_2208(), list, target, colour);
        list.add(
                class_2561.method_43471("gui.inline_tooltips.dimension").method_27692(class_124.field_1080).method_10852(
                class_2561.method_48321(globalPos.comp_2207().method_29177().method_42093("dimension"), WordUtils.capitalizeFully(globalPos.comp_2207().method_29177().method_12832())).method_27692(colour))
        );
    }

    private static void addCoordinates(class_2338 pos, List<class_2561> list, String target, class_124 colour) {
        list.add(
                class_2561.method_43471("gui.inline_tooltips."+target).method_27692(class_124.field_1080).method_10852(
                class_2561.method_43470("X: %d, Y: %d, Z: %d".formatted(pos.method_10263(), pos.method_10264(), pos.method_10260())).method_27692(colour))
        );
    }

    // This code was originally authored by MehVadVukaar for Supplementaries.
    // It is adapted here for our clock overlay as authorized by the
    // Supplementaries Team License, as Inline Tooltips is not designed
    // to compete with Supplementaries.
    public static String getTime(float dayTime) {
        StringBuilder currentTime = new StringBuilder();
        if (InlineTooltips.CONFIG.clockTooltip.day_count) {
            int day = (int) (dayTime/24000);
            currentTime.append(class_1074.method_4662("gui.c.day", day));
            if (InlineTooltips.CONFIG.clockTooltip.current_time) {
                currentTime.append(", ");
            }
        }
        if (InlineTooltips.CONFIG.clockTooltip.current_time) {
            int time = (int)(dayTime + 6000L) % 24000;
            int m = (int)((float)time % 1000.0F / 1000.0F * 60.0F);
            int hour = time / 1000;
            String a = "";
            if (InlineTooltips.CONFIG.clockTooltip.twenty_four_hour_clock) {
                a = time < 12000 ? " AM" : " PM";
                hour %= 12;
                if (hour == 0) {
                    hour = 12;
                }
            }
            currentTime.append(hour).append(":").append(m < 10 ? "0" : "").append(m).append(a);
        }
        return currentTime.toString();
    }

    private static void addAttributeTooltips(class_1799 itemStack, List<class_2561> list, class_5250 component) {
        if (CONFIG.iconTooltips.attributeTooltips) {
            //? if >1.21 {
            for (class_9274 equipmentSlotGroup : class_9274.values()) {
            //?} else {
            /*for (EquipmentSlot equipmentSlotGroup : EquipmentSlot.values()) {
            *///?}
                //? if >1.21.8 {
                /*itemStack.forEachModifier(equipmentSlotGroup, (holder, attributeModifier, display) -> {
                    *///?} else if >1.21 {
                    itemStack.method_60617(equipmentSlotGroup, (holder, attributeModifier) -> {
                                            //?} else {
                    /*var i = itemStack.getAttributeModifiers(equipmentSlotGroup);
                    i.forEach((holder, attributeModifier) -> {
                     *///?}
                    //? if >1.21.8
                    /*if (display != ItemAttributeModifiers.Display.hidden()) {*/
                        var player = class_310.method_1551().field_1724;
                        var attributeModifierAmount = attributeModifier.
                        //? if >1.21 {
                        comp_2449();
                         //?} else {
                        /*getAmount();
                        *///?}

                        AtomicReference<Double> amount = new AtomicReference<>(attributeModifierAmount);
                        if (player != null) {
                            amount.set(switch (attributeModifier.
                                    //? if >1.21 {
                                    comp_2450
                                    //?} else {
                                    /*getOperation
                                    *///?}
                                            ()) {
                                case
                                        //? if >1.21 {
                                        field_6328
                                        //?} else {
                                        /*ADDITION
                                        *///?}
                                        -> attributeModifierAmount + player.method_45326(holder);
                                case
                                    //? if >1.21 {
                                    field_6330, field_6331
                                    //?} else {
                                    /*MULTIPLY_BASE, MULTIPLY_TOTAL
                                    *///?}
                                         ->
                                        attributeModifierAmount * player.method_45326(holder);
                            });
                        }
                        amount.set(SharpnessHelpers.addSharpnessDamage(itemStack, amount.get(), player, attributeModifier));
                        //? if >1.21 {
                        var icon = holder.method_40230().orElseThrow().method_29177();
                        //?} else {
                        /*var icon = new ResourceLocation(holder.getDescriptionId().replace("attribute.name.", ""));
                        *///?}
                        if (amount.get()!=0)
                            addIcon(icon, amount.get(), list, component, class_2561.method_43471("item.modifiers."+equipmentSlotGroup.name().toLowerCase(Locale.ROOT)), ModHelpers.getColour(CONFIG.iconTooltips.attributeTooltipColor, class_124.field_1077));
                    //? if >1.21.8
                    /*}*/
                });
            }
        }
    }

    private static void addBeeTooltips(class_1799 itemStack, List<class_2561> list, class_5250 component) {
        //? if >1.21 {
        if (itemStack.method_57826(class_9334.field_49624) && CONFIG.iconTooltips.beesTooltip) {
            var bees = itemStack.method_57824(class_9334.field_49624);
            if (bees == null) return;
            addIcon(id("bees"), bees
                    //? if >1.21.8
                    /*.bees()*/
                    .size(), list, component, null, ModHelpers.getColour(CONFIG.iconTooltips.beeTooltipColor, class_124.field_1065));
        }
        //?} else {
        /*CompoundTag tag = itemStack.getTag();
        if (tag != null && tag.contains("BlockEntityTag")) {
            CompoundTag blockEntityTag = tag.getCompound("BlockEntityTag");
            if (blockEntityTag.contains("Bees")) {
                ListTag bees = blockEntityTag.getList("Bees", Tag.TAG_COMPOUND);
                addIcon(id("bees"), bees.size(), list, component, null, ModHelpers.getColour(CONFIG.iconTooltips.honeyTooltipColor, ChatFormatting.GOLD));
            }
        }
        *///?}
    }

    private static void addFuelTooltips(class_1799 itemStack, List<class_2561> list, class_5250 component) {
        if (CONFIG.iconTooltips.fuelTooltip) {
            var level = class_310.method_1551().field_1687;
            if (level != null &&
                    //? if >1.21.8 {
                    /*level.fuelValues()
                            *///?} else {
                            class_2609
                             //?}
                            .method_11195(itemStack)) {
                addIcon(id("fuel"), getFuelValue(level, itemStack) /200f, list, component, class_2561.method_43471("item.modifiers.furnace"), ModHelpers.getColour(CONFIG.iconTooltips.fuelTooltipColor, class_124.field_1065));
            }
        }
    }

    private static void addFoodTooltips(class_1799 itemStack, List<class_2561> list, class_5250 component) {
        if (
                //? if >1.21
                itemStack.method_57826(class_9334.field_50075) &&
                        (!ModCompat.APPLE_SKIN || CONFIG.developerOptions.showFoodTooltipWithAppleSkinInstalled) && CONFIG.iconTooltips.foodTooltip) {
            var foodProperties =
                    //? if >1.21 {
                    itemStack.method_57824(class_9334.field_50075);
                    //?} else {
                    /*itemStack.getItem().getFoodProperties();
                    *///?}
            if (foodProperties == null) return;
            if (CONFIG.iconTooltips.foodTooltip)
                addIcon(id("food"), foodProperties.
                        //? if >1.21 {
                            comp_2491()
                        //?} else {
                        /*getNutrition()
                        *///?}
                        , list, component, class_2561.method_43471("item.modifiers.eaten"), ModHelpers.getColour(CONFIG.iconTooltips.foodTooltipColor, class_124.field_1065));
            if (CONFIG.iconTooltips.saturationTooltip)
                addIcon(id("saturation"), foodProperties.
                        //? if >1.21 {
                                comp_2492()
                        //?} else {
                        /*getSaturationModifier()* foodProperties.getNutrition()*2
                        *///?}
                        , list, component, class_2561.method_43471("item.modifiers.eaten"), ModHelpers.getColour(CONFIG.iconTooltips.saturationTooltipColor, class_124.field_1065));
        }
    }

    private static double getFuelValue(class_1937 level, class_1799 itemStack) {
        //? if >1.21.8 && fabric {
        /*int value = level.fuelValues().burnDuration(itemStack)
        *///?} else if fabric {
        Integer value = class_2609.method_11196().get(itemStack.method_7909());
        //?} else {
                                /*int value = itemStack.getBurnTime(null
                                //? if >1.21.8
                                , level.fuelValues()
                                )
                                *///?}
        ;
        //? if =1.21.1 && fabric {
        if (value != null)
        //?}
            return value;
        //? if =1.21.1 && fabric {
        return 0;
        //?}
    }

    private static void addHoneyTooltips(class_1799 itemStack, List<class_2561> list, class_5250 component) {
        //? if >1.21 {
        if (CONFIG.iconTooltips.honeyTooltip && itemStack.method_57826(class_9334.field_49623)) {
            var state = itemStack.method_57824(class_9334.field_49623);
            if (state == null) return;
            var honey = state.method_57418(class_4481.field_20420);
            if (honey == null) return;
            addIcon(id("honey"), honey, list, component, null, ModHelpers.getColour(CONFIG.iconTooltips.honeyTooltipColor, class_124.field_1065));
        }
        //?} else {
        /*CompoundTag tag = itemStack.getTag();
        if (tag != null && tag.contains("BlockStateTag")) {
            CompoundTag blockEntityTag = tag.getCompound("BlockStateTag");
            if (blockEntityTag.contains("honey_level")) {
                var honey = blockEntityTag.getString("honey_level");
                addIcon(id("honey"), Double.parseDouble(honey), list, component, null, ModHelpers.getColour(CONFIG.iconTooltips.honeyTooltipColor, ChatFormatting.GOLD));
            }
        }
        *///?}
    }

    private static void addLightLevelTooltips(class_1799 itemStack, List<class_2561> list, class_5250 component) {
        if (CONFIG.iconTooltips.lightLevelTooltip) {
            if (itemStack.method_7909() instanceof class_1747 blockItem) {
                //? if >1.21 {
                if (blockItem.method_7711() == class_2246.field_31037) {
                    var stateComponent =  itemStack.method_57824(class_9334.field_49623);
                    Integer light = stateComponent != null ? stateComponent.method_57418(class_6089.field_31187) : null;
                    if (light != null && light != 0)
                        addIcon(id("light"), light, list, component, class_2561.method_43471("item.modifiers.placed"), ModHelpers.getColour(CONFIG.iconTooltips.lightLevelTooltipColor, class_124.field_1065));
                } else {
                //?}
                    var state = blockItem.method_7711().method_9564();
                    int light = state.method_26213();
                    if (light != 0)
                        addIcon(id("light"), light, list, component, class_2561.method_43471("item.modifiers.placed"), ModHelpers.getColour(CONFIG.iconTooltips.lightLevelTooltipColor, class_124.field_1065));
                //? if >1.21
                }
            }
        }
    }

    private static void addIcon(class_2960 attribute, double amount, List<class_2561> list, class_5250 component, class_5250 usedText, class_124 attributeColor) {
        if (ModHelpers.hasShiftDown() && usedText != null && !list.contains(usedText.method_27692(class_124.field_1080))) {
            list.add(class_2561.method_43473());
            list.add(usedText.method_27692(class_124.field_1080));
        }

        //? if >1.21.8 {
        /*ResourceLocation icon = id(attribute.getNamespace(), "inline_tooltip_icons/"+ attribute.getPath());
        MutableComponent iconComponent = Component.object(new AtlasSprite(AtlasSprite.DEFAULT_ATLAS, icon));
        *///?} else {
        class_2960 icon = id(attribute.method_12836(), "textures/inline_tooltip_icons/%s.png".formatted(attribute.method_12832().replace("generic.", "")));
        var style = InlineStyle.fromInlineData(new SpriteInlineData(new TextureSprite(icon)));;
        class_5250 iconComponent = class_2561.method_43473().method_10852(class_2561.method_43470(".").method_10862(style));
        //?}

        if (ModHelpers.hasAltDown() && InlineTooltips.CONFIG.developerOptions.debugInfo) {
            iconComponent.method_27693(ModHelpers.format(amount) + " ");
            iconComponent.method_10852(class_2561.method_43470(" (%s)".formatted(attribute)));
            list.add(iconComponent);
        } else if (ModHelpers.hasShiftDown()) {
            var key = attribute.method_42093("tooltip").replace("generic.", "");
            if (class_1074.method_4663(key)) {
                iconComponent.method_10852(class_2561.method_43469(key, ModHelpers.format(amount)).method_27692(attributeColor));
            } else if (!InlineTooltips.CONFIG.developerOptions.debugInfo) {
                iconComponent.method_10852(class_2561.method_43470("%s %s".formatted(ModHelpers.format(amount), WordUtils.capitalizeFully(attribute.method_12832().replace("_", " ")))).method_27692(attributeColor));
            } else {
                iconComponent.method_10852(class_2561.method_43470("%s %s".formatted(ModHelpers.format(amount), key)).method_27692(attributeColor));
            }
            list.add(iconComponent);
        } else {
            iconComponent.method_27693(ModHelpers.format(amount) + " ");
            component.method_10852(iconComponent);
        }
    }

    public static void init() {

    }

    public static class_2960 id(String id) {
        return id(MOD_ID, id);
    }

    public static class_2960 id(String namespace, String id) {
        //? if >1.21 {
        return class_2960.method_60655(MOD_ID, id);
        //?} else {
        /*return new ResourceLocation(namespace, id);
        *///?}
    }
}