/*
Based on code from Sharper Tooltips
MIT License

Copyright (c) 2025 SylentHuntress

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
 */
package cc.cassian.inline_tooltips.helpers;

import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_9701;
import org.jetbrains.annotations.Nullable;

public class SharpnessHelpers {
    public static double addSharpnessDamage(class_1799 stack, double original, @Nullable class_1657 player, class_1322 modifier) {
        //? if >1.21 {
        var enchantments = stack.method_58657();
        if (enchantments.method_57543()) {
            return original;
        }

        if (modifier.method_60718(class_1792.field_8006)) {
            for (var registryEntry : enchantments.method_57539()) {
                var enchantment = registryEntry.getKey().comp_349();

                for (var effectEntry : enchantment.method_60034(class_9701.field_51661)) {
                    if (effectEntry.comp_2681().isPresent()) {
                        continue;
                    }

                    original = effectEntry.comp_2680().method_60213(
                            enchantments.method_57536(registryEntry.getKey()),
                            player != null
                                    ? player.method_59922()
                                    : null,
                            (float) original
                    );
                }
            }
        }
        //?}

        return original;
    }
}
