package cc.cassian.inline_tooltips.helpers;

import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_310;

public class ModHelpers {
    public static String format(double amount) {
        String format = String.format("%1.1f", amount);
        if (format.endsWith(".0")) {
            return String.valueOf(Math.round(amount));
        }
        return format;
    }

    public static boolean hasShiftDown() {
        //? if >1.21.8 {
        return class_310.method_1551().method_74187();
        //?} else {
        /*return Screen.hasShiftDown();
        *///?}
    }

    public static boolean hasAltDown() {
        //? if >1.21.8 {
        return class_310.method_1551().method_74189();
        //?} else {
        /*return Screen.hasAltDown();
        *///?}
    }

    /**
     * Used to check what colour the text should be.
     * Adapted from Item Descriptions.
     */
    public static Integer getColour(String colour, class_124 fallback) {
        String replacedColour = colour.toLowerCase().replace(" ", "_");
        return switch (replacedColour) {
            case "black", "dark_blue", "dark_green", "dark_red", "dark_purple",
                 "blue", "green", "aqua", "red", "yellow", "white" ->
                    Objects.requireNonNullElse(class_124.method_533(colour), class_124.field_1080).method_532();
            case "pink", "light_purple" ->
                    Objects.requireNonNullElse(class_124.method_533("light_purple"), class_124.field_1080).method_532();
            case "dark_gray", "dark_grey" ->
                    Objects.requireNonNullElse(class_124.method_533("dark_gray"), class_124.field_1080).method_532();
            case "cyan", "dark_aqua" ->
                    Objects.requireNonNullElse(class_124.method_533("dark_aqua"), class_124.field_1080).method_532();
            case "orange", "gold", "dark_yellow" ->
                    Objects.requireNonNullElse(class_124.method_533("gold"), class_124.field_1080).method_532();
            default -> fallback.method_532();
        };
    }

}
