/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.inline_tooltips;

import cc.cassian.inline_tooltips.Platform;
import cc.cassian.inline_tooltips.compat.ModCompat;
import cc.cassian.inline_tooltips.config.ModConfig;
import cc.cassian.inline_tooltips.helpers.ModHelpers;
import cc.cassian.inline_tooltips.helpers.SharpnessHelpers;
import com.google.common.collect.Multimap;
import com.samsthenerd.inline.api.InlineData;
import com.samsthenerd.inline.api.data.SpriteInlineData;
import com.samsthenerd.inline.impl.InlineStyle;
import com.samsthenerd.inline.utils.Spritelike;
import com.samsthenerd.inline.utils.TextureSprite;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1304;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1759;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2609;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_4174;
import net.minecraft.class_4208;
import net.minecraft.class_5250;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.apache.commons.lang3.text.WordUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InlineTooltips {
    public static final String MOD_ID = "inline_tooltips";
    public static final ModConfig CONFIG = (ModConfig)ModConfig.createToml((Path)Platform.INSTANCE.getConfigDir(), (String)"", (String)"inline_tooltips", ModConfig.class);
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"inline_tooltips");
    private static final class_2960 UNDEFINED = InlineTooltips.id("inline_tooltips", "textures/inline_tooltip_icons/empty.png");

    public static void addTooltips(class_1799 itemStack, class_1836 tooltipFlag, List<class_2561> list) {
        class_4208 pos;
        class_746 player = class_310.method_1551().field_1724;
        class_5250 component = class_2561.method_43473();
        InlineTooltips.addAttributeTooltips(itemStack, list, component);
        InlineTooltips.addBeeTooltips(itemStack, list, component);
        InlineTooltips.addFoodTooltips(itemStack, list, component);
        InlineTooltips.addFuelTooltips(itemStack, list, component);
        InlineTooltips.addHoneyTooltips(itemStack, list, component);
        InlineTooltips.addLightLevelTooltips(itemStack, list, component);
        if (!component.equals((Object)class_2561.method_43473())) {
            list.add((class_2561)component);
        }
        if (InlineTooltips.CONFIG.textTooltips.lodestoneTooltip && class_1759.method_26365((class_1799)itemStack)) {
            pos = class_1759.method_43124((class_2487)itemStack.method_7969());
            InlineTooltips.addCoordinates(pos, list, "target", ModHelpers.getColour(InlineTooltips.CONFIG.textTooltips.lodestoneCompassTooltipColor, class_124.field_1065));
        }
        if (InlineTooltips.CONFIG.textTooltips.recoveryCompassTooltip && itemStack.method_31574(class_1802.field_38747) && player != null) {
            Optional lastDeath = player.method_43122();
            if (lastDeath.isEmpty()) {
                return;
            }
            InlineTooltips.addCoordinates((class_4208)lastDeath.get(), list, "target", ModHelpers.getColour(InlineTooltips.CONFIG.textTooltips.recoveryCompassTooltipColor, class_124.field_1075));
        }
        if (InlineTooltips.CONFIG.textTooltips.compassTooltip && itemStack.method_31574(class_1802.field_8251) && !class_1759.method_26365((class_1799)itemStack) && player != null) {
            pos = player.method_24515();
            InlineTooltips.addCoordinates((class_2338)pos, list, "position", ModHelpers.getColour(InlineTooltips.CONFIG.textTooltips.compassTooltipColor, class_124.field_1061));
        }
        if (InlineTooltips.CONFIG.durabilityTooltip.enable && !tooltipFlag.method_8035() && (InlineTooltips.CONFIG.durabilityTooltip.always_show || itemStack.method_7986()) && itemStack.method_7963()) {
            list.add((class_2561)class_2561.method_43469((String)"item.durability", (Object[])new Object[]{itemStack.method_7936() - itemStack.method_7919(), itemStack.method_7936()}).method_27692(ModHelpers.getColour(InlineTooltips.CONFIG.durabilityTooltip.text_color, class_124.field_1080)));
        }
        if ((InlineTooltips.CONFIG.clockTooltip.current_time || InlineTooltips.CONFIG.clockTooltip.day_count) && itemStack.method_31574(class_1802.field_8557) && player != null) {
            list.add((class_2561)class_2561.method_43470((String)InlineTooltips.getTime(class_310.method_1551().field_1687.method_8532())).method_27692(ModHelpers.getColour(InlineTooltips.CONFIG.clockTooltip.text_color, class_124.field_1065)));
        }
    }

    private static void addCoordinates(class_4208 globalPos, List<class_2561> list, String target, class_124 colour) {
        InlineTooltips.addCoordinates(globalPos.method_19446(), list, target, colour);
        list.add((class_2561)class_2561.method_43471((String)"gui.inline_tooltips.dimension").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_48321((String)globalPos.method_19442().method_29177().method_42093("dimension"), (String)WordUtils.capitalizeFully((String)globalPos.method_19442().method_29177().method_12832())).method_27692(colour)));
    }

    private static void addCoordinates(class_2338 pos, List<class_2561> list, String target, class_124 colour) {
        list.add((class_2561)class_2561.method_43471((String)("gui.inline_tooltips." + target)).method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)"X: %d, Y: %d, Z: %d".formatted(pos.method_10263(), pos.method_10264(), pos.method_10260())).method_27692(colour)));
    }

    public static String getTime(float dayTime) {
        StringBuilder currentTime = new StringBuilder();
        if (InlineTooltips.CONFIG.clockTooltip.day_count) {
            int day = (int)(dayTime / 24000.0f);
            currentTime.append(class_1074.method_4662((String)"gui.c.day", (Object[])new Object[]{day}));
            if (InlineTooltips.CONFIG.clockTooltip.current_time) {
                currentTime.append(", ");
            }
        }
        if (InlineTooltips.CONFIG.clockTooltip.current_time) {
            int time = (int)(dayTime + 6000.0f) % 24000;
            int m = (int)((float)time % 1000.0f / 1000.0f * 60.0f);
            int hour = time / 1000;
            String a = "";
            if (InlineTooltips.CONFIG.clockTooltip.twenty_four_hour_clock) {
                String string = a = time < 12000 ? " AM" : " PM";
                if ((hour %= 12) == 0) {
                    hour = 12;
                }
            }
            currentTime.append(hour).append(":").append(m < 10 ? "0" : "").append(m).append(a);
        }
        return currentTime.toString();
    }

    private static void addAttributeTooltips(class_1799 itemStack, List<class_2561> list, class_5250 component) {
        if (InlineTooltips.CONFIG.iconTooltips.attributeTooltips) {
            for (class_1304 equipmentSlotGroup : class_1304.values()) {
                Multimap i = itemStack.method_7926(equipmentSlotGroup);
                i.forEach((holder, attributeModifier) -> {
                    class_746 player = class_310.method_1551().field_1724;
                    double attributeModifierAmount = attributeModifier.method_6186();
                    AtomicReference<Double> amount = new AtomicReference<Double>(attributeModifierAmount);
                    if (player != null && player.method_6127().method_27306(holder)) {
                        amount.set(switch (attributeModifier.method_6182()) {
                            default -> throw new IncompatibleClassChangeError();
                            case class_1322.class_1323.field_6328 -> attributeModifierAmount + player.method_26826(holder);
                            case class_1322.class_1323.field_6330, class_1322.class_1323.field_6331 -> attributeModifierAmount * player.method_26826(holder);
                        });
                    }
                    amount.set(SharpnessHelpers.addSharpnessDamage(itemStack, amount.get(), (class_1657)player, attributeModifier));
                    class_2960 icon = new class_2960(holder.method_26830().replace("attribute.name.", ""));
                    if (amount.get() != 0.0) {
                        InlineTooltips.addIcon(icon, amount.get(), list, component, class_2561.method_43471((String)("item.modifiers." + equipmentSlotGroup.name().toLowerCase(Locale.ROOT))), ModHelpers.getColour(InlineTooltips.CONFIG.iconTooltips.attributeTooltipColor, class_124.field_1077));
                    }
                });
            }
        }
    }

    private static void addBeeTooltips(class_1799 itemStack, List<class_2561> list, class_5250 component) {
        class_2487 blockEntityTag;
        class_2487 tag = itemStack.method_7969();
        if (tag != null && tag.method_10545("BlockEntityTag") && (blockEntityTag = tag.method_10562("BlockEntityTag")).method_10545("Bees")) {
            class_2499 bees = blockEntityTag.method_10554("Bees", 10);
            InlineTooltips.addIcon(InlineTooltips.id("bees"), bees.size(), list, component, null, ModHelpers.getColour(InlineTooltips.CONFIG.iconTooltips.honeyTooltipColor, class_124.field_1065));
        }
    }

    private static void addFuelTooltips(class_1799 itemStack, List<class_2561> list, class_5250 component) {
        class_638 level;
        if (InlineTooltips.CONFIG.iconTooltips.fuelTooltip && (level = class_310.method_1551().field_1687) != null && class_2609.method_11195((class_1799)itemStack)) {
            InlineTooltips.addIcon(InlineTooltips.id("fuel"), InlineTooltips.getFuelValue((class_1937)level, itemStack) / 200.0, list, component, class_2561.method_43471((String)"item.modifiers.furnace"), ModHelpers.getColour(InlineTooltips.CONFIG.iconTooltips.fuelTooltipColor, class_124.field_1065));
        }
    }

    private static void addFoodTooltips(class_1799 itemStack, List<class_2561> list, class_5250 component) {
        if ((!ModCompat.APPLE_SKIN || InlineTooltips.CONFIG.developerOptions.showFoodTooltipWithAppleSkinInstalled) && InlineTooltips.CONFIG.iconTooltips.foodTooltip) {
            class_4174 foodProperties = itemStack.method_7909().method_19264();
            if (foodProperties == null) {
                return;
            }
            if (InlineTooltips.CONFIG.iconTooltips.foodTooltip) {
                InlineTooltips.addIcon(InlineTooltips.id("food"), foodProperties.method_19230(), list, component, class_2561.method_43471((String)"item.modifiers.eaten"), ModHelpers.getColour(InlineTooltips.CONFIG.iconTooltips.foodTooltipColor, class_124.field_1065));
            }
            if (InlineTooltips.CONFIG.iconTooltips.saturationTooltip) {
                InlineTooltips.addIcon(InlineTooltips.id("saturation"), foodProperties.method_19231() * (float)foodProperties.method_19230() * 2.0f, list, component, class_2561.method_43471((String)"item.modifiers.eaten"), ModHelpers.getColour(InlineTooltips.CONFIG.iconTooltips.saturationTooltipColor, class_124.field_1065));
            }
        }
    }

    private static double getFuelValue(class_1937 level, class_1799 itemStack) {
        Integer value = (Integer)class_2609.method_11196().get(itemStack.method_7909());
        return value.intValue();
    }

    private static void addHoneyTooltips(class_1799 itemStack, List<class_2561> list, class_5250 component) {
        class_2487 blockEntityTag;
        class_2487 tag = itemStack.method_7969();
        if (tag != null && tag.method_10545("BlockStateTag") && (blockEntityTag = tag.method_10562("BlockStateTag")).method_10545("honey_level")) {
            String honey = blockEntityTag.method_10558("honey_level");
            InlineTooltips.addIcon(InlineTooltips.id("honey"), Double.parseDouble(honey), list, component, null, ModHelpers.getColour(InlineTooltips.CONFIG.iconTooltips.honeyTooltipColor, class_124.field_1065));
        }
    }

    private static void addLightLevelTooltips(class_1799 itemStack, List<class_2561> list, class_5250 component) {
        class_1747 blockItem;
        class_2680 state;
        int light;
        class_1792 class_17922;
        if (InlineTooltips.CONFIG.iconTooltips.lightLevelTooltip && (class_17922 = itemStack.method_7909()) instanceof class_1747 && (light = (state = (blockItem = (class_1747)class_17922).method_7711().method_9564()).method_26213()) != 0) {
            InlineTooltips.addIcon(InlineTooltips.id("light"), light, list, component, class_2561.method_43471((String)"item.modifiers.placed"), ModHelpers.getColour(InlineTooltips.CONFIG.iconTooltips.lightLevelTooltipColor, class_124.field_1065));
        }
    }

    private static void addIcon(class_2960 attribute, double amount, List<class_2561> list, class_5250 component, class_5250 usedText, class_124 attributeColor) {
        if (ModHelpers.hasShiftDown() && usedText != null && !list.contains(usedText.method_27692(class_124.field_1080))) {
            list.add((class_2561)class_2561.method_43473());
            list.add((class_2561)usedText.method_27692(class_124.field_1080));
        }
        attribute = InlineTooltips.id(attribute.method_12836(), attribute.method_12832().replace("generic.", "").replace("zombie.", "").replace("player.", ""));
        class_2960 icon = InlineTooltips.id(attribute.method_12836(), "textures/inline_tooltip_icons/%s.png".formatted(attribute.method_12832()));
        class_3300 manager = class_310.method_1551().method_1478();
        if (manager.method_14486(icon).isEmpty()) {
            icon = UNDEFINED;
        }
        class_2583 style = InlineStyle.fromInlineData((InlineData)new SpriteInlineData((Spritelike)new TextureSprite(icon)));
        class_5250 iconComponent = class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)".").method_10862(style));
        String spacing = new String(new char[InlineTooltips.CONFIG.general.spacing]).replace("\u0000", " ");
        String expandedSpacing = new String(new char[InlineTooltips.CONFIG.general.expandedSpacing]).replace("\u0000", " ");
        if (ModHelpers.hasAltDown() && InlineTooltips.CONFIG.developerOptions.debugInfo) {
            iconComponent.method_27693(ModHelpers.format(amount) + " ");
            iconComponent.method_10852((class_2561)class_2561.method_43470((String)" (%s)".formatted(attribute)));
            list.add((class_2561)iconComponent);
        } else if (ModHelpers.hasShiftDown()) {
            iconComponent.method_27693(expandedSpacing);
            String key = attribute.method_42093("tooltip");
            if (class_1074.method_4663((String)key)) {
                iconComponent.method_10852((class_2561)class_2561.method_43469((String)key, (Object[])new Object[]{ModHelpers.format(amount)}).method_27692(attributeColor));
            } else if (!InlineTooltips.CONFIG.developerOptions.debugInfo) {
                iconComponent.method_10852((class_2561)class_2561.method_43470((String)"%s %s".formatted(ModHelpers.format(amount), WordUtils.capitalizeFully((String)attribute.method_12832().replace("_", " ")))).method_27692(attributeColor));
            } else {
                iconComponent.method_10852((class_2561)class_2561.method_43470((String)"%s %s".formatted(ModHelpers.format(amount), key)).method_27692(attributeColor));
            }
            list.add((class_2561)iconComponent);
        } else {
            iconComponent.method_27693(ModHelpers.format(amount) + spacing);
            component.method_10852((class_2561)iconComponent);
        }
    }

    public static void init() {
    }

    public static class_2960 id(String id) {
        return InlineTooltips.id(MOD_ID, id);
    }

    public static class_2960 id(String namespace, String id) {
        return new class_2960(namespace, id);
    }
}

