/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.exploration;

import codechicken.microblock.api.MicroMaterial;
import com.mojang.serialization.MapCodec;
import java.util.concurrent.CompletableFuture;
import mrtjp.projectred.exploration.data.ExplorationBlockStateModelProvider;
import mrtjp.projectred.exploration.data.ExplorationBlockTagsProvider;
import mrtjp.projectred.exploration.data.ExplorationBuiltInEntriesProvider;
import mrtjp.projectred.exploration.data.ExplorationItemModelProvider;
import mrtjp.projectred.exploration.data.ExplorationItemTagsProvider;
import mrtjp.projectred.exploration.data.ExplorationLanguageProvider;
import mrtjp.projectred.exploration.data.ExplorationLootTableProvider;
import mrtjp.projectred.exploration.data.ExplorationRecipeProvider;
import mrtjp.projectred.exploration.init.ExplorationArmorMaterials;
import mrtjp.projectred.exploration.init.ExplorationBlocks;
import mrtjp.projectred.exploration.init.ExplorationClientInit;
import mrtjp.projectred.exploration.init.ExplorationCreativeModeTabs;
import mrtjp.projectred.exploration.init.ExplorationDataComponents;
import mrtjp.projectred.exploration.init.ExplorationItems;
import mrtjp.projectred.exploration.init.ExplorationMenus;
import mrtjp.projectred.exploration.init.ExplorationRecipeSerializers;
import mrtjp.projectred.exploration.init.ExplorationWorldFeatures;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.carver.WorldCarver;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.Nullable;

@Mod(value="projectred_exploration")
public class ProjectRedExploration {
    public static final String MOD_ID = "projectred_exploration";
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK, (String)"projectred_exploration");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((Registry)BuiltInRegistries.ITEM, (String)"projectred_exploration");
    public static final DeferredRegister<MenuType<?>> MENU_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.MENU, (String)"projectred_exploration");
    public static final DeferredRegister<WorldCarver<?>> WORLD_CARVERS = DeferredRegister.create((Registry)BuiltInRegistries.CARVER, (String)"projectred_exploration");
    public static final DeferredRegister<MapCodec<? extends BiomeModifier>> BIOME_MODIFIER_SERIALIZERS = DeferredRegister.create((Registry)NeoForgeRegistries.BIOME_MODIFIER_SERIALIZERS, (String)"projectred_exploration");
    public static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((Registry)BuiltInRegistries.RECIPE_SERIALIZER, (String)"projectred_exploration");
    public static final DeferredRegister<MicroMaterial> MICRO_MATERIALS = DeferredRegister.create((Registry)MicroMaterial.REGISTRY, (String)"projectred_exploration");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"projectred_exploration");
    public static final DeferredRegister<DataComponentType<?>> DATA_COMPONENT_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.DATA_COMPONENT_TYPE, (String)"projectred_exploration");
    public static final DeferredRegister<ArmorMaterial> ARMOR_MATERIALS = DeferredRegister.create((Registry)BuiltInRegistries.ARMOR_MATERIAL, (String)"projectred_exploration");
    @Nullable
    private static ModContainer container;

    public ProjectRedExploration(ModContainer container, IEventBus modEventBus) {
        ProjectRedExploration.container = container;
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::onGatherDataEvent);
        modEventBus.addListener(ExplorationBlocks::onRegisterMicroMaterials);
        if (FMLEnvironment.dist.isClient()) {
            ExplorationClientInit.init(modEventBus);
        }
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        MENU_TYPES.register(modEventBus);
        WORLD_CARVERS.register(modEventBus);
        BIOME_MODIFIER_SERIALIZERS.register(modEventBus);
        RECIPE_SERIALIZERS.register(modEventBus);
        MICRO_MATERIALS.register(modEventBus);
        CREATIVE_TABS.register(modEventBus);
        DATA_COMPONENT_TYPES.register(modEventBus);
        ARMOR_MATERIALS.register(modEventBus);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    private void onGatherDataEvent(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        CompletableFuture provider = event.getLookupProvider();
        generator.addProvider(event.includeClient(), (DataProvider)new ExplorationBlockStateModelProvider(output, fileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ExplorationItemModelProvider(output, fileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ExplorationLanguageProvider(output));
        ExplorationBuiltInEntriesProvider explorationProvider = new ExplorationBuiltInEntriesProvider(output, provider);
        generator.addProvider(event.includeServer(), (DataProvider)explorationProvider);
        ExplorationBlockTagsProvider blockTagsProvider = new ExplorationBlockTagsProvider(output, provider, fileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTagsProvider);
        generator.addProvider(event.includeServer(), (DataProvider)new ExplorationItemTagsProvider(output, provider, blockTagsProvider.contentsGetter(), fileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ExplorationLootTableProvider(output, provider));
        generator.addProvider(event.includeServer(), (DataProvider)new ExplorationRecipeProvider(provider, output));
    }

    static {
        ExplorationBlocks.register();
        ExplorationItems.register();
        ExplorationMenus.register();
        ExplorationWorldFeatures.register();
        ExplorationRecipeSerializers.register();
        ExplorationCreativeModeTabs.register();
        ExplorationDataComponents.register();
        ExplorationArmorMaterials.register();
    }
}

