/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.exploration.block;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.joml.Vector3f;

public class ElectrotineOreBlock
extends DropExperienceBlock {
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    public static final DustParticleOptions ELECTROTINE_PARTICLE = new DustParticleOptions(new Vector3f(0.05882353f, 0.40392157f, 0.69803923f), 0.6f);

    public ElectrotineOreBlock(IntProvider xpRange, BlockBehaviour.Properties properties) {
        super(xpRange, properties.lightLevel(s -> (Boolean)s.getValue((Property)LIT) != false ? 9 : 0));
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public void attack(BlockState state, Level world, BlockPos pos, Player player) {
        ElectrotineOreBlock.interact(state, world, pos);
        super.attack(state, world, pos, player);
    }

    public void stepOn(Level world, BlockPos pos, BlockState state, Entity player) {
        ElectrotineOreBlock.interact(world.getBlockState(pos), world, pos);
        super.stepOn(world, pos, state, player);
    }

    public InteractionResult use(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
        if (world.isClientSide) {
            ElectrotineOreBlock.spawnParticles(world, pos);
        } else {
            ElectrotineOreBlock.interact(state, world, pos);
        }
        ItemStack itemstack = player.getItemInHand(hand);
        return itemstack.getItem() instanceof BlockItem && new BlockPlaceContext(player, hand, itemstack, rayTraceResult).canPlace() ? InteractionResult.PASS : InteractionResult.SUCCESS;
    }

    private static void interact(BlockState state, Level world, BlockPos pos) {
        ElectrotineOreBlock.spawnParticles(world, pos);
        if (!((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            world.setBlock(pos, (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    public boolean isRandomlyTicking(BlockState state) {
        return (Boolean)state.getValue((Property)LIT);
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, Random random) {
        if (((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            world.setBlock(pos, (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            ElectrotineOreBlock.spawnParticles(world, pos);
        }
    }

    private static void spawnParticles(Level world, BlockPos pos) {
        double d0 = 0.5625;
        RandomSource random = world.random;
        for (Direction direction : Direction.values()) {
            BlockPos blockpos = pos.relative(direction);
            if (world.getBlockState(blockpos).isSolidRender((BlockGetter)world, blockpos)) continue;
            Direction.Axis axis = direction.getAxis();
            double d1 = axis == Direction.Axis.X ? 0.5 + d0 * (double)direction.getStepX() : (double)random.nextFloat();
            double d2 = axis == Direction.Axis.Y ? 0.5 + d0 * (double)direction.getStepY() : (double)random.nextFloat();
            double d3 = axis == Direction.Axis.Z ? 0.5 + d0 * (double)direction.getStepZ() : (double)random.nextFloat();
            world.addParticle((ParticleOptions)ELECTROTINE_PARTICLE, (double)pos.getX() + d1, (double)pos.getY() + d2, (double)pos.getZ() + d3, 0.0, 0.0, 0.0);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.add(new Property[]{LIT});
    }
}

