/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.exploration.data;

import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import mrtjp.projectred.core.init.CoreItems;
import mrtjp.projectred.exploration.ProjectRedExploration;
import mrtjp.projectred.exploration.init.ExplorationBlocks;
import mrtjp.projectred.exploration.init.ExplorationItems;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class ExplorationLootTableProvider
extends LootTableProvider {
    public ExplorationLootTableProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, Set.of(), List.of(new LootTableProvider.SubProviderEntry(BlockLootTable::new, LootContextParamSets.BLOCK)), registries);
    }

    private static final class BlockLootTable
    extends BlockLootSubProvider {
        BlockLootTable(HolderLookup.Provider provider) {
            super(Set.of(), FeatureFlags.REGISTRY.allFlags(), provider);
        }

        protected Iterable<Block> getKnownBlocks() {
            return ProjectRedExploration.BLOCKS.getEntries().stream().map(Holder::value).toList();
        }

        protected void generate() {
            this.add(ExplorationBlocks.RUBY_ORE_BLOCK.get(), b -> this.createOreMultiDrops((Block)b, (ItemLike)CoreItems.RUBY_ITEM.get(), 1.0f, 2.0f));
            this.add(ExplorationBlocks.DEEPSLATE_RUBY_ORE_BLOCK.get(), b -> this.createOreMultiDrops((Block)b, (ItemLike)CoreItems.RUBY_ITEM.get(), 1.0f, 2.0f));
            this.add(ExplorationBlocks.SAPPHIRE_ORE_BLOCK.get(), b -> this.createOreMultiDrops((Block)b, (ItemLike)CoreItems.SAPPHIRE_ITEM.get(), 1.0f, 2.0f));
            this.add(ExplorationBlocks.DEEPSLATE_SAPPHIRE_ORE_BLOCK.get(), b -> this.createOreMultiDrops((Block)b, (ItemLike)CoreItems.SAPPHIRE_ITEM.get(), 1.0f, 2.0f));
            this.add(ExplorationBlocks.PERIDOT_ORE_BLOCK.get(), b -> this.createOreMultiDrops((Block)b, (ItemLike)CoreItems.PERIDOT_ITEM.get(), 1.0f, 2.0f));
            this.add(ExplorationBlocks.DEEPSLATE_PERIDOT_ORE_BLOCK.get(), b -> this.createOreMultiDrops((Block)b, (ItemLike)CoreItems.PERIDOT_ITEM.get(), 1.0f, 2.0f));
            this.add(ExplorationBlocks.ELECTROTINE_ORE_BLOCK.get(), b -> this.createOreMultiDrops((Block)b, (ItemLike)CoreItems.ELECTROTINE_DUST_ITEM.get(), 1.0f, 8.0f));
            this.add(ExplorationBlocks.DEEPSLATE_ELECTROTINE_ORE_BLOCK.get(), b -> this.createOreMultiDrops((Block)b, (ItemLike)CoreItems.ELECTROTINE_DUST_ITEM.get(), 1.0f, 8.0f));
            this.add(ExplorationBlocks.TIN_ORE_BLOCK.get(), b -> this.createOreDrop((Block)b, ExplorationItems.RAW_TIN_ITEM.get()));
            this.add(ExplorationBlocks.DEEPSLATE_TIN_ORE_BLOCK.get(), b -> this.createOreDrop((Block)b, ExplorationItems.RAW_TIN_ITEM.get()));
            this.add(ExplorationBlocks.SILVER_ORE_BLOCK.get(), b -> this.createOreDrop((Block)b, ExplorationItems.RAW_SILVER_ITEM.get()));
            this.add(ExplorationBlocks.DEEPSLATE_SILVER_ORE_BLOCK.get(), b -> this.createOreDrop((Block)b, ExplorationItems.RAW_SILVER_ITEM.get()));
            this.dropSelf(ExplorationBlocks.MARBLE_BLOCK.get());
            this.dropSelf(ExplorationBlocks.MARBLE_BRICK_BLOCK.get());
            this.dropSelf(ExplorationBlocks.BASALT_BLOCK.get());
            this.dropSelf(ExplorationBlocks.BASALT_COBBLE_BLOCK.get());
            this.dropSelf(ExplorationBlocks.BASALT_BRICK_BLOCK.get());
            this.dropSelf(ExplorationBlocks.RUBY_BLOCK.get());
            this.dropSelf(ExplorationBlocks.SAPPHIRE_BLOCK.get());
            this.dropSelf(ExplorationBlocks.PERIDOT_BLOCK.get());
            this.dropSelf(ExplorationBlocks.ELECTROTINE_BLOCK.get());
            this.dropSelf(ExplorationBlocks.RAW_TIN_BLOCK.get());
            this.dropSelf(ExplorationBlocks.RAW_SILVER_BLOCK.get());
            this.dropSelf(ExplorationBlocks.TIN_BLOCK.get());
            this.dropSelf(ExplorationBlocks.SILVER_BLOCK.get());
            this.dropSelf((Block)ExplorationBlocks.MARBLE_WALL.get());
            this.dropSelf((Block)ExplorationBlocks.MARBLE_BRICK_WALL.get());
            this.dropSelf((Block)ExplorationBlocks.BASALT_WALL.get());
            this.dropSelf((Block)ExplorationBlocks.BASALT_COBBLE_WALL.get());
            this.dropSelf((Block)ExplorationBlocks.BASALT_BRICK_WALL.get());
            this.dropSelf((Block)ExplorationBlocks.RUBY_BLOCK_WALL.get());
            this.dropSelf((Block)ExplorationBlocks.SAPPHIRE_BLOCK_WALL.get());
            this.dropSelf((Block)ExplorationBlocks.PERIDOT_BLOCK_WALL.get());
            this.dropSelf((Block)ExplorationBlocks.ELECTROTINE_BLOCK_WALL.get());
        }

        private LootTable.Builder createOreMultiDrops(Block oreBlock, ItemLike dropItem, float min, float max) {
            HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
            return this.createSilkTouchDispatchTable(oreBlock, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)oreBlock, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)dropItem).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)min, (float)max))).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE)))));
        }
    }
}

