/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.exploration.data;

import codechicken.lib.datagen.recipe.RecipeProvider;
import codechicken.lib.datagen.recipe.ShapedRecipeBuilder;
import codechicken.microblock.init.CBMicroblockModContent;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import mrtjp.projectred.core.init.CoreItems;
import mrtjp.projectred.core.init.CoreTags;
import mrtjp.projectred.exploration.init.ExplorationBlocks;
import mrtjp.projectred.exploration.init.ExplorationItems;
import mrtjp.projectred.exploration.init.ExplorationTags;
import mrtjp.projectred.exploration.item.BackpackItem;
import mrtjp.projectred.exploration.item.crafting.BackpackDyeRecipe;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;

public class ExplorationRecipeProvider
extends RecipeProvider {
    public ExplorationRecipeProvider(CompletableFuture<HolderLookup.Provider> registries, PackOutput output) {
        super(registries, output, "projectred_exploration");
    }

    protected void registerRecipes() {
        this.oreSmeltingRecipe((ItemLike)CoreItems.RUBY_ITEM.get(), List.of((ItemLike)ExplorationBlocks.RUBY_ORE_BLOCK.get(), (ItemLike)ExplorationBlocks.DEEPSLATE_RUBY_ORE_BLOCK.get()), 1.0f);
        this.oreSmeltingRecipe((ItemLike)CoreItems.SAPPHIRE_ITEM.get(), List.of((ItemLike)ExplorationBlocks.SAPPHIRE_ORE_BLOCK.get(), (ItemLike)ExplorationBlocks.DEEPSLATE_SAPPHIRE_ORE_BLOCK.get()), 1.0f);
        this.oreSmeltingRecipe((ItemLike)CoreItems.PERIDOT_ITEM.get(), List.of((ItemLike)ExplorationBlocks.PERIDOT_ORE_BLOCK.get(), (ItemLike)ExplorationBlocks.DEEPSLATE_PERIDOT_ORE_BLOCK.get()), 1.0f);
        this.oreSmeltingRecipe((ItemLike)CoreItems.ELECTROTINE_DUST_ITEM.get(), List.of((ItemLike)ExplorationBlocks.ELECTROTINE_ORE_BLOCK.get(), (ItemLike)ExplorationBlocks.DEEPSLATE_ELECTROTINE_ORE_BLOCK.get()), 0.7f);
        this.oreSmeltingRecipe((ItemLike)ExplorationItems.TIN_INGOT_ITEM.get(), List.of((ItemLike)ExplorationBlocks.TIN_ORE_BLOCK.get(), (ItemLike)ExplorationBlocks.DEEPSLATE_TIN_ORE_BLOCK.get(), (ItemLike)ExplorationItems.RAW_TIN_ITEM.get()), 0.7f);
        this.oreSmeltingRecipe((ItemLike)ExplorationItems.SILVER_INGOT_ITEM.get(), List.of((ItemLike)ExplorationBlocks.SILVER_ORE_BLOCK.get(), (ItemLike)ExplorationBlocks.DEEPSLATE_SILVER_ORE_BLOCK.get(), (ItemLike)ExplorationItems.RAW_SILVER_ITEM.get()), 0.7f);
        this.smelting((ItemLike)ExplorationBlocks.BASALT_BLOCK.get()).ingredient((ItemLike)ExplorationBlocks.BASALT_COBBLE_BLOCK.get()).experience(0.1f);
        this.shapedRecipe((ItemLike)ExplorationBlocks.MARBLE_BRICK_BLOCK.get(), 4).key('B', (ItemLike)ExplorationBlocks.MARBLE_BLOCK.get()).patternLine("BB").patternLine("BB");
        this.shapedRecipe((ItemLike)ExplorationBlocks.BASALT_BRICK_BLOCK.get(), 4).key('B', (ItemLike)ExplorationBlocks.BASALT_BLOCK.get()).patternLine("BB").patternLine("BB");
        this.nineBlockStorageRecipes((TagKey<Item>)CoreTags.RUBY_GEM_TAG, (ItemLike)ExplorationBlocks.RUBY_BLOCK.get(), (ItemLike)CoreItems.RUBY_ITEM.get());
        this.nineBlockStorageRecipes((TagKey<Item>)CoreTags.SAPPHIRE_GEM_TAG, (ItemLike)ExplorationBlocks.SAPPHIRE_BLOCK.get(), (ItemLike)CoreItems.SAPPHIRE_ITEM.get());
        this.nineBlockStorageRecipes((TagKey<Item>)CoreTags.PERIDOT_GEM_TAG, (ItemLike)ExplorationBlocks.PERIDOT_BLOCK.get(), (ItemLike)CoreItems.PERIDOT_ITEM.get());
        this.nineBlockStorageRecipes((TagKey<Item>)CoreTags.ELECTROTINE_DUST_TAG, (ItemLike)ExplorationBlocks.ELECTROTINE_BLOCK.get(), (ItemLike)CoreItems.ELECTROTINE_DUST_ITEM.get());
        this.nineBlockStorageRecipes(ExplorationTags.RAW_MATERIALS_TIN_TAG, (ItemLike)ExplorationBlocks.RAW_TIN_BLOCK.get(), (ItemLike)ExplorationItems.RAW_TIN_ITEM.get());
        this.nineBlockStorageRecipes((TagKey<Item>)CoreTags.TIN_INGOT_TAG, (ItemLike)ExplorationBlocks.TIN_BLOCK.get(), (ItemLike)ExplorationItems.TIN_INGOT_ITEM.get());
        this.nineBlockStorageRecipes(ExplorationTags.RAW_MATERIALS_SILVER_TAG, (ItemLike)ExplorationBlocks.RAW_SILVER_BLOCK.get(), (ItemLike)ExplorationItems.RAW_SILVER_ITEM.get());
        this.nineBlockStorageRecipes((TagKey<Item>)CoreTags.SILVER_INGOT_TAG, (ItemLike)ExplorationBlocks.SILVER_BLOCK.get(), (ItemLike)ExplorationItems.SILVER_INGOT_ITEM.get());
        this.wallRecipe((ItemLike)ExplorationBlocks.MARBLE_WALL.get(), ExplorationTags.MARBLE_BLOCK_ITEM_TAG);
        this.wallRecipe((ItemLike)ExplorationBlocks.MARBLE_BRICK_WALL.get(), (ItemLike)ExplorationBlocks.MARBLE_BRICK_BLOCK.get());
        this.wallRecipe((ItemLike)ExplorationBlocks.BASALT_WALL.get(), ExplorationTags.BASALT_BLOCK_ITEM_TAG);
        this.wallRecipe((ItemLike)ExplorationBlocks.BASALT_COBBLE_WALL.get(), (ItemLike)ExplorationBlocks.BASALT_COBBLE_BLOCK.get());
        this.wallRecipe((ItemLike)ExplorationBlocks.BASALT_BRICK_WALL.get(), (ItemLike)ExplorationBlocks.BASALT_BRICK_BLOCK.get());
        this.wallRecipe((ItemLike)ExplorationBlocks.RUBY_BLOCK_WALL.get(), ExplorationTags.RUBY_STORAGE_BLOCK_ITEM_TAG);
        this.wallRecipe((ItemLike)ExplorationBlocks.SAPPHIRE_BLOCK_WALL.get(), ExplorationTags.SAPPHIRE_STORAGE_BLOCK_ITEM_TAG);
        this.wallRecipe((ItemLike)ExplorationBlocks.PERIDOT_BLOCK_WALL.get(), ExplorationTags.PERIDOT_STORAGE_BLOCK_ITEM_TAG);
        this.wallRecipe((ItemLike)ExplorationBlocks.ELECTROTINE_BLOCK_WALL.get(), ExplorationTags.ELECTROTINE_STORAGE_BLOCK_ITEM_TAG);
        this.shapedRecipe((ItemLike)ExplorationItems.WOOL_GIN.get()).key('S', Tags.Items.RODS_WOODEN).key('I', (ItemLike)CoreItems.IRON_COIL_ITEM.get()).patternLine("SIS").patternLine("SSS").patternLine(" S ");
        this.shapedRecipe((ItemLike)Items.STRING, 4, ResourceLocation.fromNamespaceAndPath((String)"projectred_exploration", (String)"string_from_wool_gin")).key('W', ItemTags.WOOL).key('G', (ItemLike)ExplorationItems.WOOL_GIN.get()).patternLine("GW");
        this.shapedRecipe((ItemLike)ExplorationItems.ATHAME.get()).key('W', Tags.Items.RODS_WOODEN).key('S', CoreTags.SILVER_INGOT_TAG).patternLine("S").patternLine("W");
        this.axeRecipe(ExplorationItems.RUBY_AXE.get(), (TagKey<Item>)CoreTags.RUBY_GEM_TAG);
        this.axeRecipe(ExplorationItems.SAPPHIRE_AXE.get(), (TagKey<Item>)CoreTags.SAPPHIRE_GEM_TAG);
        this.axeRecipe(ExplorationItems.PERIDOT_AXE.get(), (TagKey<Item>)CoreTags.PERIDOT_GEM_TAG);
        this.pickaxeRecipe(ExplorationItems.RUBY_PICKAXE.get(), (TagKey<Item>)CoreTags.RUBY_GEM_TAG);
        this.pickaxeRecipe(ExplorationItems.SAPPHIRE_PICKAXE.get(), (TagKey<Item>)CoreTags.SAPPHIRE_GEM_TAG);
        this.pickaxeRecipe(ExplorationItems.PERIDOT_PICKAXE.get(), (TagKey<Item>)CoreTags.PERIDOT_GEM_TAG);
        this.shovelRecipe(ExplorationItems.RUBY_SHOVEL.get(), (TagKey<Item>)CoreTags.RUBY_GEM_TAG);
        this.shovelRecipe(ExplorationItems.SAPPHIRE_SHOVEL.get(), (TagKey<Item>)CoreTags.SAPPHIRE_GEM_TAG);
        this.shovelRecipe(ExplorationItems.PERIDOT_SHOVEL.get(), (TagKey<Item>)CoreTags.PERIDOT_GEM_TAG);
        this.hoeRecipe(ExplorationItems.RUBY_HOE.get(), (TagKey<Item>)CoreTags.RUBY_GEM_TAG);
        this.hoeRecipe(ExplorationItems.SAPPHIRE_HOE.get(), (TagKey<Item>)CoreTags.SAPPHIRE_GEM_TAG);
        this.hoeRecipe(ExplorationItems.PERIDOT_HOE.get(), (TagKey<Item>)CoreTags.PERIDOT_GEM_TAG);
        this.swordRecipe(ExplorationItems.RUBY_SWORD.get(), (TagKey<Item>)CoreTags.RUBY_GEM_TAG);
        this.swordRecipe(ExplorationItems.SAPPHIRE_SWORD.get(), (TagKey<Item>)CoreTags.SAPPHIRE_GEM_TAG);
        this.swordRecipe(ExplorationItems.PERIDOT_SWORD.get(), (TagKey<Item>)CoreTags.PERIDOT_GEM_TAG);
        this.sawRecipe(ExplorationItems.GOLD_SAW.get(), (TagKey<Item>)Tags.Items.INGOTS_GOLD);
        this.sawRecipe(ExplorationItems.RUBY_SAW.get(), (TagKey<Item>)CoreTags.RUBY_GEM_TAG);
        this.sawRecipe(ExplorationItems.SAPPHIRE_SAW.get(), (TagKey<Item>)CoreTags.SAPPHIRE_GEM_TAG);
        this.sawRecipe(ExplorationItems.PERIDOT_SAW.get(), (TagKey<Item>)CoreTags.PERIDOT_GEM_TAG);
        this.sickleRecipe(ExplorationItems.WOOD_SICKLE.get(), (TagKey<Item>)Tags.Items.RODS_WOODEN);
        this.sickleRecipe(ExplorationItems.STONE_SICKLE.get(), (TagKey<Item>)Tags.Items.COBBLESTONES);
        this.sickleRecipe(ExplorationItems.IRON_SICKLE.get(), (TagKey<Item>)Tags.Items.INGOTS_IRON);
        this.sickleRecipe(ExplorationItems.GOLD_SICKLE.get(), (TagKey<Item>)Tags.Items.INGOTS_GOLD);
        this.sickleRecipe(ExplorationItems.DIAMOND_SICKLE.get(), (TagKey<Item>)Tags.Items.GEMS_DIAMOND);
        this.sickleRecipe(ExplorationItems.RUBY_SICKLE.get(), (TagKey<Item>)CoreTags.RUBY_GEM_TAG);
        this.sickleRecipe(ExplorationItems.SAPPHIRE_SICKLE.get(), (TagKey<Item>)CoreTags.SAPPHIRE_GEM_TAG);
        this.sickleRecipe(ExplorationItems.PERIDOT_SICKLE.get(), (TagKey<Item>)CoreTags.PERIDOT_GEM_TAG);
        this.helmetRecipe(ExplorationItems.RUBY_HELMET.get(), (TagKey<Item>)CoreTags.RUBY_GEM_TAG);
        this.helmetRecipe(ExplorationItems.SAPPHIRE_HELMET.get(), (TagKey<Item>)CoreTags.SAPPHIRE_GEM_TAG);
        this.helmetRecipe(ExplorationItems.PERIDOT_HELMET.get(), (TagKey<Item>)CoreTags.PERIDOT_GEM_TAG);
        this.chestplateRecipe(ExplorationItems.RUBY_CHESTPLATE.get(), (TagKey<Item>)CoreTags.RUBY_GEM_TAG);
        this.chestplateRecipe(ExplorationItems.SAPPHIRE_CHESTPLATE.get(), (TagKey<Item>)CoreTags.SAPPHIRE_GEM_TAG);
        this.chestplateRecipe(ExplorationItems.PERIDOT_CHESTPLATE.get(), (TagKey<Item>)CoreTags.PERIDOT_GEM_TAG);
        this.leggingsRecipe(ExplorationItems.RUBY_LEGGINGS.get(), (TagKey<Item>)CoreTags.RUBY_GEM_TAG);
        this.leggingsRecipe(ExplorationItems.SAPPHIRE_LEGGINGS.get(), (TagKey<Item>)CoreTags.SAPPHIRE_GEM_TAG);
        this.leggingsRecipe(ExplorationItems.PERIDOT_LEGGINGS.get(), (TagKey<Item>)CoreTags.PERIDOT_GEM_TAG);
        this.bootsRecipe(ExplorationItems.RUBY_BOOTS.get(), (TagKey<Item>)CoreTags.RUBY_GEM_TAG);
        this.bootsRecipe(ExplorationItems.SAPPHIRE_BOOTS.get(), (TagKey<Item>)CoreTags.SAPPHIRE_GEM_TAG);
        this.bootsRecipe(ExplorationItems.PERIDOT_BOOTS.get(), (TagKey<Item>)CoreTags.PERIDOT_GEM_TAG);
        for (int i = 0; i < 16; ++i) {
            this.backpackRecipe(ExplorationItems.getBackpackByColor(i));
        }
        this.special(ResourceLocation.fromNamespaceAndPath((String)"projectred_exploration", (String)"backpack_dye"), () -> new BackpackDyeRecipe(CraftingBookCategory.MISC));
    }

    private void oreSmeltingRecipe(ItemLike result, Collection<ItemLike> sources, float xp) {
        String resultName = BuiltInRegistries.ITEM.getKey((Object)result.asItem()).getPath();
        for (ItemLike source : sources) {
            String sourceName = BuiltInRegistries.ITEM.getKey((Object)source.asItem()).getPath();
            this.smelting(result, 1, ResourceLocation.fromNamespaceAndPath((String)"projectred_exploration", (String)(resultName + "_from_" + sourceName + "_smelting"))).ingredient(source).experience(xp);
        }
    }

    private void nineBlockStorageRecipes(TagKey<Item> itemTag, ItemLike block, ItemLike item) {
        this.shapedRecipe(block).key('S', itemTag).patternLine("SSS").patternLine("SSS").patternLine("SSS");
        this.shapelessRecipe(item, 9, ResourceLocation.fromNamespaceAndPath((String)"projectred_exploration", (String)(BuiltInRegistries.ITEM.getKey((Object)item.asItem()).getPath() + "_from_nineblock"))).addIngredient(block);
    }

    private void wallRecipe(ItemLike result, ItemLike input) {
        this.shapedRecipe(result, 6).key('S', input).patternLine("SSS").patternLine("SSS");
    }

    private void wallRecipe(ItemLike result, TagKey<Item> input) {
        this.shapedRecipe(result, 6).key('S', input).patternLine("SSS").patternLine("SSS");
    }

    private void axeRecipe(Item axe, TagKey<Item> material) {
        this.shapedRecipe((ItemLike)axe).key('M', material).key('S', Tags.Items.RODS_WOODEN).patternLine("MM").patternLine("MS").patternLine(" S");
    }

    private void pickaxeRecipe(Item pickaxe, TagKey<Item> material) {
        this.shapedRecipe((ItemLike)pickaxe).key('M', material).key('S', Tags.Items.RODS_WOODEN).patternLine("MMM").patternLine(" S ").patternLine(" S ");
    }

    private void shovelRecipe(Item shovel, TagKey<Item> material) {
        this.shapedRecipe((ItemLike)shovel).key('M', material).key('S', Tags.Items.RODS_WOODEN).patternLine("M").patternLine("S").patternLine("S");
    }

    private void hoeRecipe(Item hoe, TagKey<Item> material) {
        this.shapedRecipe((ItemLike)hoe).key('M', material).key('S', Tags.Items.RODS_WOODEN).patternLine("MM").patternLine(" S").patternLine(" S");
    }

    private void swordRecipe(Item sword, TagKey<Item> material) {
        this.shapedRecipe((ItemLike)sword).key('M', material).key('S', Tags.Items.RODS_WOODEN).patternLine("M").patternLine("M").patternLine("S");
    }

    private void sawRecipe(Item saw, TagKey<Item> material) {
        this.shapedRecipe((ItemLike)saw).key('M', material).key('S', Tags.Items.RODS_WOODEN).key('R', (ItemLike)CBMicroblockModContent.STONE_ROD_ITEM.get()).patternLine("SRR").patternLine("SMM");
    }

    private void sickleRecipe(Item sickle, TagKey<Item> material) {
        this.shapedRecipe((ItemLike)sickle).key('M', material).key('S', Tags.Items.RODS_WOODEN).patternLine(" M ").patternLine("  M").patternLine("SM ");
    }

    private void helmetRecipe(Item helmet, TagKey<Item> material) {
        this.shapedRecipe((ItemLike)helmet).key('M', material).patternLine("MMM").patternLine("M M");
    }

    private void chestplateRecipe(Item chestplate, TagKey<Item> material) {
        this.shapedRecipe((ItemLike)chestplate).key('M', material).patternLine("M M").patternLine("MMM").patternLine("MMM");
    }

    private void leggingsRecipe(Item leggings, TagKey<Item> material) {
        this.shapedRecipe((ItemLike)leggings).key('M', material).patternLine("MMM").patternLine("M M").patternLine("M M");
    }

    private void bootsRecipe(Item boots, TagKey<Item> material) {
        this.shapedRecipe((ItemLike)boots).key('M', material).patternLine("M M").patternLine("M M");
    }

    private void backpackRecipe(Item backpack) {
        DyeColor color = ((BackpackItem)backpack).getDyeColor();
        ShapedRecipeBuilder builder = this.shapedRecipe((ItemLike)backpack).key('C', (ItemLike)CoreItems.WOVEN_CLOTH_ITEM.get());
        if (color == DyeColor.WHITE) {
            builder.patternLine("CCC").patternLine("C C").patternLine("CCC");
        } else {
            builder.key('D', color.getTag()).patternLine("CCC").patternLine("CDC").patternLine("CCC");
        }
    }
}

