/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.exploration.init;

import codechicken.microblock.api.BlockMicroMaterial;
import codechicken.microblock.api.MicroMaterial;
import codechicken.microblock.util.MicroMaterialRegistry;
import java.util.function.Supplier;
import mrtjp.projectred.exploration.ProjectRedExploration;
import mrtjp.projectred.exploration.block.ElectrotineOreBlock;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.neoforge.registries.RegisterEvent;

public class ExplorationBlocks {
    public static final String ID_RUBY_ORE = "ruby_ore";
    public static final String ID_DEEPSLATE_RUBY_ORE = "deepslate_ruby_ore";
    public static final String ID_SAPPHIRE_ORE = "sapphire_ore";
    public static final String ID_DEEPSLATE_SAPPHIRE_ORE = "deepslate_sapphire_ore";
    public static final String ID_PERIDOT_ORE = "peridot_ore";
    public static final String ID_DEEPSLATE_PERIDOT_ORE = "deepslate_peridot_ore";
    public static final String ID_TIN_ORE = "tin_ore";
    public static final String ID_DEEPSLATE_TIN_ORE = "deepslate_tin_ore";
    public static final String ID_SILVER_ORE = "silver_ore";
    public static final String ID_DEEPSLATE_ELECTROTINE_ORE = "deepslate_electrotine_ore";
    public static final String ID_ELECTROTINE_ORE = "electrotine_ore";
    public static final String ID_DEEPSLATE_SILVER_ORE = "deepslate_silver_ore";
    public static final String ID_MARBLE = "marble";
    public static final String ID_MARBLE_BRICK = "marble_brick";
    public static final String ID_BASALT = "basalt";
    public static final String ID_BASALT_COBBLE = "basalt_cobble";
    public static final String ID_BASALT_BRICK = "basalt_brick";
    public static final String ID_RUBY_BLOCK = "ruby_block";
    public static final String ID_SAPPHIRE_BLOCK = "sapphire_block";
    public static final String ID_PERIDOT_BLOCK = "peridot_block";
    public static final String ID_RAW_TIN_BLOCK = "raw_tin_block";
    public static final String ID_RAW_SILVER_BLOCK = "raw_silver_block";
    public static final String ID_TIN_BLOCK = "tin_block";
    public static final String ID_SILVER_BLOCK = "silver_block";
    public static final String ID_ELECTROTINE_BLOCK = "electrotine_block";
    public static final String ID_MARBLE_WALL = "marble_wall";
    public static final String ID_MARBLE_BRICK_WALL = "marble_brick_wall";
    public static final String ID_BASALT_WALL = "basalt_wall";
    public static final String ID_BASALT_COBBLE_WALL = "basalt_cobble_wall";
    public static final String ID_BASALT_BRICK_WALL = "basalt_brick_wall";
    public static final String ID_RUBY_BLOCK_WALL = "ruby_block_wall";
    public static final String ID_SAPPHIRE_BLOCK_WALL = "sapphire_block_wall";
    public static final String ID_PERIDOT_BLOCK_WALL = "peridot_block_wall";
    public static final String ID_ELECTROTINE_BLOCK_WALL = "electrotine_block_wall";
    public static Supplier<Block> RUBY_ORE_BLOCK;
    public static Supplier<Block> DEEPSLATE_RUBY_ORE_BLOCK;
    public static Supplier<Block> SAPPHIRE_ORE_BLOCK;
    public static Supplier<Block> DEEPSLATE_SAPPHIRE_ORE_BLOCK;
    public static Supplier<Block> PERIDOT_ORE_BLOCK;
    public static Supplier<Block> DEEPSLATE_PERIDOT_ORE_BLOCK;
    public static Supplier<Block> TIN_ORE_BLOCK;
    public static Supplier<Block> DEEPSLATE_TIN_ORE_BLOCK;
    public static Supplier<Block> SILVER_ORE_BLOCK;
    public static Supplier<Block> DEEPSLATE_SILVER_ORE_BLOCK;
    public static Supplier<Block> ELECTROTINE_ORE_BLOCK;
    public static Supplier<Block> DEEPSLATE_ELECTROTINE_ORE_BLOCK;
    public static Supplier<Block> MARBLE_BLOCK;
    public static Supplier<Block> MARBLE_BRICK_BLOCK;
    public static Supplier<Block> BASALT_BLOCK;
    public static Supplier<Block> BASALT_COBBLE_BLOCK;
    public static Supplier<Block> BASALT_BRICK_BLOCK;
    public static Supplier<Block> RUBY_BLOCK;
    public static Supplier<Block> SAPPHIRE_BLOCK;
    public static Supplier<Block> PERIDOT_BLOCK;
    public static Supplier<Block> ELECTROTINE_BLOCK;
    public static Supplier<Block> RAW_TIN_BLOCK;
    public static Supplier<Block> RAW_SILVER_BLOCK;
    public static Supplier<Block> TIN_BLOCK;
    public static Supplier<Block> SILVER_BLOCK;
    public static Supplier<WallBlock> MARBLE_WALL;
    public static Supplier<WallBlock> MARBLE_BRICK_WALL;
    public static Supplier<WallBlock> BASALT_WALL;
    public static Supplier<WallBlock> BASALT_COBBLE_WALL;
    public static Supplier<WallBlock> BASALT_BRICK_WALL;
    public static Supplier<WallBlock> RUBY_BLOCK_WALL;
    public static Supplier<WallBlock> SAPPHIRE_BLOCK_WALL;
    public static Supplier<WallBlock> PERIDOT_BLOCK_WALL;
    public static Supplier<WallBlock> ELECTROTINE_BLOCK_WALL;

    public static void register() {
        RUBY_ORE_BLOCK = ProjectRedExploration.BLOCKS.register(ID_RUBY_ORE, () -> ExplorationBlocks.createOreBlock(false, 2, 7));
        DEEPSLATE_RUBY_ORE_BLOCK = ProjectRedExploration.BLOCKS.register(ID_DEEPSLATE_RUBY_ORE, () -> ExplorationBlocks.createOreBlock(true, 2, 7));
        SAPPHIRE_ORE_BLOCK = ProjectRedExploration.BLOCKS.register(ID_SAPPHIRE_ORE, () -> ExplorationBlocks.createOreBlock(false, 2, 7));
        DEEPSLATE_SAPPHIRE_ORE_BLOCK = ProjectRedExploration.BLOCKS.register(ID_DEEPSLATE_SAPPHIRE_ORE, () -> ExplorationBlocks.createOreBlock(true, 2, 7));
        PERIDOT_ORE_BLOCK = ProjectRedExploration.BLOCKS.register(ID_PERIDOT_ORE, () -> ExplorationBlocks.createOreBlock(false, 2, 7));
        DEEPSLATE_PERIDOT_ORE_BLOCK = ProjectRedExploration.BLOCKS.register(ID_DEEPSLATE_PERIDOT_ORE, () -> ExplorationBlocks.createOreBlock(true, 2, 7));
        TIN_ORE_BLOCK = ProjectRedExploration.BLOCKS.register(ID_TIN_ORE, () -> ExplorationBlocks.createOreBlock(false, 0, 0));
        DEEPSLATE_TIN_ORE_BLOCK = ProjectRedExploration.BLOCKS.register(ID_DEEPSLATE_TIN_ORE, () -> ExplorationBlocks.createOreBlock(true, 0, 0));
        SILVER_ORE_BLOCK = ProjectRedExploration.BLOCKS.register(ID_SILVER_ORE, () -> ExplorationBlocks.createOreBlock(false, 0, 0));
        DEEPSLATE_SILVER_ORE_BLOCK = ProjectRedExploration.BLOCKS.register(ID_DEEPSLATE_SILVER_ORE, () -> ExplorationBlocks.createOreBlock(true, 0, 0));
        ELECTROTINE_ORE_BLOCK = ProjectRedExploration.BLOCKS.register(ID_ELECTROTINE_ORE, () -> ExplorationBlocks.createElectrotineOreBlock(false, 1, 5));
        DEEPSLATE_ELECTROTINE_ORE_BLOCK = ProjectRedExploration.BLOCKS.register(ID_DEEPSLATE_ELECTROTINE_ORE, () -> ExplorationBlocks.createElectrotineOreBlock(true, 1, 5));
        MARBLE_BLOCK = ProjectRedExploration.BLOCKS.register(ID_MARBLE, () -> ExplorationBlocks.createDecorativeStoneBlock(1.0f, 14.0f));
        MARBLE_BRICK_BLOCK = ProjectRedExploration.BLOCKS.register(ID_MARBLE_BRICK, () -> ExplorationBlocks.createDecorativeStoneBlock(1.0f, 14.0f));
        BASALT_BLOCK = ProjectRedExploration.BLOCKS.register(ID_BASALT, () -> ExplorationBlocks.createDecorativeStoneBlock(2.5f, 16.0f));
        BASALT_COBBLE_BLOCK = ProjectRedExploration.BLOCKS.register(ID_BASALT_COBBLE, () -> ExplorationBlocks.createDecorativeStoneBlock(2.5f, 14.0f));
        BASALT_BRICK_BLOCK = ProjectRedExploration.BLOCKS.register(ID_BASALT_BRICK, () -> ExplorationBlocks.createDecorativeStoneBlock(2.5f, 20.0f));
        RUBY_BLOCK = ProjectRedExploration.BLOCKS.register(ID_RUBY_BLOCK, () -> ExplorationBlocks.createDecorativeGemBlock(5.0f, 10.0f));
        SAPPHIRE_BLOCK = ProjectRedExploration.BLOCKS.register(ID_SAPPHIRE_BLOCK, () -> ExplorationBlocks.createDecorativeGemBlock(5.0f, 10.0f));
        PERIDOT_BLOCK = ProjectRedExploration.BLOCKS.register(ID_PERIDOT_BLOCK, () -> ExplorationBlocks.createDecorativeGemBlock(5.0f, 10.0f));
        ELECTROTINE_BLOCK = ProjectRedExploration.BLOCKS.register(ID_ELECTROTINE_BLOCK, () -> ExplorationBlocks.createDecorativeMetalBlock(5.0f, 10.0f));
        RAW_TIN_BLOCK = ProjectRedExploration.BLOCKS.register(ID_RAW_TIN_BLOCK, () -> ExplorationBlocks.createDecorativeMetalBlock(2.0f, 6.0f));
        RAW_SILVER_BLOCK = ProjectRedExploration.BLOCKS.register(ID_RAW_SILVER_BLOCK, () -> ExplorationBlocks.createDecorativeMetalBlock(2.0f, 6.0f));
        TIN_BLOCK = ProjectRedExploration.BLOCKS.register(ID_TIN_BLOCK, () -> ExplorationBlocks.createDecorativeMetalBlock(3.0f, 6.0f));
        SILVER_BLOCK = ProjectRedExploration.BLOCKS.register(ID_SILVER_BLOCK, () -> ExplorationBlocks.createDecorativeMetalBlock(3.0f, 6.0f));
        MARBLE_WALL = ProjectRedExploration.BLOCKS.register(ID_MARBLE_WALL, () -> ExplorationBlocks.createWallBlock(MARBLE_BLOCK));
        MARBLE_BRICK_WALL = ProjectRedExploration.BLOCKS.register(ID_MARBLE_BRICK_WALL, () -> ExplorationBlocks.createWallBlock(MARBLE_BRICK_BLOCK));
        BASALT_WALL = ProjectRedExploration.BLOCKS.register(ID_BASALT_WALL, () -> ExplorationBlocks.createWallBlock(BASALT_BLOCK));
        BASALT_COBBLE_WALL = ProjectRedExploration.BLOCKS.register(ID_BASALT_COBBLE_WALL, () -> ExplorationBlocks.createWallBlock(BASALT_COBBLE_BLOCK));
        BASALT_BRICK_WALL = ProjectRedExploration.BLOCKS.register(ID_BASALT_BRICK_WALL, () -> ExplorationBlocks.createWallBlock(BASALT_BRICK_BLOCK));
        RUBY_BLOCK_WALL = ProjectRedExploration.BLOCKS.register(ID_RUBY_BLOCK_WALL, () -> ExplorationBlocks.createWallBlock(RUBY_BLOCK));
        SAPPHIRE_BLOCK_WALL = ProjectRedExploration.BLOCKS.register(ID_SAPPHIRE_BLOCK_WALL, () -> ExplorationBlocks.createWallBlock(SAPPHIRE_BLOCK));
        PERIDOT_BLOCK_WALL = ProjectRedExploration.BLOCKS.register(ID_PERIDOT_BLOCK_WALL, () -> ExplorationBlocks.createWallBlock(PERIDOT_BLOCK));
        ELECTROTINE_BLOCK_WALL = ProjectRedExploration.BLOCKS.register(ID_ELECTROTINE_BLOCK_WALL, () -> ExplorationBlocks.createWallBlock(ELECTROTINE_BLOCK));
        ProjectRedExploration.ITEMS.register(ID_RUBY_ORE, () -> ExplorationBlocks.createBlockItem(RUBY_ORE_BLOCK));
        ProjectRedExploration.ITEMS.register(ID_DEEPSLATE_RUBY_ORE, () -> ExplorationBlocks.createBlockItem(DEEPSLATE_RUBY_ORE_BLOCK));
        ProjectRedExploration.ITEMS.register(ID_SAPPHIRE_ORE, () -> ExplorationBlocks.createBlockItem(SAPPHIRE_ORE_BLOCK));
        ProjectRedExploration.ITEMS.register(ID_DEEPSLATE_SAPPHIRE_ORE, () -> ExplorationBlocks.createBlockItem(DEEPSLATE_SAPPHIRE_ORE_BLOCK));
        ProjectRedExploration.ITEMS.register(ID_PERIDOT_ORE, () -> ExplorationBlocks.createBlockItem(PERIDOT_ORE_BLOCK));
        ProjectRedExploration.ITEMS.register(ID_DEEPSLATE_PERIDOT_ORE, () -> ExplorationBlocks.createBlockItem(DEEPSLATE_PERIDOT_ORE_BLOCK));
        ProjectRedExploration.ITEMS.register(ID_TIN_ORE, () -> ExplorationBlocks.createBlockItem(TIN_ORE_BLOCK));
        ProjectRedExploration.ITEMS.register(ID_DEEPSLATE_TIN_ORE, () -> ExplorationBlocks.createBlockItem(DEEPSLATE_TIN_ORE_BLOCK));
        ProjectRedExploration.ITEMS.register(ID_SILVER_ORE, () -> ExplorationBlocks.createBlockItem(SILVER_ORE_BLOCK));
        ProjectRedExploration.ITEMS.register(ID_DEEPSLATE_SILVER_ORE, () -> ExplorationBlocks.createBlockItem(DEEPSLATE_SILVER_ORE_BLOCK));
        ProjectRedExploration.ITEMS.register(ID_ELECTROTINE_ORE, () -> ExplorationBlocks.createBlockItem(ELECTROTINE_ORE_BLOCK));
        ProjectRedExploration.ITEMS.register(ID_DEEPSLATE_ELECTROTINE_ORE, () -> ExplorationBlocks.createBlockItem(DEEPSLATE_ELECTROTINE_ORE_BLOCK));
        ProjectRedExploration.ITEMS.register(ID_MARBLE, () -> ExplorationBlocks.createBlockItem(MARBLE_BLOCK));
        ProjectRedExploration.ITEMS.register(ID_MARBLE_BRICK, () -> ExplorationBlocks.createBlockItem(MARBLE_BRICK_BLOCK));
        ProjectRedExploration.ITEMS.register(ID_BASALT, () -> ExplorationBlocks.createBlockItem(BASALT_BLOCK));
        ProjectRedExploration.ITEMS.register(ID_BASALT_COBBLE, () -> ExplorationBlocks.createBlockItem(BASALT_COBBLE_BLOCK));
        ProjectRedExploration.ITEMS.register(ID_BASALT_BRICK, () -> ExplorationBlocks.createBlockItem(BASALT_BRICK_BLOCK));
        ProjectRedExploration.ITEMS.register(ID_RUBY_BLOCK, () -> ExplorationBlocks.createBlockItem(RUBY_BLOCK));
        ProjectRedExploration.ITEMS.register(ID_SAPPHIRE_BLOCK, () -> ExplorationBlocks.createBlockItem(SAPPHIRE_BLOCK));
        ProjectRedExploration.ITEMS.register(ID_PERIDOT_BLOCK, () -> ExplorationBlocks.createBlockItem(PERIDOT_BLOCK));
        ProjectRedExploration.ITEMS.register(ID_ELECTROTINE_BLOCK, () -> ExplorationBlocks.createBlockItem(ELECTROTINE_BLOCK));
        ProjectRedExploration.ITEMS.register(ID_RAW_TIN_BLOCK, () -> ExplorationBlocks.createBlockItem(RAW_TIN_BLOCK));
        ProjectRedExploration.ITEMS.register(ID_RAW_SILVER_BLOCK, () -> ExplorationBlocks.createBlockItem(RAW_SILVER_BLOCK));
        ProjectRedExploration.ITEMS.register(ID_TIN_BLOCK, () -> ExplorationBlocks.createBlockItem(TIN_BLOCK));
        ProjectRedExploration.ITEMS.register(ID_SILVER_BLOCK, () -> ExplorationBlocks.createBlockItem(SILVER_BLOCK));
        ProjectRedExploration.ITEMS.register(ID_MARBLE_WALL, () -> ExplorationBlocks.createBlockItem(MARBLE_WALL));
        ProjectRedExploration.ITEMS.register(ID_MARBLE_BRICK_WALL, () -> ExplorationBlocks.createBlockItem(MARBLE_BRICK_WALL));
        ProjectRedExploration.ITEMS.register(ID_BASALT_WALL, () -> ExplorationBlocks.createBlockItem(BASALT_WALL));
        ProjectRedExploration.ITEMS.register(ID_BASALT_COBBLE_WALL, () -> ExplorationBlocks.createBlockItem(BASALT_COBBLE_WALL));
        ProjectRedExploration.ITEMS.register(ID_BASALT_BRICK_WALL, () -> ExplorationBlocks.createBlockItem(BASALT_BRICK_WALL));
        ProjectRedExploration.ITEMS.register(ID_RUBY_BLOCK_WALL, () -> ExplorationBlocks.createBlockItem(RUBY_BLOCK_WALL));
        ProjectRedExploration.ITEMS.register(ID_SAPPHIRE_BLOCK_WALL, () -> ExplorationBlocks.createBlockItem(SAPPHIRE_BLOCK_WALL));
        ProjectRedExploration.ITEMS.register(ID_PERIDOT_BLOCK_WALL, () -> ExplorationBlocks.createBlockItem(PERIDOT_BLOCK_WALL));
        ProjectRedExploration.ITEMS.register(ID_ELECTROTINE_BLOCK_WALL, () -> ExplorationBlocks.createBlockItem(ELECTROTINE_BLOCK_WALL));
    }

    public static void onRegisterMicroMaterials(RegisterEvent event) {
        event.register(MicroMaterialRegistry.microMaterials().key(), r -> {
            ExplorationBlocks.registerBlockMicro((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(MARBLE_BLOCK.get()));
            ExplorationBlocks.registerBlockMicro((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(MARBLE_BRICK_BLOCK.get()));
            ExplorationBlocks.registerBlockMicro((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(BASALT_BLOCK.get()));
            ExplorationBlocks.registerBlockMicro((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(BASALT_COBBLE_BLOCK.get()));
            ExplorationBlocks.registerBlockMicro((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(BASALT_BRICK_BLOCK.get()));
            ExplorationBlocks.registerBlockMicro((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(RUBY_BLOCK.get()));
            ExplorationBlocks.registerBlockMicro((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(SAPPHIRE_BLOCK.get()));
            ExplorationBlocks.registerBlockMicro((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(PERIDOT_BLOCK.get()));
            ExplorationBlocks.registerBlockMicro((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(ELECTROTINE_BLOCK.get()));
        });
    }

    private static void registerBlockMicro(RegisterEvent.RegisterHelper<MicroMaterial> r, BlockMicroMaterial material) {
        r.register(BlockMicroMaterial.makeMaterialKey((BlockState)material.state), (Object)material);
    }

    private static Block createOreBlock(boolean isDeepslate, int minxp, int maxxp) {
        return new DropExperienceBlock((IntProvider)UniformInt.of((int)minxp, (int)maxxp), BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASEDRUM).strength(isDeepslate ? 4.5f : 3.0f, 3.0f).requiresCorrectToolForDrops().mapColor(isDeepslate ? MapColor.DEEPSLATE : MapColor.STONE).sound(isDeepslate ? SoundType.DEEPSLATE : SoundType.STONE));
    }

    private static Block createElectrotineOreBlock(boolean isDeepslate, int minxp, int maxxp) {
        return new ElectrotineOreBlock((IntProvider)UniformInt.of((int)minxp, (int)maxxp), BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASEDRUM).strength(isDeepslate ? 4.5f : 3.0f, 3.0f).requiresCorrectToolForDrops().mapColor(isDeepslate ? MapColor.DEEPSLATE : MapColor.STONE).sound(isDeepslate ? SoundType.DEEPSLATE : SoundType.STONE));
    }

    private static WallBlock createWallBlock(Supplier<Block> block) {
        return new WallBlock(BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)((BlockBehaviour)block.get())).forceSolidOn());
    }

    private static Block createDecorativeStoneBlock(float hardness, float resistance) {
        return new Block(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).strength(hardness, resistance).requiresCorrectToolForDrops().sound(SoundType.STONE));
    }

    private static Block createDecorativeGemBlock(float hardness, float resistance) {
        return new Block(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(hardness, resistance).requiresCorrectToolForDrops().sound(SoundType.METAL));
    }

    private static Block createDecorativeMetalBlock(float hardness, float resistance) {
        return new Block(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(hardness, resistance).requiresCorrectToolForDrops().sound(SoundType.METAL));
    }

    private static Item createBlockItem(Supplier<? extends Block> block) {
        return new BlockItem(block.get(), new Item.Properties());
    }

    private static Item createBlockItem(Block block) {
        return new BlockItem(block, new Item.Properties());
    }
}

