/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.exploration.world.gen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import mrtjp.projectred.core.Configurator;
import mrtjp.projectred.exploration.init.ExplorationWorldFeatures;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.neoforged.neoforge.common.world.BiomeGenerationSettingsBuilder;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.ModifiableBiomeInfo;

public record ConfigFileControlledAddFeaturesBiomeModifier(HolderSet<Biome> biomes, HolderSet<PlacedFeature> features, GenerationStep.Decoration step, String configKey) implements BiomeModifier
{
    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (this.isEnabled() && phase == BiomeModifier.Phase.ADD && this.biomes.contains(biome)) {
            BiomeGenerationSettingsBuilder generationSettings = builder.getGenerationSettings();
            this.features.forEach(holder -> generationSettings.addFeature(this.step, holder));
        }
    }

    public MapCodec<? extends BiomeModifier> codec() {
        return ExplorationWorldFeatures.ADD_FEATURES_BIOME_MODIFIER_CODEC.get();
    }

    private boolean isEnabled() {
        return Configurator.SERVER.isWorldFeatureEnabled(this.configKey);
    }

    public static MapCodec<ConfigFileControlledAddFeaturesBiomeModifier> createCodec() {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)Biome.LIST_CODEC.fieldOf("biomes").forGetter(m -> m.biomes), (App)PlacedFeature.LIST_CODEC.fieldOf("features").forGetter(m -> m.features), (App)GenerationStep.Decoration.CODEC.fieldOf("step").forGetter(m -> m.step), (App)Codec.STRING.fieldOf("configKey").forGetter(m -> m.configKey)).apply((Applicative)instance, ConfigFileControlledAddFeaturesBiomeModifier::new));
    }
}

