/*
 * Decompiled with CFR 0.152.
 */
package dev.chasem.cobblemonextras.commands;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.interaction.RequestManager;
import com.cobblemon.mod.common.api.interaction.ServerPlayerActionRequest;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.battles.BattleFormat;
import com.cobblemon.mod.common.battles.BattleRegistry;
import com.cobblemon.mod.common.battles.ChallengeManager;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.chasem.cobblemonextras.CobblemonExtras;
import dev.chasem.cobblemonextras.permissions.CobblemonExtrasPermissions;
import dev.chasem.cobblemonextras.services.PVPChallengeService;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\r\u001a\u00020\f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\nH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001d\u0010\u000f\u001a\u00020\f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\nH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u000e\u00a8\u0006\u0010"}, d2={"Ldev/chasem/cobblemonextras/commands/Battle;", "", "<init>", "()V", "Lcom/mojang/brigadier/CommandDispatcher;", "Lnet/minecraft/class_2168;", "dispatcher", "", "register", "(Lcom/mojang/brigadier/CommandDispatcher;)V", "Lcom/mojang/brigadier/context/CommandContext;", "ctx", "", "deny", "(Lcom/mojang/brigadier/context/CommandContext;)I", "execute", "common"})
@SourceDebugExtension(value={"SMAP\nBattle.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Battle.kt\ndev/chasem/cobblemonextras/commands/Battle\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,98:1\n295#2,2:99\n*S KotlinDebug\n*F\n+ 1 Battle.kt\ndev/chasem/cobblemonextras/commands/Battle\n*L\n66#1:99,2\n*E\n"})
public final class Battle {
    public final void register(@NotNull CommandDispatcher<class_2168> dispatcher) {
        Intrinsics.checkNotNullParameter(dispatcher, "dispatcher");
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"battle").requires(Battle::register$lambda$0)).then(class_2170.method_9244((String)"player", (ArgumentType)((ArgumentType)class_2186.method_9305())).executes(arg_0 -> Battle.register$lambda$1(this, arg_0)))).then(class_2170.method_9247((String)"deny").then(class_2170.method_9244((String)"player", (ArgumentType)((ArgumentType)class_2186.method_9305())).executes(arg_0 -> Battle.register$lambda$2(this, arg_0)))));
    }

    private final int deny(CommandContext<class_2168> ctx) {
        class_3222 class_32222 = ((class_2168)ctx.getSource()).method_9207();
        Intrinsics.checkNotNullExpressionValue(class_32222, "getPlayerOrException(...)");
        class_3222 player = class_32222;
        class_3222 class_32223 = class_2186.method_9315(ctx, (String)"player");
        Intrinsics.checkNotNullExpressionValue(class_32223, "getPlayer(...)");
        class_3222 battlePartner = class_32223;
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUUID(...)");
        UUID uUID2 = battlePartner.method_5667();
        Intrinsics.checkNotNullExpressionValue(uUID2, "getUUID(...)");
        ChallengeManager.BattleChallenge request = (ChallengeManager.BattleChallenge)PVPChallengeService.INSTANCE.getInboundRequestBySender(uUID, uUID2);
        if (request != null) {
            PVPChallengeService.INSTANCE.declineRequest(player, request.getRequestID());
        }
        return 1;
    }

    private final int execute(CommandContext<class_2168> ctx) {
        Object v2;
        class_3222 battlePartner;
        class_3222 player;
        block6: {
            class_3222 class_32222 = ((class_2168)ctx.getSource()).method_9207();
            Intrinsics.checkNotNullExpressionValue(class_32222, "getPlayerOrException(...)");
            player = class_32222;
            class_3222 class_32223 = class_2186.method_9315(ctx, (String)"player");
            Intrinsics.checkNotNullExpressionValue(class_32223, "getPlayer(...)");
            battlePartner = class_32223;
            if (battlePartner.method_5667().equals(player.method_5667())) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Life's tough enough, don't battle yourself."));
                return 1;
            }
            if (BattleRegistry.getBattleByParticipatingPlayer((class_3222)player) != null) {
                player.method_43496((class_2561)class_2561.method_43470((String)"You can't start a new battle, while in a battle.").method_27692(class_124.field_1061));
                return 1;
            }
            if (BattleRegistry.getBattleByParticipatingPlayer((class_3222)battlePartner) != null) {
                player.method_43496((class_2561)class_2561.method_43470((String)"Opponent is currently in a battle.").method_27692(class_124.field_1061));
                return 1;
            }
            PlayerPartyStore storage1 = Cobblemon.INSTANCE.getStorage().getParty(player);
            Iterable $this$firstOrNull$iv = (Iterable)storage1;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Pokemon it = (Pokemon)element$iv;
                boolean bl = false;
                if (!(!it.isFainted())) continue;
                v2 = element$iv;
                break block6;
            }
            v2 = null;
        }
        Pokemon firstAvailablePokemon = v2;
        if (firstAvailablePokemon == null) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"You don't have any available Pokemon to battle with."));
            return 1;
        }
        UUID uUID = firstAvailablePokemon.getUuid();
        Intrinsics.checkNotNullExpressionValue(uUID, "<get-uuid>(...)");
        ChallengeManager.SinglesBattleChallenge challenge = new ChallengeManager.SinglesBattleChallenge(player, battlePartner, uUID, BattleFormat.Companion.getGEN_9_SINGLES(), 0, 16, null);
        UUID uUID2 = player.method_5667();
        Intrinsics.checkNotNullExpressionValue(uUID2, "getUUID(...)");
        UUID uUID3 = battlePartner.method_5667();
        Intrinsics.checkNotNullExpressionValue(uUID3, "getUUID(...)");
        ChallengeManager.BattleChallenge request = (ChallengeManager.BattleChallenge)PVPChallengeService.INSTANCE.getInboundRequestBySender(uUID2, uUID3);
        if (request != null) {
            RequestManager.acceptRequest$default((RequestManager)PVPChallengeService.INSTANCE, (class_3222)player, (UUID)request.getRequestID(), null, (int)4, null);
            return 1;
        }
        PVPChallengeService.INSTANCE.sendRequest((ServerPlayerActionRequest)challenge);
        class_5250 accept = class_2561.method_43470((String)"[ACCEPT]").method_27696(class_2583.field_24360.method_10982(Boolean.valueOf(true)).method_10977(class_124.field_1060).method_10958(new class_2558(class_2558.class_2559.field_11750, "/battle " + player.method_5477().getString())).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)("Accept " + player.method_5477().getString() + " Challenge")))));
        class_5250 deny = class_2561.method_43470((String)"[DENY]").method_27696(class_2583.field_24360.method_10982(Boolean.valueOf(true)).method_10977(class_124.field_1061).method_10958(new class_2558(class_2558.class_2559.field_11750, "/battle deny " + player.method_5477().getString())).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)("Deny " + player.method_5477().getString() + " Challenge")))));
        battlePartner.method_43496((class_2561)accept.method_27661().method_27693(" ").method_10852((class_2561)deny));
        return 1;
    }

    private static final boolean register$lambda$0(class_2168 src) {
        return CobblemonExtrasPermissions.Companion.checkPermission(src, CobblemonExtras.INSTANCE.getPermissions().getBATTLE_PERMISSION());
    }

    private static final int register$lambda$1(Battle this$0, CommandContext ctx) {
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        return this$0.execute((CommandContext<class_2168>)ctx);
    }

    private static final int register$lambda$2(Battle this$0, CommandContext ctx) {
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        return this$0.deny((CommandContext<class_2168>)ctx);
    }
}

