/*
 * Decompiled with CFR 0.152.
 */
package dev.chasem.cobblemonextras.commands;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.storage.party.PartyStore;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.battles.BattleBuilder;
import com.cobblemon.mod.common.battles.BattleFormat;
import com.cobblemon.mod.common.battles.BattleRegistry;
import com.cobblemon.mod.common.command.argument.PokemonPropertiesArgumentType;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.chasem.cobblemonextras.CobblemonExtras;
import dev.chasem.cobblemonextras.permissions.CobblemonExtrasPermissions;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\r\u001a\u00020\f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\nH\u0002\u00a2\u0006\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Ldev/chasem/cobblemonextras/commands/PokeBattle;", "", "<init>", "()V", "Lcom/mojang/brigadier/CommandDispatcher;", "Lnet/minecraft/class_2168;", "dispatcher", "", "register", "(Lcom/mojang/brigadier/CommandDispatcher;)V", "Lcom/mojang/brigadier/context/CommandContext;", "ctx", "", "execute", "(Lcom/mojang/brigadier/context/CommandContext;)I", "common"})
public final class PokeBattle {
    public final void register(@NotNull CommandDispatcher<class_2168> dispatcher) {
        Intrinsics.checkNotNullParameter(dispatcher, "dispatcher");
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"pokebattle").requires(PokeBattle::register$lambda$0)).then(class_2170.method_9244((String)"player", (ArgumentType)((ArgumentType)class_2186.method_9305())).then(class_2170.method_9244((String)"properties", (ArgumentType)((ArgumentType)PokemonPropertiesArgumentType.Companion.properties())).executes(arg_0 -> PokeBattle.register$lambda$1(this, arg_0)))));
    }

    private final int execute(CommandContext<class_2168> ctx) {
        class_3222 battlingPlayer = null;
        try {
            class_3222 class_32222 = class_2186.method_9315(ctx, (String)"player");
            Intrinsics.checkNotNullExpressionValue(class_32222, "getPlayer(...)");
            battlingPlayer = class_32222;
        }
        catch (CommandSyntaxException e) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Error finding player."));
            return 1;
        }
        PokemonProperties pokemonProperties = PokemonPropertiesArgumentType.Companion.getPokemonProperties(ctx, "properties");
        if (pokemonProperties.getSpecies() == null) {
            ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)"No pokemon found for species provided"));
            return 1;
        }
        if (BattleRegistry.getBattleByParticipatingPlayer((class_3222)battlingPlayer) != null) {
            ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)"Player is in an active battle.").method_27692(class_124.field_1061));
            return 1;
        }
        PlayerPartyStore party = Cobblemon.INSTANCE.getStorage().getParty(battlingPlayer);
        UUID pokemonUUID = null;
        for (Pokemon pokemon : party) {
            if (pokemon.isFainted()) continue;
            pokemonUUID = pokemon.getUuid();
        }
        if (pokemonUUID == null) {
            ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)"Player unable to battle, no available pokemon in their party.").method_27692(class_124.field_1061));
            return 1;
        }
        class_3218 world = ((class_2168)ctx.getSource()).method_9225();
        Intrinsics.checkNotNull(world);
        PokemonEntity pokemonEntity = PokemonProperties.createEntity$default((PokemonProperties)pokemonProperties, (class_1937)((class_1937)world), null, (int)2, null);
        pokemonEntity.method_5808(battlingPlayer.method_23317(), battlingPlayer.method_23318(), battlingPlayer.method_23321(), pokemonEntity.method_36454(), pokemonEntity.method_36455());
        pokemonEntity.method_5841().method_12778(PokemonEntity.Companion.getSPAWN_DIRECTION(), (Object)Float.valueOf(pokemonEntity.method_59922().method_43057() * 360.0f));
        if (world.method_8649((class_1297)pokemonEntity)) {
            pokemonEntity.method_5859(battlingPlayer.method_23317(), battlingPlayer.method_23318(), battlingPlayer.method_23321());
            BattleBuilder.INSTANCE.pve(battlingPlayer, pokemonEntity, pokemonUUID, BattleFormat.Companion.getGEN_9_SINGLES(), false, false, Cobblemon.INSTANCE.getConfig().getDefaultFleeDistance(), (PartyStore)party);
        } else {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Failed to spawn Pokemon in world for player..."));
        }
        return 1;
    }

    private static final boolean register$lambda$0(class_2168 src) {
        return CobblemonExtrasPermissions.Companion.checkPermission(src, CobblemonExtras.INSTANCE.getPermissions().getPOKEBATTLE_PERMISSION());
    }

    private static final int register$lambda$1(PokeBattle this$0, CommandContext ctx) {
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        return this$0.execute((CommandContext<class_2168>)ctx);
    }
}

