/*
 * Decompiled with CFR 0.152.
 */
package dev.chasem.cobblemonextras.commands;

import com.cobblemon.mod.common.Cobblemon;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.chasem.cobblemonextras.CobblemonExtras;
import dev.chasem.cobblemonextras.config.CobblemonExtrasConfig;
import dev.chasem.cobblemonextras.permissions.CobblemonExtrasPermissions;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\b\u0010\tJ%\u0010\u000f\u001a\u00020\u000e2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001d\u0010\u0014\u001a\u00020\u000e2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\nH\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Ldev/chasem/cobblemonextras/commands/PokeOdds;", "", "<init>", "()V", "Lcom/mojang/brigadier/CommandDispatcher;", "Lnet/minecraft/class_2168;", "dispatcher", "", "register", "(Lcom/mojang/brigadier/CommandDispatcher;)V", "Lcom/mojang/brigadier/context/CommandContext;", "ctx", "", "rate", "", "setRate", "(Lcom/mojang/brigadier/context/CommandContext;F)I", "newShinyRate", "saveCobblemonConfig", "(F)V", "execute", "(Lcom/mojang/brigadier/context/CommandContext;)I", "common"})
public final class PokeOdds {
    public final void register(@NotNull CommandDispatcher<class_2168> dispatcher) {
        Intrinsics.checkNotNullParameter(dispatcher, "dispatcher");
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"pokeodds").executes(arg_0 -> PokeOdds.register$lambda$0(this, arg_0))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"setRate").requires(PokeOdds::register$lambda$1)).then(class_2170.method_9244((String)"rate", (ArgumentType)((ArgumentType)FloatArgumentType.floatArg((float)1.0f, (float)10000.0f))).executes(arg_0 -> PokeOdds.register$lambda$2(this, arg_0)))));
    }

    private final int setRate(CommandContext<class_2168> ctx, float rate) {
        Cobblemon.INSTANCE.getConfig().setShinyRate(rate);
        try {
            this.saveCobblemonConfig(rate);
            ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)"The shiny rate has been set to: ").method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(rate)).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" (saved to config)").method_27692(class_124.field_1060)));
        }
        catch (Exception e) {
            ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)"The shiny rate has been set to: ").method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(rate)).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" (WARNING: failed to save to config)").method_27692(class_124.field_1061)));
            CobblemonExtras.INSTANCE.getLogger().error("Failed to save Cobblemon config after setting shiny rate", (Throwable)e);
        }
        return 1;
    }

    private final void saveCobblemonConfig(float newShinyRate) {
        String configFileLoc = System.getProperty("user.dir") + File.separator + "config" + File.separator + "cobblemon" + File.separator + "main.json";
        File configFile = new File(configFileLoc);
        if (!configFile.exists()) {
            CobblemonExtras.INSTANCE.getLogger().warn("Cobblemon config file not found at: " + configFileLoc);
            return;
        }
        try {
            FileReader fileReader = new FileReader(configFile);
            JsonObject configJson = JsonParser.parseReader((Reader)fileReader).getAsJsonObject();
            fileReader.close();
            configJson.addProperty("shinyRate", (Number)Float.valueOf(newShinyRate));
            FileWriter fileWriter = new FileWriter(configFile);
            CobblemonExtrasConfig.Companion.getGSON().toJson((JsonElement)configJson, (Appendable)fileWriter);
            fileWriter.flush();
            fileWriter.close();
            CobblemonExtras.INSTANCE.getLogger().info("Successfully saved shiny rate " + newShinyRate + " to Cobblemon config");
        }
        catch (Exception e) {
            CobblemonExtras.INSTANCE.getLogger().error("Failed to save Cobblemon config", (Throwable)e);
            throw e;
        }
    }

    private final int execute(CommandContext<class_2168> ctx) {
        ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)"The current shiny rate is: ").method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(Cobblemon.INSTANCE.getConfig().getShinyRate())).method_27692(class_124.field_1075)));
        return 1;
    }

    private static final int register$lambda$0(PokeOdds this$0, CommandContext ctx) {
        Intrinsics.checkNotNull(ctx);
        return this$0.execute((CommandContext<class_2168>)ctx);
    }

    private static final boolean register$lambda$1(class_2168 src) {
        boolean isConsole = src.method_9228() == null;
        boolean isOp = src.method_9259(2);
        boolean hasNode = CobblemonExtrasPermissions.Companion.checkPermission(src, CobblemonExtras.INSTANCE.getPermissions().getPOKEODDS_PERMISSION());
        return isConsole || isOp || hasNode;
    }

    private static final int register$lambda$2(PokeOdds this$0, CommandContext ctx) {
        Intrinsics.checkNotNull(ctx);
        return this$0.setRate((CommandContext<class_2168>)ctx, FloatArgumentType.getFloat((CommandContext)ctx, (String)"rate"));
    }
}

