/*
 * Decompiled with CFR 0.152.
 */
package dev.chasem.cobblemonextras.services;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.api.storage.pc.PCBox;
import com.cobblemon.mod.common.api.storage.pc.PCStore;
import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import dev.chasem.cobblemonextras.CobblemonExtras;
import dev.chasem.cobblemonextras.services.ShowcaseService;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.zip.DeflaterOutputStream;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5455;
import net.minecraft.server.MinecraftServer;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u0004H\u0082@\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001d\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001b\u0010\u0016\u001a\u00020\u00042\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u0015\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001f\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001b\u0010\u001e\u001a\u0004\u0018\u00010\u00182\b\u0010\u001d\u001a\u0004\u0018\u00010\u0018H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ!\u0010 \u001a\u00020\u00112\b\u0010\u0019\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001a\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b \u0010!R\u0016\u0010\"\u001a\u00020\u00118\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\"\u0010#R\"\u0010$\u001a\u00020\u00188\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b$\u0010%\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u0014\u0010+\u001a\u00020*8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b+\u0010,R\u0014\u0010.\u001a\u00020-8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b.\u0010/R\u0014\u00100\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u0016\u00103\u001a\u0004\u0018\u00010\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u0010'\u00a8\u00064"}, d2={"Ldev/chasem/cobblemonextras/services/ShowcaseService;", "", "<init>", "()V", "", "stop", "doRepeatingTask", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemon", "Lcom/google/gson/JsonObject;", "getPokemonJson", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;)Lcom/google/gson/JsonObject;", "Lnet/minecraft/class_3222;", "player", "getPlayerJson", "(Lnet/minecraft/class_3222;)Lcom/google/gson/JsonObject;", "", "showcaseEnabled", "togglePlayerPublic", "(Lnet/minecraft/class_3222;Z)V", "", "syncPlayers", "(Ljava/util/List;)V", "", "apiToken", "requestBody", "sendUpdateRequest", "(Ljava/lang/String;Lcom/google/gson/JsonObject;)V", "string", "compress", "(Ljava/lang/String;)Ljava/lang/String;", "sendPlayerToggle", "(Ljava/lang/String;Lcom/google/gson/JsonObject;)Z", "hasFailed", "Z", "API_BASE_URL", "Ljava/lang/String;", "getAPI_BASE_URL", "()Ljava/lang/String;", "setAPI_BASE_URL", "(Ljava/lang/String;)V", "", "minutes", "F", "", "delayMs", "J", "isValidSecret", "()Z", "getClientSecret", "clientSecret", "common"})
public final class ShowcaseService {
    @NotNull
    public static final ShowcaseService INSTANCE = new ShowcaseService();
    private static boolean hasFailed;
    @NotNull
    private static String API_BASE_URL;
    private static final float minutes;
    private static final long delayMs;

    private ShowcaseService() {
    }

    @NotNull
    public final String getAPI_BASE_URL() {
        return API_BASE_URL;
    }

    public final void setAPI_BASE_URL(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        API_BASE_URL = string;
    }

    public final void stop() {
        CobblemonExtras.INSTANCE.getLogger().info("Showcase Task Stopped");
    }

    /*
     * Unable to fully structure code
     */
    private final Object doRepeatingTask(Continuation<? super Unit> $completion) {
        if (!($completion instanceof doRepeatingTask.1)) ** GOTO lbl-1000
        var5_2 = $completion;
        if ((var5_2.label & -2147483648) != 0) {
            var5_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ ShowcaseService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ShowcaseService.access$doRepeatingTask(this.this$0, this);
                }
            };
        }
        $result = $continuation.result;
        var6_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        block1 : switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
lbl13:
                // 3 sources

                while (true) {
                    if (CobblemonExtras.INSTANCE.getConfig().getShowcase().getDebug()) {
                        CobblemonExtras.INSTANCE.getLogger().info("Running showcase sync task...");
                    }
                    if ((server = Cobblemon.INSTANCE.getImplementation().server()) != null) break block1;
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)server);
                    $continuation.label = 1;
                    v0 = DelayKt.delay(10000L, $continuation);
                    if (v0 == var6_4) {
                        return var6_4;
                    }
                    ** GOTO lbl27
                    break;
                }
            }
            case 1: {
                server = (MinecraftServer)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v0 = $result;
lbl27:
                // 2 sources

                CobblemonExtras.INSTANCE.getLogger().error("Unable to get server instance, retrying in " + ShowcaseService.minutes + " minutes");
                ** GOTO lbl13
            }
        }
        try {
            v1 = server.method_3760().method_14571();
            Intrinsics.checkNotNullExpressionValue(v1, "getPlayers(...)");
            this.syncPlayers(v1);
        }
        catch (Exception e) {
            e.printStackTrace();
            CobblemonExtras.INSTANCE.getLogger().error("Error when syncing playerData.");
        }
        $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)server);
        $continuation.label = 2;
        v2 = DelayKt.delay(ShowcaseService.delayMs, $continuation);
        if (v2 == var6_4) {
            return var6_4;
        }
        ** GOTO lbl48
        {
            case 2: {
                server = (MinecraftServer)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v2 = $result;
lbl48:
                // 2 sources

                ** continue;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public final JsonObject getPokemonJson(@NotNull Pokemon pokemon) {
        Intrinsics.checkNotNullParameter(pokemon, "pokemon");
        class_5455.class_6890 class_68902 = class_5455.field_40585;
        Intrinsics.checkNotNullExpressionValue(class_68902, "EMPTY");
        JsonObject pokemonJson = pokemon.saveToJSON((class_5455)class_68902, new JsonObject());
        try {
            JsonElement moveSet3;
            pokemonJson.addProperty("Nature", LocalizationUtilsKt.lang((String)StringsKt.replace$default(pokemon.getNature().getDisplayName(), "cobblemon.", "", false, 4, null), (Object[])new Object[0]).getString());
            pokemonJson.addProperty("DexNumber", (Number)pokemon.getSpecies().getNationalPokedexNumber());
            if (pokemon.getNickname() != null) {
                class_5250 class_52502 = pokemon.getNickname();
                Intrinsics.checkNotNull(class_52502);
                pokemonJson.addProperty("Nickname", class_52502.getString());
            } else {
                pokemonJson.add("Nickname", (JsonElement)JsonNull.INSTANCE);
            }
            pokemonJson.addProperty("Name", pokemon.getSpecies().getTranslatedName().getString());
            JsonObject abilityJson = pokemonJson.getAsJsonObject("Ability");
            abilityJson.addProperty("AbilityName", LocalizationUtilsKt.lang((String)StringsKt.replace$default(pokemon.getAbility().getDisplayName(), "cobblemon.", "", false, 4, null), (Object[])new Object[0]).getString());
            pokemonJson.add("Ability", (JsonElement)abilityJson);
            pokemonJson.addProperty("FormName", pokemon.getForm().getName());
            pokemonJson.addProperty("Type1", pokemon.getPrimaryType().getDisplayName().getString());
            if (pokemon.getSecondaryType() != null) {
                ElementalType elementalType = pokemon.getSecondaryType();
                Intrinsics.checkNotNull(elementalType);
                pokemonJson.addProperty("Type2", elementalType.getDisplayName().getString());
            } else {
                pokemonJson.add("Type2", (JsonElement)JsonNull.INSTANCE);
            }
            JsonArray moveJsonArray = pokemonJson.getAsJsonArray("MoveSet");
            JsonObject moveJson = new JsonObject();
            JsonElement moveSet0 = moveJsonArray.size() >= 1 ? moveJsonArray.get(0) : (JsonElement)JsonNull.INSTANCE;
            JsonElement moveSet1 = moveJsonArray.size() >= 2 ? moveJsonArray.get(1) : (JsonElement)JsonNull.INSTANCE;
            JsonElement moveSet2 = moveJsonArray.size() >= 3 ? moveJsonArray.get(2) : (JsonElement)JsonNull.INSTANCE;
            JsonElement jsonElement = moveSet3 = moveJsonArray.size() >= 4 ? moveJsonArray.get(3) : (JsonElement)JsonNull.INSTANCE;
            if (moveSet0 != null && !moveSet0.isJsonNull()) {
                JsonObject jsonObject = moveSet0.getAsJsonObject();
                Move move = pokemon.getMoveSet().get(0);
                Intrinsics.checkNotNull(move);
                jsonObject.addProperty("MoveName", move.getDisplayName().getString());
                JsonObject jsonObject2 = moveSet0.getAsJsonObject();
                Move move2 = pokemon.getMoveSet().get(0);
                Intrinsics.checkNotNull(move2);
                jsonObject2.addProperty("MoveType", move2.getType().getName());
                moveJson.add("MoveSet0", moveSet0);
            }
            if (moveSet1 != null && !moveSet1.isJsonNull()) {
                JsonObject jsonObject = moveSet1.getAsJsonObject();
                Move move = pokemon.getMoveSet().get(1);
                Intrinsics.checkNotNull(move);
                jsonObject.addProperty("MoveName", move.getDisplayName().getString());
                JsonObject jsonObject3 = moveSet1.getAsJsonObject();
                Move move3 = pokemon.getMoveSet().get(1);
                Intrinsics.checkNotNull(move3);
                jsonObject3.addProperty("MoveType", move3.getType().getName());
                moveJson.add("MoveSet1", moveSet1);
            }
            if (moveSet2 != null && !moveSet2.isJsonNull()) {
                JsonObject jsonObject = moveSet2.getAsJsonObject();
                Move move = pokemon.getMoveSet().get(2);
                Intrinsics.checkNotNull(move);
                jsonObject.addProperty("MoveName", move.getDisplayName().getString());
                JsonObject jsonObject4 = moveSet2.getAsJsonObject();
                Move move4 = pokemon.getMoveSet().get(2);
                Intrinsics.checkNotNull(move4);
                jsonObject4.addProperty("MoveType", move4.getType().getName());
                moveJson.add("MoveSet2", moveSet2);
            }
            if (moveSet3 != null && !moveSet3.isJsonNull()) {
                JsonObject jsonObject = moveSet3.getAsJsonObject();
                Move move = pokemon.getMoveSet().get(3);
                Intrinsics.checkNotNull(move);
                jsonObject.addProperty("MoveName", move.getDisplayName().getString());
                JsonObject jsonObject5 = moveSet3.getAsJsonObject();
                Move move5 = pokemon.getMoveSet().get(3);
                Intrinsics.checkNotNull(move5);
                jsonObject5.addProperty("MoveType", move5.getType().getName());
                moveJson.add("MoveSet3", moveSet3);
            }
            pokemonJson.add("MoveSet", (JsonElement)moveJson);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return pokemonJson;
    }

    @Nullable
    public final JsonObject getPlayerJson(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter(player, "player");
        PlayerPartyStore party = null;
        PCStore pc = null;
        try {
            party = Cobblemon.INSTANCE.getStorage().getParty(player);
            pc = Cobblemon.INSTANCE.getStorage().getPC(player);
        }
        catch (Exception exc) {
            return null;
        }
        JsonObject playerData = new JsonObject();
        playerData.addProperty("uuid", player.method_5667().toString());
        class_2561 class_25612 = player.method_5476();
        Intrinsics.checkNotNull(class_25612);
        playerData.addProperty("name", class_25612.getString());
        JsonArray partyJson = new JsonArray();
        for (int i = 0; i < 6; ++i) {
            Pokemon pokemon = party.get(i);
            if (pokemon == null) {
                partyJson.add((JsonElement)JsonNull.INSTANCE);
                continue;
            }
            JsonObject pokemonJson = this.getPokemonJson(pokemon);
            partyJson.add((JsonElement)Objects.requireNonNullElse(pokemonJson, JsonNull.INSTANCE));
        }
        JsonElement pcJson = (JsonElement)new JsonArray();
        if (pc != null) {
            for (PCBox box : pc.getBoxes()) {
                JsonArray boxJson = new JsonArray();
                for (int slot = 0; slot < 30; ++slot) {
                    Pokemon pokemon = box.get(slot);
                    if (pokemon == null) {
                        boxJson.add((JsonElement)JsonNull.INSTANCE);
                        continue;
                    }
                    JsonObject pokemonJson = this.getPokemonJson(pokemon);
                    boxJson.add((JsonElement)Objects.requireNonNullElse(pokemonJson, JsonNull.INSTANCE));
                }
                ((JsonArray)pcJson).add((JsonElement)boxJson);
            }
        } else {
            JsonNull jsonNull = JsonNull.INSTANCE;
            Intrinsics.checkNotNullExpressionValue(jsonNull, "INSTANCE");
            pcJson = (JsonElement)jsonNull;
        }
        playerData.add("party", (JsonElement)partyJson);
        playerData.add("pc", pcJson);
        playerData.addProperty("lastUpdated", (Number)System.currentTimeMillis());
        return playerData;
    }

    public final void togglePlayerPublic(@NotNull class_3222 player, boolean showcaseEnabled) {
        Intrinsics.checkNotNullParameter(player, "player");
        JsonObject json = new JsonObject();
        json.addProperty("uuid", player.method_5667().toString());
        json.addProperty("showcaseEnabled", Boolean.valueOf(showcaseEnabled));
        boolean success = this.sendPlayerToggle(this.getClientSecret(), json);
        if (success) {
            if (showcaseEnabled) {
                class_5250 onText = class_2561.method_43470((String)"ON").method_27696(class_2583.field_24360.method_10977(class_124.field_1060));
                class_5250 msg = class_2561.method_43470((String)"Showcase is now ").method_10852((class_2561)onText);
                player.method_43496((class_2561)msg);
            } else {
                class_5250 offText = class_2561.method_43470((String)"OFF").method_27696(class_2583.field_24360.method_10977(class_124.field_1061));
                class_5250 msg = class_2561.method_43470((String)"Showcase is now ").method_10852((class_2561)offText);
                player.method_43496((class_2561)msg);
            }
        } else {
            player.method_43496((class_2561)class_2561.method_43470((String)"Failed to toggle showcase visibility.").method_27696(class_2583.field_24360.method_10977(class_124.field_1061)));
        }
    }

    public final void syncPlayers(@NotNull List<? extends class_3222> player) {
        Intrinsics.checkNotNullParameter(player, "player");
        if (CobblemonExtras.INSTANCE.getConfig().getShowcase().isShowcaseEnabled()) {
            boolean isSecretValid = this.isValidSecret();
            String apiSecret = this.getClientSecret();
            if (apiSecret == null || !isSecretValid) {
                CobblemonExtras.INSTANCE.getLogger().error("Invalid API Secret, please goto https://cobblemonextras.com/showcase to get your API Secret");
                return;
            }
            if (CobblemonExtras.INSTANCE.getConfig().getShowcase().getDebug()) {
                CobblemonExtras.INSTANCE.getLogger().info("Syncing " + player.size() + " players...");
            }
            JsonObject request = new JsonObject();
            JsonArray playerData = new JsonArray();
            for (class_3222 class_32222 : player) {
                try {
                    JsonObject playerJson = this.getPlayerJson(class_32222);
                    if (playerJson == null) continue;
                    playerData.add((JsonElement)playerJson);
                }
                catch (Exception exc) {
                    Logger logger = CobblemonExtras.INSTANCE.getLogger();
                    class_2561 class_25612 = class_32222.method_5476();
                    Intrinsics.checkNotNull(class_25612);
                    logger.error("Error when syncing playerData for " + class_25612.getString());
                    exc.printStackTrace();
                }
            }
            request.add("players", (JsonElement)playerData);
            if (!playerData.isEmpty()) {
                this.sendUpdateRequest(apiSecret, request);
            }
        }
    }

    private final boolean isValidSecret() {
        try {
            String string = CobblemonExtras.INSTANCE.getConfig().getShowcase().getApiSecret().substring(StringsKt.indexOf$default((CharSequence)CobblemonExtras.INSTANCE.getConfig().getShowcase().getApiSecret(), '-', 0, false, 6, null) + 1);
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            String uuid = string;
            return UUID.fromString(uuid) != null;
        }
        catch (IllegalArgumentException e) {
            CobblemonExtras.INSTANCE.getLogger().error("Invalid API Secret, please goto https://cobblemonextras.com/showcase to get your API Secret");
            return false;
        }
    }

    private final String getClientSecret() {
        if (!this.isValidSecret()) {
            return null;
        }
        String text = CobblemonExtras.INSTANCE.getConfig().getShowcase().getApiSecret();
        if (text == null || ((CharSequence)text).length() == 0) {
            CobblemonExtras.INSTANCE.getLogger().error("API Secret Missing, please goto https://cobblemonextras.com/showcase to get your API Secret");
            return null;
        }
        if (Intrinsics.areEqual(text, "To start using showcase, please goto https://cobblemonextras.com/showcase")) {
            CobblemonExtras.INSTANCE.getLogger().error("API Secret Missing, please goto https://cobblemonextras.com/showcase to get your API Secret");
            return null;
        }
        return CobblemonExtras.INSTANCE.getConfig().getShowcase().getApiSecret();
    }

    private final void sendUpdateRequest(String apiToken, JsonObject requestBody) {
        CloseableHttpClient closeableHttpClient = HttpClientBuilder.create().setRedirectStrategy(new LaxRedirectStrategy()).build();
        Intrinsics.checkNotNullExpressionValue(closeableHttpClient, "build(...)");
        HttpClient httpClient = closeableHttpClient;
        try {
            HttpPost post = new HttpPost(API_BASE_URL + "/sync");
            post.setHeader("Accept-Encoding", "UTF-8");
            post.setHeader("Content-type", "application/json");
            Base64.Encoder encoder = Base64.getEncoder();
            String string = apiToken;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue(charset, "UTF_8");
            byte[] byArray = string.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
            post.setHeader("Authorization", encoder.encodeToString(byArray));
            String payload = requestBody.toString();
            try {
                payload = this.compress(payload);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            StringEntity postingString = new StringEntity(payload, "UTF-8");
            post.setEntity(postingString);
            HttpResponse response = httpClient.execute(post);
            if (response.getStatusLine().getStatusCode() == 403) {
                CobblemonExtras.INSTANCE.getLogger().warn("Trouble syncing playerData, Maximum player count has been reached.");
            } else if (response.getStatusLine().getStatusCode() == 404) {
                CobblemonExtras.INSTANCE.getLogger().warn(response.getStatusLine().getStatusCode() + " - " + response.getStatusLine().getReasonPhrase());
                CobblemonExtras.INSTANCE.getLogger().warn("No server was found matching your configured clientSecret.");
                CobblemonExtras.INSTANCE.getLogger().warn("Navigate to your dashboard and copy your clientSecret. https://cobblemonextras.com/showcase/manage");
            } else if (response.getStatusLine().getStatusCode() != 200) {
                CobblemonExtras.INSTANCE.getLogger().warn("Error when syncing playerData.");
                CobblemonExtras.INSTANCE.getLogger().warn(response.getStatusLine().getStatusCode() + " - " + response.getStatusLine().getReasonPhrase());
            } else {
                hasFailed = false;
            }
        }
        catch (Exception ex) {
            if (!hasFailed) {
                ex.printStackTrace();
                hasFailed = true;
            }
            CobblemonExtras.INSTANCE.getLogger().error("Failed to sync playerData to Showcase. Please report this to the CobblemonExtras Team.");
        }
    }

    private final String compress(String string) throws IOException {
        if (string == null || ((CharSequence)string).length() == 0) {
            return string;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DeflaterOutputStream dos = new DeflaterOutputStream(baos);
        String string2 = string;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue(charset, "UTF_8");
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
        dos.write(byArray);
        dos.close();
        return Base64.getEncoder().encodeToString(baos.toByteArray());
    }

    private final boolean sendPlayerToggle(String apiToken, JsonObject requestBody) {
        CloseableHttpClient closeableHttpClient = HttpClientBuilder.create().setRedirectStrategy(new LaxRedirectStrategy()).build();
        Intrinsics.checkNotNullExpressionValue(closeableHttpClient, "build(...)");
        HttpClient httpClient = closeableHttpClient;
        try {
            HttpPost post = new HttpPost(API_BASE_URL + "/player");
            post.setHeader("Accept-Encoding", "UTF-8");
            post.setHeader("Content-type", "application/json");
            Base64.Encoder encoder = Base64.getEncoder();
            String string = apiToken;
            Intrinsics.checkNotNull(string);
            String string2 = string;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue(charset, "UTF_8");
            byte[] byArray = string2.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
            post.setHeader("Authorization", encoder.encodeToString(byArray));
            StringEntity postingString = new StringEntity(requestBody.toString(), "UTF-8");
            post.setEntity(postingString);
            HttpResponse response = httpClient.execute(post);
            if (response.getStatusLine().getStatusCode() == 403) {
                CobblemonExtras.INSTANCE.getLogger().warn("Trouble syncing player public visibility");
                return false;
            }
            if (response.getStatusLine().getStatusCode() == 404) {
                CobblemonExtras.INSTANCE.getLogger().warn("Player attempted to turn off their showcase visibility.");
                CobblemonExtras.INSTANCE.getLogger().warn("No server was found matching your configured clientSecret.");
                return false;
            }
            if (response.getStatusLine().getStatusCode() != 200) {
                CobblemonExtras.INSTANCE.getLogger().warn("Error when syncing player public visibility.");
                CobblemonExtras.INSTANCE.getLogger().warn(response.getStatusLine().getStatusCode() + " - " + response.getStatusLine().getReasonPhrase());
                return false;
            }
            hasFailed = false;
            return true;
        }
        catch (Exception ex) {
            if (!hasFailed) {
                ex.printStackTrace();
                hasFailed = true;
            } else {
                CobblemonExtras.INSTANCE.getLogger().error("Failed to toggle player public visibility.");
            }
            return false;
        }
    }

    static {
        API_BASE_URL = "https://cobblemonextras.com/api";
        minutes = (float)Math.max((double)CobblemonExtras.INSTANCE.getConfig().getShowcase().getSyncIntervalMinutes(), 1.0);
        delayMs = (long)(minutes * (float)60 * (float)1000);
        CobblemonExtras.INSTANCE.getLogger().info("ShowcaseService - Initializing...");
        if (CobblemonExtras.INSTANCE.getConfig().getShowcase().isShowcaseEnabled()) {
            if (INSTANCE.getClientSecret() == null) {
                CobblemonExtras.INSTANCE.getLogger().info("Failed to enable Showcase");
                CobblemonExtras.INSTANCE.getLogger().error("Invalid API Secret, please goto https://cobblemonextras.com/showcase to get your API Secret");
            } else {
                CobblemonExtras.INSTANCE.getLogger().info("[CobblemonExtras] Showcase will sync every " + CobblemonExtras.INSTANCE.getConfig().getShowcase().getSyncIntervalMinutes() + " minutes.");
                BuildersKt.launch$default(CoroutineScopeKt.CoroutineScope(Dispatchers.getDefault()), new CoroutineName("CobblemonExtrasShowcaseService"), null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
                    int label;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Override
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure($result);
                                Thread.currentThread().setName("ShowcaseService");
                                this.label = 1;
                                Object object2 = INSTANCE.doRepeatingTask(this);
                                if (object2 != object) return Unit.INSTANCE;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure($result);
                                Object object2 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @Override
                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                    }

                    @Override
                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }, 2, null);
                CobblemonExtras.INSTANCE.getLogger().info("Showcase Enabled, Syncing every " + delayMs + " ms");
            }
        } else {
            CobblemonExtras.INSTANCE.getLogger().info("ShowcaseService - Disabled");
        }
    }
}

