/*
 * Decompiled with CFR 0.152.
 */
package dev.chasem.apache.http.impl.client;

import dev.chasem.apache.http.HeaderElement;
import dev.chasem.apache.http.HttpResponse;
import dev.chasem.apache.http.annotation.Contract;
import dev.chasem.apache.http.annotation.ThreadingBehavior;
import dev.chasem.apache.http.conn.ConnectionKeepAliveStrategy;
import dev.chasem.apache.http.message.BasicHeaderElementIterator;
import dev.chasem.apache.http.protocol.HttpContext;
import dev.chasem.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class DefaultConnectionKeepAliveStrategy
implements ConnectionKeepAliveStrategy {
    public static final DefaultConnectionKeepAliveStrategy INSTANCE = new DefaultConnectionKeepAliveStrategy();

    @Override
    public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
        Args.notNull(response, "HTTP response");
        BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
        while (it.hasNext()) {
            HeaderElement he = it.nextElement();
            String param = he.getName();
            String value = he.getValue();
            if (value == null || !param.equalsIgnoreCase("timeout")) continue;
            try {
                return Long.parseLong(value) * 1000L;
            }
            catch (NumberFormatException ignore) {
            }
        }
        return -1L;
    }
}

