/*
 * Decompiled with CFR 0.152.
 */
package dev.chasem.apache.http.impl.conn;

import dev.chasem.apache.http.HttpResponse;
import dev.chasem.apache.http.HttpResponseFactory;
import dev.chasem.apache.http.annotation.Contract;
import dev.chasem.apache.http.annotation.ThreadingBehavior;
import dev.chasem.apache.http.config.MessageConstraints;
import dev.chasem.apache.http.impl.DefaultHttpResponseFactory;
import dev.chasem.apache.http.impl.conn.DefaultHttpResponseParser;
import dev.chasem.apache.http.io.HttpMessageParser;
import dev.chasem.apache.http.io.HttpMessageParserFactory;
import dev.chasem.apache.http.io.SessionInputBuffer;
import dev.chasem.apache.http.message.BasicLineParser;
import dev.chasem.apache.http.message.LineParser;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultHttpResponseParserFactory
implements HttpMessageParserFactory<HttpResponse> {
    public static final DefaultHttpResponseParserFactory INSTANCE = new DefaultHttpResponseParserFactory();
    private final LineParser lineParser;
    private final HttpResponseFactory responseFactory;

    public DefaultHttpResponseParserFactory(LineParser lineParser, HttpResponseFactory responseFactory) {
        this.lineParser = lineParser != null ? lineParser : BasicLineParser.INSTANCE;
        this.responseFactory = responseFactory != null ? responseFactory : DefaultHttpResponseFactory.INSTANCE;
    }

    public DefaultHttpResponseParserFactory(HttpResponseFactory responseFactory) {
        this(null, responseFactory);
    }

    public DefaultHttpResponseParserFactory() {
        this(null, null);
    }

    @Override
    public HttpMessageParser<HttpResponse> create(SessionInputBuffer buffer, MessageConstraints constraints) {
        return new DefaultHttpResponseParser(buffer, this.lineParser, this.responseFactory, constraints);
    }
}

