/*
 * Decompiled with CFR 0.152.
 */
package dev.chasem.cobblemonextras.commands;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.storage.NoPokemonStoreException;
import com.cobblemon.mod.common.api.storage.StorePosition;
import com.cobblemon.mod.common.api.storage.pc.PCBox;
import com.cobblemon.mod.common.api.storage.pc.PCPosition;
import com.cobblemon.mod.common.api.storage.pc.PCStore;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.chasem.cobblemonextras.CobblemonExtras;
import dev.chasem.cobblemonextras.permissions.CobblemonExtrasPermissions;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\r\u001a\u00020\f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\nH\u0002\u00a2\u0006\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Ldev/chasem/cobblemonextras/commands/EmptyBox;", "", "<init>", "()V", "Lcom/mojang/brigadier/CommandDispatcher;", "Lnet/minecraft/commands/CommandSourceStack;", "dispatcher", "", "register", "(Lcom/mojang/brigadier/CommandDispatcher;)V", "Lcom/mojang/brigadier/context/CommandContext;", "ctx", "", "execute", "(Lcom/mojang/brigadier/context/CommandContext;)I", "common"})
public final class EmptyBox {
    public final void register(@NotNull CommandDispatcher<CommandSourceStack> dispatcher) {
        Intrinsics.checkNotNullParameter(dispatcher, (String)"dispatcher");
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"emptybox").requires(EmptyBox::register$lambda$0)).then(Commands.argument((String)"box", (ArgumentType)((ArgumentType)IntegerArgumentType.integer((int)1, (int)Cobblemon.INSTANCE.getConfig().getDefaultBoxCount()))).executes(arg_0 -> EmptyBox.register$lambda$1(this, arg_0))));
    }

    private final int execute(CommandContext<CommandSourceStack> ctx) {
        if (((CommandSourceStack)ctx.getSource()).getPlayer() != null) {
            ServerPlayer serverPlayer = ((CommandSourceStack)ctx.getSource()).getPlayer();
            Intrinsics.checkNotNull((Object)serverPlayer);
            ServerPlayer player = serverPlayer;
            PCStore playerPc = null;
            try {
                playerPc = Cobblemon.INSTANCE.getStorage().getPC(player);
            }
            catch (NoPokemonStoreException e) {
                player.sendSystemMessage((Component)Component.literal((String)"Error accessing PC..."));
                return -1;
            }
            int boxNum = ((Number)ctx.getArgument("box", Integer.TYPE)).intValue() - 1;
            PCBox box = (PCBox)playerPc.getBoxes().get(boxNum);
            if (box == null) {
                player.sendSystemMessage((Component)Component.literal((String)("Error accessing box... " + boxNum)));
                return -1;
            }
            for (int i = 0; i < 30; ++i) {
                playerPc.remove((StorePosition)new PCPosition(boxNum, i));
            }
            player.sendSystemMessage((Component)Component.literal((String)("Box " + (boxNum + 1) + " has been emptied.")));
        } else {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"Sorry, this is only for players."));
        }
        return 1;
    }

    private static final boolean register$lambda$0(CommandSourceStack src) {
        return CobblemonExtrasPermissions.Companion.checkPermission(src, CobblemonExtras.INSTANCE.getPermissions().getEMPTYBOX_PERMISSION());
    }

    private static final int register$lambda$1(EmptyBox this$0, CommandContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        return this$0.execute((CommandContext<CommandSourceStack>)ctx);
    }
}

