/*
 * Decompiled with CFR 0.152.
 */
package dev.chasem.cobblemonextras.commands;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.storage.StorePosition;
import com.cobblemon.mod.common.api.storage.party.PartyPosition;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.LiteralCommandNode;
import dev.chasem.cobblemonextras.CobblemonExtras;
import dev.chasem.cobblemonextras.permissions.CobblemonExtrasPermissions;
import dev.chasem.cobblemonextras.util.PokemonUtility;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\r\u001a\u00020\f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\nH\u0002\u00a2\u0006\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Ldev/chasem/cobblemonextras/commands/PokeDelete;", "", "<init>", "()V", "Lcom/mojang/brigadier/CommandDispatcher;", "Lnet/minecraft/commands/CommandSourceStack;", "dispatcher", "", "register", "(Lcom/mojang/brigadier/CommandDispatcher;)V", "Lcom/mojang/brigadier/context/CommandContext;", "ctx", "", "execute", "(Lcom/mojang/brigadier/context/CommandContext;)I", "common"})
public final class PokeDelete {
    public final void register(@NotNull CommandDispatcher<CommandSourceStack> dispatcher) {
        Intrinsics.checkNotNullParameter(dispatcher, (String)"dispatcher");
        LiteralCommandNode main = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"pokedelete").requires(PokeDelete::register$lambda$0)).then(Commands.argument((String)"player", (ArgumentType)((ArgumentType)EntityArgument.player())).then(Commands.argument((String)"slot", (ArgumentType)((ArgumentType)IntegerArgumentType.integer((int)1, (int)6))).executes(arg_0 -> PokeDelete.register$lambda$1(this, arg_0)))));
    }

    private final int execute(CommandContext<CommandSourceStack> ctx) {
        ServerPlayer serverPlayer = EntityArgument.getPlayer(ctx, (String)"player");
        Intrinsics.checkNotNullExpressionValue((Object)serverPlayer, (String)"getPlayer(...)");
        ServerPlayer player = serverPlayer;
        int slotNum = ((Number)ctx.getArgument("slot", Integer.TYPE)).intValue() - 1;
        PlayerPartyStore party = Cobblemon.INSTANCE.getStorage().getParty(player);
        Pokemon pokemon = party.get(slotNum);
        if (pokemon != null) {
            MutableComponent toSend = Component.literal((String)"Deleted: ").append((Component)Component.literal((String)"").setStyle(Style.EMPTY.withBold(Boolean.valueOf(true))));
            Intrinsics.checkNotNull((Object)toSend);
            Component text = PokemonUtility.INSTANCE.getHoverText(toSend, pokemon);
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage(text);
            party.remove((StorePosition)new PartyPosition(slotNum));
        } else {
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)"No Pokemon found in slot.").withStyle(ChatFormatting.RED));
        }
        return 1;
    }

    private static final boolean register$lambda$0(CommandSourceStack src) {
        return CobblemonExtrasPermissions.Companion.checkPermission(src, CobblemonExtras.INSTANCE.getPermissions().getPOKEDELETE_PERMISSION());
    }

    private static final int register$lambda$1(PokeDelete this$0, CommandContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        return this$0.execute((CommandContext<CommandSourceStack>)ctx);
    }
}

