/*
 * Decompiled with CFR 0.152.
 */
package dev.chasem.cobblemonextras.commands;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.pokemon.evolution.Evolution;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.evolution.variants.TradeEvolution;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.chasem.cobblemonextras.CobblemonExtras;
import dev.chasem.cobblemonextras.menus.PokeTradeMenu;
import dev.chasem.cobblemonextras.permissions.CobblemonExtrasPermissions;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0001\u0019B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\r\u001a\u00020\f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\nH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001d\u0010\u000f\u001a\u00020\f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\nH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u000eR4\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0018\u00010\u0012R\u00020\u00000\u00108\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001a"}, d2={"Ldev/chasem/cobblemonextras/commands/PokeTrade;", "", "<init>", "()V", "Lcom/mojang/brigadier/CommandDispatcher;", "Lnet/minecraft/commands/CommandSourceStack;", "dispatcher", "", "register", "(Lcom/mojang/brigadier/CommandDispatcher;)V", "Lcom/mojang/brigadier/context/CommandContext;", "ctx", "", "createTrade", "(Lcom/mojang/brigadier/context/CommandContext;)I", "respond", "Ljava/util/HashMap;", "Ljava/util/UUID;", "Ldev/chasem/cobblemonextras/commands/PokeTrade$TradeSession;", "tradeSessions", "Ljava/util/HashMap;", "getTradeSessions", "()Ljava/util/HashMap;", "setTradeSessions", "(Ljava/util/HashMap;)V", "TradeSession", "common"})
@SourceDebugExtension(value={"SMAP\nPokeTrade.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PokeTrade.kt\ndev/chasem/cobblemonextras/commands/PokeTrade\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,224:1\n739#2,9:225\n37#3,2:234\n*S KotlinDebug\n*F\n+ 1 PokeTrade.kt\ndev/chasem/cobblemonextras/commands/PokeTrade\n*L\n200#1:225,9\n200#1:234,2\n*E\n"})
public final class PokeTrade {
    @NotNull
    private HashMap<UUID, TradeSession> tradeSessions = new HashMap();

    public final void register(@NotNull CommandDispatcher<CommandSourceStack> dispatcher) {
        Intrinsics.checkNotNullParameter(dispatcher, (String)"dispatcher");
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"poketrade").requires(PokeTrade::register$lambda$0)).then(Commands.literal((String)"accept").executes(arg_0 -> PokeTrade.register$lambda$1(this, arg_0))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"poketrade").requires(PokeTrade::register$lambda$2)).then(Commands.literal((String)"deny").executes(arg_0 -> PokeTrade.register$lambda$3(this, arg_0))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"poketrade").requires(PokeTrade::register$lambda$4)).then(Commands.literal((String)"cancel").executes(arg_0 -> PokeTrade.register$lambda$5(this, arg_0))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"poketrade").requires(PokeTrade::register$lambda$6)).then(Commands.argument((String)"player", (ArgumentType)((ArgumentType)EntityArgument.player())).executes(arg_0 -> PokeTrade.register$lambda$7(this, arg_0))));
    }

    @NotNull
    public final HashMap<UUID, TradeSession> getTradeSessions() {
        return this.tradeSessions;
    }

    public final void setTradeSessions(@NotNull HashMap<UUID, TradeSession> hashMap) {
        Intrinsics.checkNotNullParameter(hashMap, (String)"<set-?>");
        this.tradeSessions = hashMap;
    }

    private final int createTrade(CommandContext<CommandSourceStack> ctx) {
        if (((CommandSourceStack)ctx.getSource()).getPlayer() != null) {
            ServerPlayer serverPlayer = ((CommandSourceStack)ctx.getSource()).getPlayer();
            Intrinsics.checkNotNull((Object)serverPlayer);
            ServerPlayer player = serverPlayer;
            if (this.tradeSessions.containsKey(player.getUUID())) {
                TradeSession tradeSession = this.tradeSessions.get(player.getUUID());
                long l = System.currentTimeMillis();
                TradeSession tradeSession2 = tradeSession;
                Intrinsics.checkNotNull((Object)tradeSession2);
                long timeSince = l - tradeSession2.getTimestamp();
                if (timeSince > 60000L) {
                    tradeSession.expire();
                } else {
                    MutableComponent cancel = Component.literal((String)"[CANCEL]").withStyle(Style.EMPTY.withBold(Boolean.valueOf(true)).withColor(ChatFormatting.RED).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/poketrade cancel")).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Cancel Trade"))));
                    player.sendSystemMessage((Component)Component.literal((String)"You have a trade pending. Cancel your last before creating a new trade.").withStyle(ChatFormatting.RED).append(" ").append((Component)cancel));
                    return 1;
                }
            }
            ServerPlayer serverPlayer2 = EntityArgument.getPlayer(ctx, (String)"player");
            Intrinsics.checkNotNullExpressionValue((Object)serverPlayer2, (String)"getPlayer(...)");
            ServerPlayer tradePartnerPlayer = serverPlayer2;
            if (tradePartnerPlayer.getUUID().equals(player.getUUID())) {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"Trading yourself? Your worth more than that <3"));
                return 1;
            }
            if (this.tradeSessions.containsKey(tradePartnerPlayer.getUUID())) {
                TradeSession tradeSession = this.tradeSessions.get(tradePartnerPlayer.getUUID());
                long l = System.currentTimeMillis();
                TradeSession tradeSession3 = tradeSession;
                Intrinsics.checkNotNull((Object)tradeSession3);
                long timeSince = l - tradeSession3.getTimestamp();
                if (timeSince > 60000L) {
                    tradeSession.expire();
                } else {
                    player.sendSystemMessage((Component)Component.literal((String)"Trade partner already has a trade pending, they must cancel or complete their trade before starting a new one.").withStyle(ChatFormatting.RED));
                    return 1;
                }
            }
            TradeSession tradeSession = new TradeSession(player, tradePartnerPlayer);
            ((Map)this.tradeSessions).put(tradePartnerPlayer.getUUID(), tradeSession);
            ((Map)this.tradeSessions).put(player.getUUID(), tradeSession);
            player.sendSystemMessage((Component)Component.literal((String)"Trade request sent.").withStyle(ChatFormatting.YELLOW));
            tradePartnerPlayer.sendSystemMessage((Component)Component.literal((String)"Pokemon trade request received from ").withStyle(ChatFormatting.YELLOW).append((Component)Component.literal((String)(player.getName() + ". ")).withStyle(ChatFormatting.GREEN)));
            MutableComponent accept = Component.literal((String)"[ACCEPT]").withStyle(Style.EMPTY.withBold(Boolean.valueOf(true)).withColor(ChatFormatting.GREEN).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/poketrade accept")).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Accept Trade"))));
            MutableComponent deny = Component.literal((String)"[DENY]").withStyle(Style.EMPTY.withBold(Boolean.valueOf(true)).withColor(ChatFormatting.RED).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/poketrade deny")).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Deny Trade"))));
            tradePartnerPlayer.sendSystemMessage((Component)accept.copy().append(" ").append((Component)deny));
        }
        return 1;
    }

    private final int respond(CommandContext<CommandSourceStack> ctx) {
        if (((CommandSourceStack)ctx.getSource()).getPlayer() != null) {
            List list;
            String string = ctx.getInput();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getInput(...)");
            CharSequence charSequence = string;
            Regex regex = new Regex(" ");
            int n = 0;
            List $this$dropLastWhile$iv = regex.split(charSequence, n);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    boolean bl = false;
                    if (((CharSequence)it).length() == 0) continue;
                    list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            Collection $this$toTypedArray$iv = list;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String response = thisCollection$iv.toArray(new String[0])[1];
            ServerPlayer serverPlayer = ((CommandSourceStack)ctx.getSource()).getPlayer();
            Intrinsics.checkNotNull((Object)serverPlayer);
            ServerPlayer player = serverPlayer;
            TradeSession tradeSession = this.tradeSessions.getOrDefault(player.getUUID(), null);
            if (tradeSession == null) {
                player.sendSystemMessage((Component)Component.literal((String)"No pending trade session.").withStyle(ChatFormatting.YELLOW));
                return 1;
            }
            if (StringsKt.equals((String)response, (String)"cancel", (boolean)true)) {
                tradeSession.cancel();
            } else if (StringsKt.equals((String)response, (String)"deny", (boolean)true)) {
                if (Intrinsics.areEqual((Object)tradeSession.getTrader2UUID(), (Object)player.getUUID())) {
                    tradeSession.deny();
                }
            } else if (StringsKt.equals((String)response, (String)"accept", (boolean)true) && Intrinsics.areEqual((Object)tradeSession.getTrader2UUID(), (Object)player.getUUID())) {
                tradeSession.accept();
            }
        }
        return 1;
    }

    private static final boolean register$lambda$0(CommandSourceStack src) {
        return CobblemonExtrasPermissions.Companion.checkPermission(src, CobblemonExtras.INSTANCE.getPermissions().getPOKETRADE_PERMISSION());
    }

    private static final int register$lambda$1(PokeTrade this$0, CommandContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        return this$0.respond((CommandContext<CommandSourceStack>)ctx);
    }

    private static final boolean register$lambda$2(CommandSourceStack src) {
        return CobblemonExtrasPermissions.Companion.checkPermission(src, CobblemonExtras.INSTANCE.getPermissions().getPOKETRADE_PERMISSION());
    }

    private static final int register$lambda$3(PokeTrade this$0, CommandContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        return this$0.respond((CommandContext<CommandSourceStack>)ctx);
    }

    private static final boolean register$lambda$4(CommandSourceStack src) {
        return CobblemonExtrasPermissions.Companion.checkPermission(src, CobblemonExtras.INSTANCE.getPermissions().getPOKETRADE_PERMISSION());
    }

    private static final int register$lambda$5(PokeTrade this$0, CommandContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        return this$0.respond((CommandContext<CommandSourceStack>)ctx);
    }

    private static final boolean register$lambda$6(CommandSourceStack src) {
        return CobblemonExtrasPermissions.Companion.checkPermission(src, CobblemonExtras.INSTANCE.getPermissions().getPOKETRADE_PERMISSION());
    }

    private static final int register$lambda$7(PokeTrade this$0, CommandContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        return this$0.createTrade((CommandContext<CommandSourceStack>)ctx);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\n\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\tJ\r\u0010\u000b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u000b\u0010\tJ\r\u0010\f\u001a\u00020\u0007\u00a2\u0006\u0004\b\f\u0010\tJ\r\u0010\r\u001a\u00020\u0007\u00a2\u0006\u0004\b\r\u0010\tR\"\u0010\u0003\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\"\u0010\u0004\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0004\u0010\u000e\u001a\u0004\b\u0013\u0010\u0010\"\u0004\b\u0014\u0010\u0012R\"\u0010\u0016\u001a\u00020\u00158\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\"\u0010\u001d\u001a\u00020\u001c8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\"\u0010#\u001a\u00020\u00158\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b#\u0010\u0017\u001a\u0004\b$\u0010\u0019\"\u0004\b%\u0010\u001bR\"\u0010&\u001a\u00020\u001c8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b&\u0010\u001e\u001a\u0004\b'\u0010 \"\u0004\b(\u0010\"R$\u0010*\u001a\u0004\u0018\u00010)8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b*\u0010+\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R$\u00100\u001a\u0004\u0018\u00010)8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b0\u0010+\u001a\u0004\b1\u0010-\"\u0004\b2\u0010/R\"\u00104\u001a\u0002038\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b4\u00105\u001a\u0004\b6\u00107\"\u0004\b8\u00109R\"\u0010:\u001a\u00020\u001c8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b:\u0010\u001e\u001a\u0004\b;\u0010 \"\u0004\b<\u0010\"\u00a8\u0006="}, d2={"Ldev/chasem/cobblemonextras/commands/PokeTrade$TradeSession;", "", "Lnet/minecraft/server/level/ServerPlayer;", "trader1", "trader2", "<init>", "(Ldev/chasem/cobblemonextras/commands/PokeTrade;Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/server/level/ServerPlayer;)V", "", "cancel", "()V", "deny", "expire", "accept", "doTrade", "Lnet/minecraft/server/level/ServerPlayer;", "getTrader1", "()Lnet/minecraft/server/level/ServerPlayer;", "setTrader1", "(Lnet/minecraft/server/level/ServerPlayer;)V", "getTrader2", "setTrader2", "Ljava/util/UUID;", "trader1UUID", "Ljava/util/UUID;", "getTrader1UUID", "()Ljava/util/UUID;", "setTrader1UUID", "(Ljava/util/UUID;)V", "", "trader1Accept", "Z", "getTrader1Accept", "()Z", "setTrader1Accept", "(Z)V", "trader2UUID", "getTrader2UUID", "setTrader2UUID", "trader2Accept", "getTrader2Accept", "setTrader2Accept", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "trader1Pokemon", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "getTrader1Pokemon", "()Lcom/cobblemon/mod/common/pokemon/Pokemon;", "setTrader1Pokemon", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;)V", "trader2Pokemon", "getTrader2Pokemon", "setTrader2Pokemon", "", "timestamp", "J", "getTimestamp", "()J", "setTimestamp", "(J)V", "cancelled", "getCancelled", "setCancelled", "common"})
    public final class TradeSession {
        @NotNull
        private ServerPlayer trader1;
        @NotNull
        private ServerPlayer trader2;
        @NotNull
        private UUID trader1UUID;
        private boolean trader1Accept;
        @NotNull
        private UUID trader2UUID;
        private boolean trader2Accept;
        @Nullable
        private Pokemon trader1Pokemon;
        @Nullable
        private Pokemon trader2Pokemon;
        private long timestamp;
        private boolean cancelled;

        public TradeSession(@NotNull ServerPlayer trader1, ServerPlayer trader2) {
            Intrinsics.checkNotNullParameter((Object)trader1, (String)"trader1");
            Intrinsics.checkNotNullParameter((Object)trader2, (String)"trader2");
            this.trader1 = trader1;
            this.trader2 = trader2;
            UUID uUID = this.trader1.getUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
            this.trader1UUID = uUID;
            UUID uUID2 = this.trader2.getUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"getUUID(...)");
            this.trader2UUID = uUID2;
            this.timestamp = System.currentTimeMillis();
        }

        @NotNull
        public final ServerPlayer getTrader1() {
            return this.trader1;
        }

        public final void setTrader1(@NotNull ServerPlayer serverPlayer) {
            Intrinsics.checkNotNullParameter((Object)serverPlayer, (String)"<set-?>");
            this.trader1 = serverPlayer;
        }

        @NotNull
        public final ServerPlayer getTrader2() {
            return this.trader2;
        }

        public final void setTrader2(@NotNull ServerPlayer serverPlayer) {
            Intrinsics.checkNotNullParameter((Object)serverPlayer, (String)"<set-?>");
            this.trader2 = serverPlayer;
        }

        @NotNull
        public final UUID getTrader1UUID() {
            return this.trader1UUID;
        }

        public final void setTrader1UUID(@NotNull UUID uUID) {
            Intrinsics.checkNotNullParameter((Object)uUID, (String)"<set-?>");
            this.trader1UUID = uUID;
        }

        public final boolean getTrader1Accept() {
            return this.trader1Accept;
        }

        public final void setTrader1Accept(boolean bl) {
            this.trader1Accept = bl;
        }

        @NotNull
        public final UUID getTrader2UUID() {
            return this.trader2UUID;
        }

        public final void setTrader2UUID(@NotNull UUID uUID) {
            Intrinsics.checkNotNullParameter((Object)uUID, (String)"<set-?>");
            this.trader2UUID = uUID;
        }

        public final boolean getTrader2Accept() {
            return this.trader2Accept;
        }

        public final void setTrader2Accept(boolean bl) {
            this.trader2Accept = bl;
        }

        @Nullable
        public final Pokemon getTrader1Pokemon() {
            return this.trader1Pokemon;
        }

        public final void setTrader1Pokemon(@Nullable Pokemon pokemon) {
            this.trader1Pokemon = pokemon;
        }

        @Nullable
        public final Pokemon getTrader2Pokemon() {
            return this.trader2Pokemon;
        }

        public final void setTrader2Pokemon(@Nullable Pokemon pokemon) {
            this.trader2Pokemon = pokemon;
        }

        public final long getTimestamp() {
            return this.timestamp;
        }

        public final void setTimestamp(long l) {
            this.timestamp = l;
        }

        public final boolean getCancelled() {
            return this.cancelled;
        }

        public final void setCancelled(boolean bl) {
            this.cancelled = bl;
        }

        public final void cancel() {
            this.trader1.sendSystemMessage((Component)Component.literal((String)"Trade cancelled.").withStyle(ChatFormatting.RED));
            this.trader2.sendSystemMessage((Component)Component.literal((String)"Trade cancelled.").withStyle(ChatFormatting.RED));
            PokeTrade.this.getTradeSessions().remove(this.trader1UUID);
            PokeTrade.this.getTradeSessions().remove(this.trader2UUID);
            this.cancelled = true;
        }

        public final void deny() {
            this.trader1.sendSystemMessage((Component)Component.literal((String)"Trade declined.").withStyle(ChatFormatting.RED));
            this.trader2.sendSystemMessage((Component)Component.literal((String)"Trade declined.").withStyle(ChatFormatting.RED));
            PokeTrade.this.getTradeSessions().remove(this.trader1UUID);
            PokeTrade.this.getTradeSessions().remove(this.trader2UUID);
            this.cancelled = true;
        }

        public final void expire() {
            this.trader1.sendSystemMessage((Component)Component.literal((String)"Trade request expired.").withStyle(ChatFormatting.RED));
            this.trader2.sendSystemMessage((Component)Component.literal((String)"Trade request expired.").withStyle(ChatFormatting.RED));
            PokeTrade.this.getTradeSessions().remove(this.trader1UUID);
            PokeTrade.this.getTradeSessions().remove(this.trader2UUID);
            this.cancelled = true;
        }

        public final void accept() {
            PokeTradeMenu tradeMenu = new PokeTradeMenu(this);
            this.trader1.openMenu((MenuProvider)tradeMenu);
            this.trader2.openMenu((MenuProvider)tradeMenu);
        }

        public final void doTrade() {
            if (this.cancelled) {
                System.out.println((Object)"Something funky is goin' on");
                this.cancel();
                return;
            }
            this.cancelled = true;
            PlayerPartyStore party1 = Cobblemon.INSTANCE.getStorage().getParty(this.trader1);
            PlayerPartyStore party2 = Cobblemon.INSTANCE.getStorage().getParty(this.trader2);
            if (this.trader1Pokemon != null) {
                Pokemon pokemon = this.trader1Pokemon;
                Intrinsics.checkNotNull((Object)pokemon);
                party1.remove(pokemon);
            }
            if (this.trader2Pokemon != null) {
                Pokemon pokemon = this.trader2Pokemon;
                Intrinsics.checkNotNull((Object)pokemon);
                party2.remove(pokemon);
            }
            if (this.trader1Pokemon != null) {
                Pokemon pokemon = this.trader1Pokemon;
                Intrinsics.checkNotNull((Object)pokemon);
                party2.add(pokemon);
                Pokemon pokemon2 = this.trader1Pokemon;
                Intrinsics.checkNotNull((Object)pokemon2);
                pokemon2.getEvolutions().forEach(arg_0 -> TradeSession.doTrade$lambda$0(this, arg_0));
            }
            if (this.trader2Pokemon != null) {
                Pokemon pokemon = this.trader2Pokemon;
                Intrinsics.checkNotNull((Object)pokemon);
                party1.add(pokemon);
                Pokemon pokemon3 = this.trader2Pokemon;
                Intrinsics.checkNotNull((Object)pokemon3);
                pokemon3.getEvolutions().forEach(arg_0 -> TradeSession.doTrade$lambda$1(this, arg_0));
            }
            MutableComponent toSend = Component.literal((String)"Trade complete!").withStyle(ChatFormatting.GREEN);
            this.trader1.sendSystemMessage((Component)toSend);
            this.trader2.sendSystemMessage((Component)toSend);
            PokeTrade.this.getTradeSessions().remove(this.trader1UUID);
            PokeTrade.this.getTradeSessions().remove(this.trader2UUID);
        }

        private static final void doTrade$lambda$0(TradeSession this$0, Evolution evolution) {
            Intrinsics.checkNotNullParameter((Object)evolution, (String)"evolution");
            if (evolution instanceof TradeEvolution) {
                Pokemon pokemon = this$0.trader1Pokemon;
                Intrinsics.checkNotNull((Object)pokemon);
                evolution.evolve(pokemon);
            }
        }

        private static final void doTrade$lambda$1(TradeSession this$0, Evolution evolution) {
            Intrinsics.checkNotNullParameter((Object)evolution, (String)"evolution");
            if (evolution instanceof TradeEvolution) {
                Pokemon pokemon = this$0.trader2Pokemon;
                Intrinsics.checkNotNull((Object)pokemon);
                evolution.evolve(pokemon);
            }
        }
    }
}

