/*
 * Decompiled with CFR 0.152.
 */
package dev.chasem.cobblemonextras.util;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Unit;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.CustomModelData;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0011\u0018\u00002\u00020\u0001B\u0013\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0013\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0004\u0010\u0007J\u001d\u0010\u000b\u001a\u00020\u00002\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0015\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0015\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\r\u00a2\u0006\u0004\b\u0016\u0010\u0010J\r\u0010\u0017\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u001a\u001a\u00020\u00002\b\u0010\u0019\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\r\u0010\u001c\u001a\u00020\u0006\u00a2\u0006\u0004\b\u001c\u0010\u001dR$\u0010\u001e\u001a\u0004\u0018\u00010\u00068\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010\u001d\"\u0004\b!\u0010\u0007\u00a8\u0006\""}, d2={"Ldev/chasem/cobblemonextras/util/ItemBuilder;", "", "Lnet/minecraft/world/item/Item;", "item", "<init>", "(Lnet/minecraft/world/item/Item;)V", "Lnet/minecraft/world/item/ItemStack;", "(Lnet/minecraft/world/item/ItemStack;)V", "", "Lnet/minecraft/network/chat/Component;", "newLore", "addLore", "([Lnet/minecraft/network/chat/Component;)Ldev/chasem/cobblemonextras/util/ItemBuilder;", "", "customModelVal", "setCustomModel", "(I)Ldev/chasem/cobblemonextras/util/ItemBuilder;", "Lnet/minecraft/world/item/component/CustomData;", "data", "setCustomData", "(Lnet/minecraft/world/item/component/CustomData;)Ldev/chasem/cobblemonextras/util/ItemBuilder;", "amount", "setAmount", "hideAdditional", "()Ldev/chasem/cobblemonextras/util/ItemBuilder;", "customName", "setCustomName", "(Lnet/minecraft/network/chat/Component;)Ldev/chasem/cobblemonextras/util/ItemBuilder;", "build", "()Lnet/minecraft/world/item/ItemStack;", "stack", "Lnet/minecraft/world/item/ItemStack;", "getStack", "setStack", "common"})
@SourceDebugExtension(value={"SMAP\nItemBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ItemBuilder.kt\ndev/chasem/cobblemonextras/util/ItemBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,86:1\n1869#2,2:87\n*S KotlinDebug\n*F\n+ 1 ItemBuilder.kt\ndev/chasem/cobblemonextras/util/ItemBuilder\n*L\n57#1:87,2\n*E\n"})
public final class ItemBuilder {
    @Nullable
    private ItemStack stack;

    @Nullable
    public final ItemStack getStack() {
        return this.stack;
    }

    public final void setStack(@Nullable ItemStack itemStack) {
        this.stack = itemStack;
    }

    public ItemBuilder(@Nullable Item item) {
        this.stack = new ItemStack((ItemLike)item);
    }

    public ItemBuilder(@Nullable ItemStack item) {
        this.stack = item;
    }

    @NotNull
    public final ItemBuilder addLore(@Nullable Component[] newLore) {
        ItemStack itemStack = this.stack;
        Intrinsics.checkNotNull((Object)itemStack);
        ItemLore itemLore = (ItemLore)itemStack.get(DataComponents.LORE);
        if (itemLore == null) {
            itemLore = new ItemLore(CollectionsKt.emptyList());
        }
        List list = Stream.concat(itemLore.lines().stream(), Arrays.stream(newLore)).collect(Collectors.toList());
        list = list.stream().map(arg_0 -> ItemBuilder.addLore$lambda$1(ItemBuilder::addLore$lambda$0, arg_0)).collect(Collectors.toList());
        itemLore = new ItemLore(list);
        ItemStack itemStack2 = this.stack;
        Intrinsics.checkNotNull((Object)itemStack2);
        itemStack2.set(DataComponents.LORE, (Object)itemLore);
        return this;
    }

    @NotNull
    public final ItemBuilder setCustomModel(int customModelVal) {
        ItemStack itemStack = this.stack;
        Intrinsics.checkNotNull((Object)itemStack);
        itemStack.set(DataComponents.CUSTOM_MODEL_DATA, (Object)new CustomModelData(customModelVal));
        return this;
    }

    @NotNull
    public final ItemBuilder setCustomData(@NotNull CustomData data) {
        CustomData customData;
        CustomData customData2;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        ItemStack itemStack = this.stack;
        Intrinsics.checkNotNull((Object)itemStack);
        if (itemStack.has(DataComponents.CUSTOM_DATA)) {
            ItemStack itemStack2 = this.stack;
            Intrinsics.checkNotNull((Object)itemStack2);
            customData2 = (CustomData)itemStack2.get(DataComponents.CUSTOM_DATA);
        } else {
            customData2 = CustomData.of((CompoundTag)new CompoundTag());
        }
        CustomData customData3 = customData = customData2;
        Intrinsics.checkNotNull((Object)customData3);
        CompoundTag newTag = customData3.copyTag();
        CompoundTag tag = data.copyTag();
        Set set = tag.getAllKeys();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getAllKeys(...)");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String key = (String)element$iv;
            boolean bl = false;
            newTag.put(key, tag.get(key));
        }
        ItemStack itemStack3 = this.stack;
        Intrinsics.checkNotNull((Object)itemStack3);
        itemStack3.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)newTag));
        return this;
    }

    @NotNull
    public final ItemBuilder setAmount(int amount) {
        ItemStack itemStack = this.stack;
        Intrinsics.checkNotNull((Object)itemStack);
        itemStack.setCount(amount);
        return this;
    }

    @NotNull
    public final ItemBuilder hideAdditional() {
        ItemStack itemStack = this.stack;
        Intrinsics.checkNotNull((Object)itemStack);
        itemStack.set(DataComponents.HIDE_ADDITIONAL_TOOLTIP, (Object)Unit.INSTANCE);
        return this;
    }

    @NotNull
    public final ItemBuilder setCustomName(@Nullable Component customName) {
        ItemStack itemStack = this.stack;
        Intrinsics.checkNotNull((Object)itemStack);
        itemStack.set(DataComponents.CUSTOM_NAME, (Object)customName);
        return this;
    }

    @NotNull
    public final ItemStack build() {
        ItemStack itemStack = this.stack;
        Intrinsics.checkNotNull((Object)itemStack);
        return itemStack;
    }

    private static final MutableComponent addLore$lambda$0(Component component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        return component.copy().withStyle(component.getStyle().withItalic(Boolean.valueOf(false)));
    }

    private static final MutableComponent addLore$lambda$1(Function1 $tmp0, Object p0) {
        return (MutableComponent)$tmp0.invoke(p0);
    }
}

