/*
 * Decompiled with CFR 0.152.
 */
package dev.proststuff.archeries.entity;

import dev.proststuff.archeries.registry.ModEntities;
import dev.proststuff.archeries.registry.ModItems;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TracerArrow
extends AbstractArrow {
    public TracerArrow(EntityType<? extends AbstractArrow> entityType, Level level) {
        super(entityType, level);
        this.setRemainingFireTicks(1200);
    }

    protected TracerArrow(Level level, double x, double y, double z, ItemStack pickupItemStack, @Nullable ItemStack firedFromWeapon) {
        super(ModEntities.REGISTERED.get("tracer_arrow"), x, y, z, level, pickupItemStack, firedFromWeapon);
        this.setRemainingFireTicks(1200);
    }

    protected TracerArrow(Level level, LivingEntity owner, ItemStack pickupItemStack, @Nullable ItemStack firedFromWeapon) {
        super(ModEntities.REGISTERED.get("tracer_arrow"), owner, level, pickupItemStack, firedFromWeapon);
        this.setRemainingFireTicks(1200);
    }

    public static TracerArrow withPos(Level level, double x, double y, double z, ItemStack pickupItemStack, @Nullable ItemStack firedFromWeapon) {
        return new TracerArrow(level, x, y, z, pickupItemStack, firedFromWeapon);
    }

    public static TracerArrow withOwner(Level level, LivingEntity owner, ItemStack pickupItemStack, @Nullable ItemStack firedFromWeapon) {
        return new TracerArrow(level, owner, pickupItemStack, firedFromWeapon);
    }

    @NotNull
    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)ModItems.REGISTERED.get("tracer_arrow"));
    }

    public void tick() {
        super.tick();
        Level level = this.level();
        RandomSource random = this.level().getRandom();
        for (int i = 0; i < 4; ++i) {
            double offsetX = (double)random.nextInt(-25, 25) / 100.0;
            double offsetY = (double)random.nextInt(-25, 25) / 100.0;
            double offsetZ = (double)random.nextInt(-25, 25) / 100.0;
            level.addParticle((ParticleOptions)ParticleTypes.GLOW, this.getX() + offsetX, this.getY() + offsetY, this.getZ() + offsetZ, 0.0, 0.0, 0.0);
        }
    }
}

