/*
 * Decompiled with CFR 0.152.
 */
package dev.proststuff.archeries.events;

import dev.proststuff.archeries.NeoForgeArcheries;
import dev.proststuff.archeries.client.CopperArrowRenderer;
import dev.proststuff.archeries.client.ExplosiveArrowRenderer;
import dev.proststuff.archeries.client.SoftArrowRenderer;
import dev.proststuff.archeries.client.TracerArrowRenderer;
import dev.proststuff.archeries.function.ItemPropertiesRegisterFunctions;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;

@EventBusSubscriber(modid="archeries", value={Dist.CLIENT})
public class ClientModEvents {
    @SubscribeEvent
    public static void registerModel(FMLClientSetupEvent event) {
        event.enqueueWork(() -> NeoForgeArcheries.REGISTERED_ITEMS.forEach((id, deferredItem) -> {
            if (id.endsWith("bow")) {
                Item item = (Item)deferredItem.get();
                ItemProperties.register((Item)item, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"pull"), (stack, world, entity, seed) -> ItemPropertiesRegisterFunctions.pull(id, stack, world, entity, seed));
                ItemProperties.register((Item)item, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"pulling"), ItemPropertiesRegisterFunctions::pulling);
                if (id.endsWith("crossbow")) {
                    ItemProperties.register((Item)item, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"charged"), ItemPropertiesRegisterFunctions::crossbowCharged);
                    ItemProperties.register((Item)item, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"firework"), ItemPropertiesRegisterFunctions::crossbowFirework);
                }
            }
        }));
    }

    @SubscribeEvent
    public static void init(EntityRenderersEvent.RegisterRenderers event) {
        EntityType explosiveArrow = (EntityType)NeoForgeArcheries.REGISTERED_ENTITY_TYPES.get("explosive_arrow").get();
        event.registerEntityRenderer(explosiveArrow, ExplosiveArrowRenderer::new);
        EntityType copperArrow = (EntityType)NeoForgeArcheries.REGISTERED_ENTITY_TYPES.get("copper_arrow").get();
        event.registerEntityRenderer(copperArrow, CopperArrowRenderer::new);
        EntityType softArrow = (EntityType)NeoForgeArcheries.REGISTERED_ENTITY_TYPES.get("soft_arrow").get();
        event.registerEntityRenderer(softArrow, SoftArrowRenderer::new);
        EntityType tracerArrow = (EntityType)NeoForgeArcheries.REGISTERED_ENTITY_TYPES.get("tracer_arrow").get();
        event.registerEntityRenderer(tracerArrow, TracerArrowRenderer::new);
    }
}

