/*
 * Decompiled with CFR 0.152.
 */
package dev.proststuff.archeries;

import dev.proststuff.archeries.Archeries;
import dev.proststuff.archeries.registry.ModEntities;
import dev.proststuff.archeries.registry.ModItems;
import java.util.LinkedHashMap;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

@Mod(value="archeries")
public class NeoForgeArcheries {
    private static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"archeries");
    private static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((Registry)BuiltInRegistries.CREATIVE_MODE_TAB, (String)"archeries");
    private static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.ENTITY_TYPE, (String)"archeries");
    public static final LinkedHashMap<String, DeferredItem<Item>> REGISTERED_ITEMS = new LinkedHashMap();
    public static final LinkedHashMap<String, DeferredHolder<EntityType<?>, EntityType<?>>> REGISTERED_ENTITY_TYPES = new LinkedHashMap();

    public NeoForgeArcheries(IEventBus eventBus, ModContainer container) {
        Archeries.log("NeoForge Archeries starting", new Object[0]);
        Archeries.init();
        ModItems.registerAll((id, itemSupplier) -> {
            Archeries.log("Registering {}", id);
            REGISTERED_ITEMS.put(id.getPath(), (DeferredItem<Item>)ITEMS.register(id.getPath(), itemSupplier));
        });
        CREATIVE_MODE_TABS.register("archeries_tab", ModItems.CREATIVE_MODE_TAB_SUPPLIER);
        ModEntities.registerAll((id, entityTypeSupplier) -> {
            Archeries.log("Registering {}", id);
            REGISTERED_ENTITY_TYPES.put(id.getPath(), ENTITY_TYPES.register(id.getPath(), entityTypeSupplier));
        });
        ITEMS.register(eventBus);
        CREATIVE_MODE_TABS.register(eventBus);
        ENTITY_TYPES.register(eventBus);
        eventBus.addListener(event -> {
            REGISTERED_ITEMS.forEach((id, holder) -> ModItems.REGISTERED.put((String)id, (Item)holder.get()));
            REGISTERED_ENTITY_TYPES.forEach((id, holder) -> ModEntities.REGISTERED.put((String)id, (EntityType<?>)((EntityType)holder.get())));
        });
        Archeries.log("NeoForge Archeries finished", new Object[0]);
    }
}

