/*
 * Decompiled with CFR 0.152.
 */
package dev.proststuff.archeries.entity;

import dev.proststuff.archeries.registry.ModEntities;
import dev.proststuff.archeries.registry.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopperArrow
extends AbstractArrow {
    public static int DEFAULT_INITIAL_DELAY = 15;
    public static int DEFAULT_FUSE_TICK = 20;
    public static int MAX_STRIKES = 4;
    public boolean ability_active = false;
    private int initial_delay = DEFAULT_INITIAL_DELAY;
    private int fuse_tick = -1;
    private int strikes = 0;

    public CopperArrow(EntityType<? extends AbstractArrow> entityType, Level level) {
        super(entityType, level);
        this.setBaseDamage(1.5);
    }

    protected CopperArrow(Level level, double x, double y, double z, ItemStack pickupItemStack, @Nullable ItemStack firedFromWeapon) {
        super(ModEntities.REGISTERED.get("copper_arrow"), x, y, z, level, pickupItemStack, firedFromWeapon);
        this.setBaseDamage(1.5);
    }

    protected CopperArrow(Level level, LivingEntity owner, ItemStack pickupItemStack, @Nullable ItemStack firedFromWeapon) {
        super(ModEntities.REGISTERED.get("copper_arrow"), owner, level, pickupItemStack, firedFromWeapon);
        this.setBaseDamage(1.5);
    }

    public static CopperArrow withPos(Level level, double x, double y, double z, ItemStack pickupItemStack, @Nullable ItemStack firedFromWeapon) {
        return new CopperArrow(level, x, y, z, pickupItemStack, firedFromWeapon);
    }

    public static CopperArrow withOwner(Level level, LivingEntity owner, ItemStack pickupItemStack, @Nullable ItemStack firedFromWeapon) {
        return new CopperArrow(level, owner, pickupItemStack, firedFromWeapon);
    }

    @NotNull
    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)ModItems.REGISTERED.get("copper_arrow"));
    }

    public void tick() {
        block9: {
            RandomSource random;
            Level level;
            block8: {
                super.tick();
                level = this.level();
                random = this.level().getRandom();
                if (this.fuse_tick > 0 && this.initial_delay == 0) {
                    --this.fuse_tick;
                    if (this.fuse_tick == DEFAULT_FUSE_TICK / 2) {
                        this.playSound(SoundEvents.ALLAY_DEATH, 0.75f, 0.75f / (this.random.nextFloat() * 0.2f + 0.9f));
                    }
                    if (this.fuse_tick == 0 && this.strikes < MAX_STRIKES) {
                        ++this.strikes;
                        if (this.strikeOfZeus(this.isCritArrow() ? 0.2 : 0.0)) {
                            this.fuse_tick = DEFAULT_FUSE_TICK / 2;
                        }
                        if (level.isClientSide()) {
                            level.addParticle((ParticleOptions)ParticleTypes.FLASH, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
                        }
                    }
                }
                if (this.initial_delay <= 0) break block8;
                --this.initial_delay;
                if (this.initial_delay != 0) break block9;
                boolean success = this.strikeOfZeus(this.isCritArrow() ? 0.4 : 0.0);
                if (success) {
                    this.playSound(SoundEvents.TRIDENT_RETURN, 1.0f, 0.75f / (this.random.nextFloat() * 0.2f + 0.9f));
                }
                this.setCritArrow(success);
                this.ability_active = success;
                if (!level.isClientSide()) break block9;
                level.addParticle((ParticleOptions)ParticleTypes.FLASH, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
                break block9;
            }
            if (this.tickCount % 4 == 0 && level.isClientSide()) {
                for (int i = 0; i < 4; ++i) {
                    double offsetX = (double)random.nextInt(-25, 25) / 50.0;
                    double offsetY = (double)random.nextInt(-25, 25) / 50.0;
                    double offsetZ = (double)random.nextInt(-25, 25) / 50.0;
                    level.addParticle((ParticleOptions)ParticleTypes.ELECTRIC_SPARK, this.getX() + offsetX, this.getY() + offsetY, this.getZ() + offsetZ, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    protected void doPostHurtEffects(@NotNull LivingEntity target) {
        super.doPostHurtEffects(target);
        Level level = this.level();
        boolean success = this.strikeOfZeus(this.isCritArrow() ? 0.2 : 0.0);
        if (success && !level.isClientSide() && level.isThundering()) {
            level.explode(this.getOwner(), this.getX(), this.getY(), this.getZ(), 4.0f, Level.ExplosionInteraction.TNT);
            this.discard();
        }
    }

    protected void onHitBlock(@NotNull BlockHitResult result) {
        super.onHitBlock(result);
        this.fuse_tick = DEFAULT_FUSE_TICK;
    }

    public void addAdditionalSaveData(@NotNull CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("active", this.ability_active);
        compound.putInt("delay", this.initial_delay);
        compound.putInt("fuse", this.fuse_tick);
        compound.putInt("strikes", this.strikes);
    }

    public void readAdditionalSaveData(@NotNull CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.ability_active = compound.getBoolean("active");
        this.initial_delay = compound.getInt("delay");
        this.fuse_tick = compound.getInt("fuse");
        this.strikes = compound.getInt("strikes");
    }

    private boolean strikeOfZeus(double additionalChance) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            RandomSource random = serverLevel.getRandom();
            BlockPos pos = this.getOnPos();
            boolean raining = serverLevel.isRainingAt(pos);
            double chance = 0.0;
            if (raining) {
                chance += 0.25;
            }
            if (serverLevel.isThundering()) {
                chance += 0.25;
            }
            if (random.nextDouble() < chance + additionalChance) {
                EntityType.LIGHTNING_BOLT.spawn(serverLevel, this.getOnPos(), MobSpawnType.TRIGGERED);
                return true;
            }
        }
        return false;
    }
}

