/*
 * Decompiled with CFR 0.152.
 */
package dev.proststuff.archeries.events;

import dev.proststuff.archeries.NeoForgeArcheries;
import dev.proststuff.archeries.client.CopperArrowRenderer;
import dev.proststuff.archeries.client.EchoingArrowRenderer;
import dev.proststuff.archeries.client.ExplosiveArrowRenderer;
import dev.proststuff.archeries.client.SoftArrowRenderer;
import dev.proststuff.archeries.client.TracerArrowRenderer;
import dev.proststuff.archeries.shared.SharedHelper;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;

@EventBusSubscriber(modid="archeries", value={Dist.CLIENT})
public class ClientModEvents {
    @SubscribeEvent
    public static void registerModel(FMLClientSetupEvent event) {
        event.enqueueWork(() -> NeoForgeArcheries.REGISTERED_ITEMS.forEach((id, deferredItem) -> {
            if (id.endsWith("bow")) {
                Item item = (Item)deferredItem.get();
                ItemProperties.register((Item)item, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"pull"), (stack, world, entity, seed) -> SharedHelper.pull(id, stack, world, entity, seed));
                ItemProperties.register((Item)item, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"pulling"), SharedHelper::pulling);
                if (id.endsWith("crossbow")) {
                    ItemProperties.register((Item)item, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"charged"), SharedHelper::crossbowCharged);
                    ItemProperties.register((Item)item, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"firework"), SharedHelper::crossbowFirework);
                }
            }
        }));
    }

    @SubscribeEvent
    public static void init(EntityRenderersEvent.RegisterRenderers event) {
        EntityType explosiveArrow = (EntityType)NeoForgeArcheries.REGISTERED_ENTITY_TYPES.get("explosive_arrow").get();
        event.registerEntityRenderer(explosiveArrow, ExplosiveArrowRenderer::new);
        EntityType copperArrow = (EntityType)NeoForgeArcheries.REGISTERED_ENTITY_TYPES.get("copper_arrow").get();
        event.registerEntityRenderer(copperArrow, CopperArrowRenderer::new);
        EntityType softArrow = (EntityType)NeoForgeArcheries.REGISTERED_ENTITY_TYPES.get("soft_arrow").get();
        event.registerEntityRenderer(softArrow, SoftArrowRenderer::new);
        EntityType tracerArrow = (EntityType)NeoForgeArcheries.REGISTERED_ENTITY_TYPES.get("tracer_arrow").get();
        event.registerEntityRenderer(tracerArrow, TracerArrowRenderer::new);
        EntityType echoingArrow = (EntityType)NeoForgeArcheries.REGISTERED_ENTITY_TYPES.get("echoing_arrow").get();
        event.registerEntityRenderer(echoingArrow, EchoingArrowRenderer::new);
    }
}

