/*
 * Decompiled with CFR 0.152.
 */
package dev.proststuff.archeries.item.arrow;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;

public class ModdedArrowItem
extends ArrowItem {
    private float baseDamage;

    public ModdedArrowItem(Item.Properties properties, float baseDamage) {
        super(properties);
        this.baseDamage = baseDamage;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        tooltipComponents.add(ModdedArrowItem.append("tooltip.archeries.arrow.damage", this.baseDamage, 2.0f, false));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    private static Component append(String translationKey, float value, float base, boolean lowerIsBetter) {
        float diff = value - base;
        String prefix = diff + value > base ? "+" : "-";
        double val1 = Double.parseDouble(String.format("%.2f", Float.valueOf(value)));
        double val2 = Double.parseDouble(String.format("%.2f", Float.valueOf(Mth.abs((float)diff))));
        return Component.translatable((String)translationKey, (Object[])new Object[]{val1, String.format("%s%s", prefix, val2)}).withStyle(ModdedArrowItem.determineColor(value, base, lowerIsBetter));
    }

    private static ChatFormatting determineColor(float val, float base, boolean lowerIsBetter) {
        if (val < base) {
            return lowerIsBetter ? ChatFormatting.GREEN : ChatFormatting.RED;
        }
        if (val > base) {
            return lowerIsBetter ? ChatFormatting.RED : ChatFormatting.GREEN;
        }
        return ChatFormatting.GRAY;
    }
}

