/*
 * Decompiled with CFR 0.152.
 */
package dev.proststuff.archeries.item.bow;

import dev.proststuff.archeries.item.bow.TieredBowItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class VelocitasEradicoBow
extends TieredBowItem {
    public VelocitasEradicoBow(Item.Properties properties) {
        super(properties, 2560.0f, 0.0f, 512);
        this.maxDrawStrength = 1.0;
    }

    public void onUseTick(@NotNull Level level, @NotNull LivingEntity livingEntity, @NotNull ItemStack stack, int remainingUseDuration) {
        super.onUseTick(level, livingEntity, stack, remainingUseDuration);
        if (level.isClientSide()) {
            int i = this.getUseDuration(stack, livingEntity) - remainingUseDuration;
            float f = VelocitasEradicoBow.getPowerForTime(i, this.maxDrawDuration);
            RandomSource random = level.getRandom();
            int j = 0;
            while ((float)j < f * 4.0f) {
                double z;
                double y;
                double x;
                if (j % 4 == 0) {
                    x = (double)random.nextInt(-25, 25) / 50.0;
                    y = (double)random.nextInt(0, 25) / 12.5;
                    z = (double)random.nextInt(-25, 25) / 50.0;
                    level.addParticle((ParticleOptions)ParticleTypes.END_ROD, livingEntity.getX() + x, livingEntity.getY() + y, livingEntity.getZ() + z, 0.0, 0.0, 0.0);
                }
                if (j % 2 == 0) {
                    x = (double)random.nextInt(-25, 25) / 50.0;
                    y = (double)random.nextInt(0, 25) / 12.5;
                    z = (double)random.nextInt(-25, 25) / 50.0;
                    level.addParticle((ParticleOptions)ParticleTypes.ELECTRIC_SPARK, livingEntity.getX() + x, livingEntity.getY() + y, livingEntity.getZ() + z, 0.0, 0.0, 0.0);
                }
                if (f >= 1.0f) {
                    x = (double)random.nextInt(-25, 25) / 50.0;
                    y = (double)random.nextInt(0, 25) / 12.5;
                    z = (double)random.nextInt(-25, 25) / 50.0;
                    level.addParticle((ParticleOptions)ParticleTypes.CRIT, livingEntity.getX() + x, livingEntity.getY() + y, livingEntity.getZ() + z, 0.0, 0.0, 0.0);
                }
                ++j;
            }
        }
    }

    @Override
    public void releaseUsing(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity entityLiving, int timeLeft) {
        super.releaseUsing(stack, level, entityLiving, timeLeft);
        int i = this.getUseDuration(stack, entityLiving) - timeLeft;
        float f = VelocitasEradicoBow.getPowerForTime(i, this.maxDrawDuration);
        if (f >= 1.0f) {
            entityLiving.playSound(SoundEvents.ALLAY_DEATH, 1.0f, 0.75f);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                EntityType.LIGHTNING_BOLT.spawn(serverLevel, entityLiving.getOnPos(), MobSpawnType.TRIGGERED);
                level.explode((Entity)entityLiving, entityLiving.getX(), entityLiving.getY() + 0.5, entityLiving.getZ(), f * 8.0f, Level.ExplosionInteraction.TNT);
            }
        }
    }

    @Override
    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.archeries.bow.velocitas_eradico.1").withStyle(ChatFormatting.GRAY));
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.archeries.bow.velocitas_eradico.2").withStyle(ChatFormatting.DARK_RED));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }
}

