/*
 * Decompiled with CFR 0.152.
 */
package dev.proststuff.archeries.item.crossbow;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class TieredCrossbowItem
extends CrossbowItem {
    protected float velocity;
    protected float fireworkVelocity;
    protected float inaccuracy;

    public TieredCrossbowItem(Item.Properties properties, float velocity, float inaccuracy, float fireworkVelocity) {
        super(properties);
        this.velocity = velocity;
        this.inaccuracy = inaccuracy;
        this.fireworkVelocity = fireworkVelocity;
    }

    protected void shootProjectile(@NotNull LivingEntity shooter, @NotNull Projectile projectile, int index, float velocity, float inaccuracy, float angle, @Nullable LivingEntity target) {
        Vector3f vector3f;
        velocity = projectile instanceof FireworkRocketEntity ? this.fireworkVelocity : this.velocity;
        inaccuracy = this.inaccuracy;
        if (target != null) {
            double d0 = target.getX() - shooter.getX();
            double d1 = target.getZ() - shooter.getZ();
            double d2 = Math.sqrt(d0 * d0 + d1 * d1);
            double d3 = target.getY(0.3333333333333333) - projectile.getY() + d2 * (double)0.2f;
            vector3f = TieredCrossbowItem.getProjectileShotVector(shooter, new Vec3(d0, d3, d1), angle);
        } else {
            Vec3 vec3 = shooter.getUpVector(1.0f);
            Quaternionf quaternionf = new Quaternionf().setAngleAxis((double)(angle * ((float)Math.PI / 180)), vec3.x, vec3.y, vec3.z);
            Vec3 vec31 = shooter.getViewVector(1.0f);
            vector3f = vec31.toVector3f().rotate((Quaternionfc)quaternionf);
        }
        projectile.shoot((double)vector3f.x(), (double)vector3f.y(), (double)vector3f.z(), velocity, inaccuracy);
        float f = TieredCrossbowItem.getShotPitch(shooter.getRandom(), index);
        shooter.level().playSound(null, shooter.getX(), shooter.getY(), shooter.getZ(), SoundEvents.CROSSBOW_SHOOT, shooter.getSoundSource(), 1.0f, f);
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (tooltipFlag.isAdvanced()) {
            tooltipComponents.add(TieredCrossbowItem.append("tooltip.archeries.crossbow.arrow_velocity", this.velocity, 3.15f, false));
            tooltipComponents.add(TieredCrossbowItem.append("tooltip.archeries.crossbow.firework_velocity", this.fireworkVelocity, 1.6f, false));
            tooltipComponents.add(TieredCrossbowItem.append("tooltip.archeries.bow.inaccuracy", this.inaccuracy, 1.0f, true));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public int getDefaultProjectileRange() {
        return (int)((double)this.velocity / 3.15) * 8;
    }

    private static Component append(String translationKey, float value, float base, boolean lowerIsBetter) {
        float diff = value - base;
        String prefix = diff + value > base ? "+" : "-";
        double val1 = Double.parseDouble(String.format("%.2f", Float.valueOf(value)));
        double val2 = Double.parseDouble(String.format("%.2f", Float.valueOf(Mth.abs((float)diff))));
        return Component.translatable((String)translationKey, (Object[])new Object[]{val1, String.format("%s%s", prefix, val2)}).withStyle(TieredCrossbowItem.determineColor(value, base, lowerIsBetter));
    }

    private static ChatFormatting determineColor(float val, float base, boolean lowerIsBetter) {
        if (val < base) {
            return lowerIsBetter ? ChatFormatting.GREEN : ChatFormatting.RED;
        }
        if (val > base) {
            return lowerIsBetter ? ChatFormatting.RED : ChatFormatting.GREEN;
        }
        return ChatFormatting.GRAY;
    }

    private static Vector3f getProjectileShotVector(LivingEntity shooter, Vec3 distance, float angle) {
        Vector3f vector3f = distance.toVector3f().normalize();
        Vector3f vector3f1 = new Vector3f((Vector3fc)vector3f).cross((Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f));
        if ((double)vector3f1.lengthSquared() <= 1.0E-7) {
            Vec3 vec3 = shooter.getUpVector(1.0f);
            vector3f1 = new Vector3f((Vector3fc)vector3f).cross((Vector3fc)vec3.toVector3f());
        }
        Vector3f vector3f2 = new Vector3f((Vector3fc)vector3f).rotateAxis(1.5707964f, vector3f1.x, vector3f1.y, vector3f1.z);
        return new Vector3f((Vector3fc)vector3f).rotateAxis(angle * ((float)Math.PI / 180), vector3f2.x, vector3f2.y, vector3f2.z);
    }

    private static float getShotPitch(RandomSource random, int index) {
        return index == 0 ? 1.0f : TieredCrossbowItem.getRandomShotPitch((index & 1) == 1, random);
    }

    private static float getRandomShotPitch(boolean isHighPitched, RandomSource random) {
        float f = isHighPitched ? 0.63f : 0.43f;
        return 1.0f / (random.nextFloat() * 0.5f + 1.8f) + f;
    }
}

