/*
 * Decompiled with CFR 0.152.
 */
package dev.proststuff.archeries.registry;

import dev.proststuff.archeries.Archeries;
import dev.proststuff.archeries.entity.CopperArrow;
import dev.proststuff.archeries.entity.EchoingArrow;
import dev.proststuff.archeries.entity.ExplosiveArrow;
import dev.proststuff.archeries.entity.SoftArrow;
import dev.proststuff.archeries.entity.TracerArrow;
import java.util.LinkedHashMap;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;

public class ModEntities {
    private static final LinkedHashMap<ResourceLocation, Supplier<EntityType<?>>> entityMap = new LinkedHashMap();
    public static final LinkedHashMap<String, EntityType<?>> REGISTERED = new LinkedHashMap();
    public static final Supplier<EntityType<ExplosiveArrow>> EXPLOSIVE_ARROW = ModEntities.register("explosive_arrow", () -> EntityType.Builder.of(ExplosiveArrow::new, (MobCategory)MobCategory.MISC).sized(0.5f, 0.5f).clientTrackingRange(4).updateInterval(20).build("explosive_arrow"));
    public static final Supplier<EntityType<CopperArrow>> COPPER_ARROW = ModEntities.register("copper_arrow", () -> EntityType.Builder.of(CopperArrow::new, (MobCategory)MobCategory.MISC).sized(0.5f, 0.5f).clientTrackingRange(4).updateInterval(20).build("copper_arrow"));
    public static final Supplier<EntityType<SoftArrow>> SOFT_ARROW = ModEntities.register("soft_arrow", () -> EntityType.Builder.of(SoftArrow::new, (MobCategory)MobCategory.MISC).sized(0.5f, 0.5f).clientTrackingRange(4).updateInterval(20).build("soft_arrow"));
    public static final Supplier<EntityType<TracerArrow>> TRACER_ARROW = ModEntities.register("tracer_arrow", () -> EntityType.Builder.of(TracerArrow::new, (MobCategory)MobCategory.MISC).sized(0.5f, 0.5f).clientTrackingRange(4).updateInterval(20).build("tracer_arrow"));
    public static final Supplier<EntityType<EchoingArrow>> ECHOING_ARROW = ModEntities.register("echoing_arrow", () -> EntityType.Builder.of(EchoingArrow::new, (MobCategory)MobCategory.MISC).sized(0.5f, 0.5f).clientTrackingRange(4).updateInterval(20).build("echoing_arrow"));

    public static <T extends EntityType<?>> Supplier<T> register(String name, Supplier<T> itemSupplier) {
        ResourceLocation id = Archeries.id(name);
        entityMap.put(id, itemSupplier);
        return itemSupplier;
    }

    public static void registerAll(BiConsumer<ResourceLocation, Supplier<EntityType<?>>> reg) {
        entityMap.forEach(reg);
    }
}

