/*
 * Decompiled with CFR 0.152.
 */
package dev.proststuff.archeries;

import dev.proststuff.archeries.Archeries;
import dev.proststuff.archeries.registry.ModDataComponents;
import dev.proststuff.archeries.registry.ModEntities;
import dev.proststuff.archeries.registry.ModItems;
import java.util.LinkedHashMap;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

@Mod(value="archeries")
public class NeoForgeArcheries {
    private static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"archeries");
    private static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((Registry)BuiltInRegistries.CREATIVE_MODE_TAB, (String)"archeries");
    private static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.ENTITY_TYPE, (String)"archeries");
    private static final DeferredRegister.DataComponents DATA_COMPONENTS = DeferredRegister.createDataComponents((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)"archeries");
    public static final LinkedHashMap<Supplier<Item>, DeferredItem<Item>> REGISTERED_ITEMS = new LinkedHashMap();
    public static final LinkedHashMap<Supplier<EntityType<?>>, DeferredHolder<EntityType<?>, EntityType<?>>> REGISTERED_ENTITY_TYPES = new LinkedHashMap();
    public static final LinkedHashMap<Supplier<DataComponentType<?>>, DeferredHolder<DataComponentType<?>, DataComponentType<?>>> REGISTERED_DATA_COMPONENTS = new LinkedHashMap();

    public NeoForgeArcheries(IEventBus eventBus, ModContainer container) {
        Archeries.log("NeoForge Archeries starting", new Object[0]);
        Archeries.init();
        ModItems.registerAll((id, item) -> {
            Archeries.log("Registering Item {}", id);
            REGISTERED_ITEMS.put((Supplier<Item>)item, (DeferredItem<Item>)ITEMS.register(id.getPath(), item));
        });
        CREATIVE_MODE_TABS.register("archeries_tab", ModItems.CREATIVE_MODE_TAB_SUPPLIER);
        ModEntities.registerAll((id, entityTypeSupplier) -> {
            Archeries.log("Registering EntityType {}", id);
            REGISTERED_ENTITY_TYPES.put((Supplier<EntityType<?>>)entityTypeSupplier, (DeferredHolder<EntityType<?>, EntityType<?>>)ENTITY_TYPES.register(id.getPath(), entityTypeSupplier));
        });
        ModDataComponents.registerAll((id, sup) -> {
            Archeries.log("Registering DataComponent {}", id);
            REGISTERED_DATA_COMPONENTS.put((Supplier<DataComponentType<?>>)sup, (DeferredHolder<DataComponentType<?>, DataComponentType<?>>)DATA_COMPONENTS.register(id.getPath(), sup));
        });
        ITEMS.register(eventBus);
        CREATIVE_MODE_TABS.register(eventBus);
        ENTITY_TYPES.register(eventBus);
        DATA_COMPONENTS.register(eventBus);
        eventBus.addListener(event -> {
            Archeries.log("FMLLoadCompleteEvent", new Object[0]);
            REGISTERED_ITEMS.forEach((sup, holder) -> ModItems.REGISTERED.put((Supplier<Item>)sup, (Item)holder.get()));
            REGISTERED_ENTITY_TYPES.forEach((sup, holder) -> ModEntities.REGISTERED.put((Supplier<EntityType<?>>)sup, (EntityType<?>)((EntityType)holder.get())));
            REGISTERED_DATA_COMPONENTS.forEach((sup, holder) -> ModDataComponents.REGISTERED.put((Supplier<DataComponentType<?>>)sup, (DataComponentType<?>)((DataComponentType)holder.get())));
        });
        Archeries.log("NeoForge Archeries finished", new Object[0]);
    }
}

