/*
 * Decompiled with CFR 0.152.
 */
package dev.proststuff.archeries.entity;

import dev.proststuff.archeries.registry.ModEntities;
import dev.proststuff.archeries.registry.ModItems;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EchoingArrow
extends AbstractArrow {
    public EchoingArrow(EntityType<? extends AbstractArrow> entityType, Level level) {
        super(entityType, level);
        this.setBaseDamage(4.0);
    }

    protected EchoingArrow(Level level, double x, double y, double z, ItemStack pickupItemStack, @Nullable ItemStack firedFromWeapon) {
        super(ModEntities.get(ModEntities.ECHOING_ARROW), x, y, z, level, pickupItemStack, firedFromWeapon);
        this.setBaseDamage(4.0);
    }

    protected EchoingArrow(Level level, LivingEntity owner, ItemStack pickupItemStack, @Nullable ItemStack firedFromWeapon) {
        super(ModEntities.get(ModEntities.ECHOING_ARROW), owner, level, pickupItemStack, firedFromWeapon);
        this.setBaseDamage(4.0);
    }

    public static EchoingArrow withPos(Level level, double x, double y, double z, ItemStack pickupItemStack, @Nullable ItemStack firedFromWeapon) {
        return new EchoingArrow(level, x, y, z, pickupItemStack, firedFromWeapon);
    }

    public static EchoingArrow withOwner(Level level, LivingEntity owner, ItemStack pickupItemStack, @Nullable ItemStack firedFromWeapon) {
        return new EchoingArrow(level, owner, pickupItemStack, firedFromWeapon);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void doPostHurtEffects(@NotNull LivingEntity target) {
        super.doPostHurtEffects(target);
        if (target instanceof Warden) {
            Warden warden = (Warden)target;
            if (this.getOwner() != null) {
                if (this.level().getRandom().nextDouble() <= 0.25) {
                    warden.clearAnger(this.getOwner());
                    this.playSound((SoundEvent)SoundEvents.SOUL_ESCAPE.value(), 1.5f, 1.0f);
                }
                warden.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 200, 2, false, false));
                warden.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 100, 4, false, false));
                return;
            }
        }
        if (!(target instanceof LivingEntity)) return;
        LivingEntity living = target;
        living.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 60, 1, false, false));
        living.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 60, 1, false, false));
        living.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 200, 0, false, false));
        living.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 200, 0, false, false));
    }

    protected void onHitBlock(@NotNull BlockHitResult result) {
        RandomSource random = this.level().getRandom();
        this.playSound(SoundEvents.AMETHYST_BLOCK_RESONATE, 1.0f, 0.75f + random.nextFloat() / 2.0f);
        super.onHitBlock(result);
    }

    protected void onHitEntity(@NotNull EntityHitResult result) {
        RandomSource random = this.level().getRandom();
        this.playSound(SoundEvents.AMETHYST_BLOCK_RESONATE, 1.0f, 0.75f + random.nextFloat() / 2.0f);
        this.playSound(SoundEvents.GLASS_BREAK, 1.0f, 0.75f + random.nextFloat() / 2.0f);
        super.onHitEntity(result);
    }

    @NotNull
    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)ModItems.get(ModItems.ECHOING_ARROW));
    }
}

