/*
 * Decompiled with CFR 0.152.
 */
package dev.proststuff.archeries.entity;

import dev.proststuff.archeries.registry.ModEntities;
import dev.proststuff.archeries.registry.ModItems;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExplosiveArrow
extends AbstractArrow {
    public static int DEFAULT_INITIAL_DELAY = 15;
    public static int DEFAULT_FUSE_TICK = 20;
    private int initial_delay = DEFAULT_INITIAL_DELAY;
    private int fuse_tick = -1;

    public ExplosiveArrow(EntityType<? extends AbstractArrow> entityType, Level level) {
        super(entityType, level);
        this.setBaseDamage(0.5);
    }

    protected ExplosiveArrow(Level level, double x, double y, double z, ItemStack pickupItemStack, @Nullable ItemStack firedFromWeapon) {
        super(ModEntities.get(ModEntities.EXPLOSIVE_ARROW), x, y, z, level, pickupItemStack, firedFromWeapon);
        this.setBaseDamage(0.5);
    }

    protected ExplosiveArrow(Level level, LivingEntity owner, ItemStack pickupItemStack, @Nullable ItemStack firedFromWeapon) {
        super(ModEntities.get(ModEntities.EXPLOSIVE_ARROW), owner, level, pickupItemStack, firedFromWeapon);
        this.setBaseDamage(0.5);
    }

    public static ExplosiveArrow withPos(Level level, double x, double y, double z, ItemStack pickupItemStack, @Nullable ItemStack firedFromWeapon) {
        return new ExplosiveArrow(level, x, y, z, pickupItemStack, firedFromWeapon);
    }

    public static ExplosiveArrow withOwner(Level level, LivingEntity owner, ItemStack pickupItemStack, @Nullable ItemStack firedFromWeapon) {
        return new ExplosiveArrow(level, owner, pickupItemStack, firedFromWeapon);
    }

    @NotNull
    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)ModItems.get(ModItems.EXPLOSIVE_ARROW));
    }

    public void tick() {
        block8: {
            RandomSource random;
            Level level;
            block7: {
                super.tick();
                level = this.level();
                random = this.level().getRandom();
                if (this.fuse_tick > 0 && this.initial_delay == 0) {
                    --this.fuse_tick;
                    if (this.fuse_tick == DEFAULT_FUSE_TICK / 2) {
                        this.playSound(SoundEvents.FIREWORK_ROCKET_LARGE_BLAST, 0.75f, 0.75f / (this.random.nextFloat() * 0.2f + 0.9f));
                    }
                    if (this.fuse_tick == 0 && !level.isClientSide) {
                        this.explode(4.0f);
                    }
                }
                if (this.initial_delay <= 0) break block7;
                --this.initial_delay;
                if (this.initial_delay != 0) break block8;
                this.playSound(SoundEvents.TNT_PRIMED, 1.0f, 0.75f / (this.random.nextFloat() * 0.2f + 0.9f));
                if (level.isClientSide()) {
                    for (int i = 0; i < DEFAULT_FUSE_TICK / 4; ++i) {
                        double offsetX = random.nextDouble() / 2.0;
                        double offsetY = random.nextDouble() / 2.0;
                        double offsetZ = random.nextDouble() / 2.0;
                        level.addParticle((ParticleOptions)ParticleTypes.LAVA, this.getX() + offsetX, this.getY() + offsetY, this.getZ() + offsetZ, 0.0, 0.0, 0.0);
                    }
                }
                break block8;
            }
            if (this.tickCount % 4 == 0 && level.isClientSide()) {
                for (int i = 0; i < 4; ++i) {
                    double offsetX = (double)random.nextInt(-25, 25) / 50.0;
                    double offsetY = (double)random.nextInt(-25, 25) / 50.0;
                    double offsetZ = (double)random.nextInt(-25, 25) / 50.0;
                    level.addParticle((ParticleOptions)ParticleTypes.SMOKE, this.getX() + offsetX, this.getY() + offsetY, this.getZ() + offsetZ, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    protected void onHitBlock(@NotNull BlockHitResult result) {
        super.onHitBlock(result);
        this.fuse_tick = DEFAULT_FUSE_TICK;
    }

    protected void onHitEntity(@NotNull EntityHitResult result) {
        super.onHitEntity(result);
        this.explode(2.0f);
    }

    public void addAdditionalSaveData(@NotNull CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("delay", this.initial_delay);
        compound.putInt("fuse", this.fuse_tick);
    }

    public void readAdditionalSaveData(@NotNull CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.initial_delay = compound.getInt("delay");
        this.fuse_tick = compound.getInt("fuse");
        if (this.fuse_tick == 0) {
            this.initial_delay = DEFAULT_INITIAL_DELAY;
            this.fuse_tick = -1;
        }
    }

    private void explode(float radius) {
        this.level().explode((Entity)this, this.getX(), this.getY(), this.getZ(), radius, Level.ExplosionInteraction.TNT);
        this.discard();
    }
}

