/*
 * Decompiled with CFR 0.152.
 */
package dev.proststuff.archeries.entity;

import dev.proststuff.archeries.registry.ModEntities;
import dev.proststuff.archeries.registry.ModItems;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SoftArrow
extends AbstractArrow {
    public SoftArrow(EntityType<? extends AbstractArrow> entityType, Level level) {
        super(entityType, level);
        this.setBaseDamage(1.0);
    }

    protected SoftArrow(Level level, double x, double y, double z, ItemStack pickupItemStack, @Nullable ItemStack firedFromWeapon) {
        super(ModEntities.get(ModEntities.SOFT_ARROW), x, y, z, level, pickupItemStack, firedFromWeapon);
        this.setBaseDamage(1.0);
    }

    protected SoftArrow(Level level, LivingEntity owner, ItemStack pickupItemStack, @Nullable ItemStack firedFromWeapon) {
        super(ModEntities.get(ModEntities.SOFT_ARROW), owner, level, pickupItemStack, firedFromWeapon);
        this.setBaseDamage(1.0);
    }

    public static SoftArrow withPos(Level level, double x, double y, double z, ItemStack pickupItemStack, @Nullable ItemStack firedFromWeapon) {
        return new SoftArrow(level, x, y, z, pickupItemStack, firedFromWeapon);
    }

    public static SoftArrow withOwner(Level level, LivingEntity owner, ItemStack pickupItemStack, @Nullable ItemStack firedFromWeapon) {
        return new SoftArrow(level, owner, pickupItemStack, firedFromWeapon);
    }

    public boolean dampensVibrations() {
        return true;
    }

    @NotNull
    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)ModItems.get(ModItems.SOFT_ARROW));
    }

    public void playSound(@NotNull SoundEvent sound, float volume, float pitch) {
        super.playSound(sound, volume * 0.05f, pitch);
    }
}

