/*
 * Decompiled with CFR 0.152.
 */
package dev.proststuff.archeries.entity;

import dev.proststuff.archeries.registry.ModEntities;
import dev.proststuff.archeries.registry.ModItems;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SimpleExplosionDamageCalculator;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WindChargedArrow
extends AbstractArrow {
    private double recordedVelocity = 0.0;
    private boolean voided = false;
    private static final ExplosionDamageCalculator EXPLOSION_DAMAGE_CALCULATOR = new SimpleExplosionDamageCalculator(true, false, Optional.of(Float.valueOf(1.6f)), BuiltInRegistries.BLOCK.get(BlockTags.BLOCKS_WIND_CHARGE_EXPLOSIONS).map(Function.identity()));

    public WindChargedArrow(EntityType<? extends AbstractArrow> entityType, Level level) {
        super(entityType, level);
        this.setBaseDamage(1.0);
    }

    protected WindChargedArrow(Level level, double x, double y, double z, ItemStack pickupItemStack, @Nullable ItemStack firedFromWeapon) {
        super(ModEntities.get(ModEntities.WIND_CHARGED_ARROW), x, y, z, level, pickupItemStack, firedFromWeapon);
        this.setBaseDamage(1.0);
    }

    protected WindChargedArrow(Level level, LivingEntity owner, ItemStack pickupItemStack, @Nullable ItemStack firedFromWeapon) {
        super(ModEntities.get(ModEntities.WIND_CHARGED_ARROW), owner, level, pickupItemStack, firedFromWeapon);
        this.setBaseDamage(1.0);
    }

    public static WindChargedArrow withPos(Level level, double x, double y, double z, ItemStack pickupItemStack, @Nullable ItemStack firedFromWeapon) {
        return new WindChargedArrow(level, x, y, z, pickupItemStack, firedFromWeapon);
    }

    public static WindChargedArrow withOwner(Level level, LivingEntity owner, ItemStack pickupItemStack, @Nullable ItemStack firedFromWeapon) {
        return new WindChargedArrow(level, owner, pickupItemStack, firedFromWeapon);
    }

    protected void doPostHurtEffects(@NotNull LivingEntity target) {
        super.doPostHurtEffects(target);
        this.explode(target.getPosition(1.0f));
    }

    protected void onHitEntity(@NotNull EntityHitResult result) {
        this.recordedVelocity = this.getDeltaMovement().length();
        super.onHitEntity(result);
    }

    protected void onHitBlock(@NotNull BlockHitResult result) {
        this.recordedVelocity = this.getDeltaMovement().length();
        super.onHitBlock(result);
        this.explode(this.getPosition(1.0f));
    }

    protected void explode(Vec3 vec) {
        this.voided = true;
        this.level().explode((Entity)this, null, EXPLOSION_DAMAGE_CALCULATOR, vec.x(), vec.y(), vec.z(), (float)(this.recordedVelocity / 2.5), false, Level.ExplosionInteraction.TRIGGER, (ParticleOptions)ParticleTypes.GUST_EMITTER_SMALL, (ParticleOptions)ParticleTypes.GUST_EMITTER_LARGE, (Holder)SoundEvents.WIND_CHARGE_BURST);
    }

    @NotNull
    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)ModItems.get(ModItems.WIND_CHARGED_ARROW));
    }

    @NotNull
    protected ItemStack getPickupItem() {
        ItemStack stack = super.getPickupItem();
        if (stack.is((Item)ModItems.get(ModItems.WIND_CHARGED_ARROW))) {
            return new ItemStack((ItemLike)Items.ARROW);
        }
        return stack;
    }
}

