/*
 * Decompiled with CFR 0.152.
 */
package dev.proststuff.archeries.events;

import dev.proststuff.archeries.Archeries;
import dev.proststuff.archeries.NeoForgeArcheries;
import dev.proststuff.archeries.client.function.WristbowFunctions;
import dev.proststuff.archeries.client.renderer.entity.CopperArrowRenderer;
import dev.proststuff.archeries.client.renderer.entity.EchoingArrowRenderer;
import dev.proststuff.archeries.client.renderer.entity.ExplosiveArrowRenderer;
import dev.proststuff.archeries.client.renderer.entity.SoftArrowRenderer;
import dev.proststuff.archeries.client.renderer.entity.TracerArrowRenderer;
import dev.proststuff.archeries.client.renderer.entity.WindChargedArrowRenderer;
import dev.proststuff.archeries.payload.WristbowC2SSyncPacket;
import dev.proststuff.archeries.registry.ModDataComponents;
import dev.proststuff.archeries.registry.ModEntities;
import dev.proststuff.archeries.registry.ModKeyMappings;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="archeries", value={Dist.CLIENT})
public class ClientModEvents {
    @SubscribeEvent
    public static void init(EntityRenderersEvent.RegisterRenderers event) {
        Archeries.log("Renderers", new Object[0]);
        event.registerEntityRenderer((EntityType)NeoForgeArcheries.REGISTERED_ENTITY_TYPES.get(ModEntities.EXPLOSIVE_ARROW).get(), ExplosiveArrowRenderer::new);
        event.registerEntityRenderer((EntityType)NeoForgeArcheries.REGISTERED_ENTITY_TYPES.get(ModEntities.COPPER_ARROW).get(), CopperArrowRenderer::new);
        event.registerEntityRenderer((EntityType)NeoForgeArcheries.REGISTERED_ENTITY_TYPES.get(ModEntities.SOFT_ARROW).get(), SoftArrowRenderer::new);
        event.registerEntityRenderer((EntityType)NeoForgeArcheries.REGISTERED_ENTITY_TYPES.get(ModEntities.TRACER_ARROW).get(), TracerArrowRenderer::new);
        event.registerEntityRenderer((EntityType)NeoForgeArcheries.REGISTERED_ENTITY_TYPES.get(ModEntities.ECHOING_ARROW).get(), EchoingArrowRenderer::new);
        event.registerEntityRenderer((EntityType)NeoForgeArcheries.REGISTERED_ENTITY_TYPES.get(ModEntities.WIND_CHARGED_ARROW).get(), WindChargedArrowRenderer::new);
    }

    @SubscribeEvent
    public static void registerRP(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.CLIENT_RESOURCES) {
            event.addPackFinders(Archeries.id("resourcepacks/refreshed"), PackType.CLIENT_RESOURCES, (Component)Component.translatable((String)"resourcepack.archeries.refreshed"), PackSource.BUILT_IN, false, Pack.Position.TOP);
        }
    }

    @SubscribeEvent
    public static void registerBinding(RegisterKeyMappingsEvent event) {
        event.register((KeyMapping)ModKeyMappings.WRISTBOW.get());
    }

    @SubscribeEvent
    public static void handleWristbow(ClientTickEvent.Post event) {
        Minecraft minecraft = Minecraft.getInstance();
        if (WristbowFunctions.clientTicked(minecraft) && minecraft.player != null) {
            DataComponentType<Boolean> dataComponent = ModDataComponents.get(ModDataComponents.WRISTBOW_READY);
            ItemStack stack = minecraft.player.getItemInHand(InteractionHand.OFF_HAND);
            PacketDistributor.sendToServer((CustomPacketPayload)new WristbowC2SSyncPacket(Boolean.TRUE.equals(stack.get(dataComponent)), InteractionHand.OFF_HAND), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

