/*
 * Decompiled with CFR 0.152.
 */
package dev.proststuff.archeries.item.bow;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class TieredBowItem
extends BowItem {
    protected float velocity;
    protected float inaccuracy;
    protected int maxDrawDuration;
    protected double maxDrawStrength = 0.1;

    public TieredBowItem(Item.Properties properties, float velocity, float inaccuracy, int maxDrawDuration) {
        super(properties);
        this.velocity = velocity;
        this.inaccuracy = inaccuracy;
        this.maxDrawDuration = maxDrawDuration;
    }

    public boolean releaseUsing(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof Player) {
            int i;
            float f;
            Player player = (Player)entityLiving;
            ItemStack itemstack = player.getProjectile(stack);
            if (!itemstack.isEmpty() && !((double)(f = TieredBowItem.getPowerForTime(i = this.getUseDuration(stack, entityLiving) - timeLeft, this.maxDrawDuration)) < this.maxDrawStrength)) {
                List list = TieredBowItem.draw((ItemStack)stack, (ItemStack)itemstack, (LivingEntity)player);
                if (level instanceof ServerLevel) {
                    ServerLevel serverlevel = (ServerLevel)level;
                    if (!list.isEmpty()) {
                        this.shoot(serverlevel, (LivingEntity)player, player.getUsedItemHand(), stack, list, f * this.getVelocity(), this.getInaccuracy(), f == 1.0f, null);
                    }
                }
                this.playShootSound(level, player.getX(), player.getY(), player.getZ(), f);
                player.awardStat(Stats.ITEM_USED.get((Object)this));
            }
            return true;
        }
        return false;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        if (tooltipFlag.isAdvanced()) {
            tooltipComponents.add(TieredBowItem.append("tooltip.archeries.velocity", this.velocity, 3.0f, false));
            tooltipComponents.add(TieredBowItem.append("tooltip.archeries.max_draw_duration", (float)this.maxDrawDuration / 20.0f, 1.0f, true));
            tooltipComponents.add(TieredBowItem.append("tooltip.archeries.inaccuracy", this.inaccuracy, 1.0f, true));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public int getDefaultProjectileRange() {
        return (int)(this.getVelocity() / 3.0f) * 15;
    }

    public float getVelocity() {
        return this.velocity;
    }

    public float getInaccuracy() {
        return this.inaccuracy;
    }

    public void playShootSound(Level level, double x, double y, double z, float power) {
        level.playSound(null, x, y, z, SoundEvents.ARROW_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f / (level.getRandom().nextFloat() * 0.4f + 1.2f) + power * 0.5f);
    }

    public static Component append(String translationKey, float value, float base, boolean lowerIsBetter) {
        float i = value / base;
        double v1 = Double.parseDouble(String.format("%.2f", Float.valueOf(value)));
        double v2 = Double.parseDouble(String.format("%.2f", Float.valueOf(i)));
        return Component.translatable((String)translationKey, (Object[])new Object[]{v1, v2}).withStyle(TieredBowItem.determineColor(value, base, lowerIsBetter));
    }

    private static ChatFormatting determineColor(float val, float base, boolean lowerIsBetter) {
        if (val < base) {
            return lowerIsBetter ? ChatFormatting.GREEN : ChatFormatting.RED;
        }
        if (val > base) {
            return lowerIsBetter ? ChatFormatting.RED : ChatFormatting.GREEN;
        }
        return ChatFormatting.GRAY;
    }

    public static float getPowerForTime(int charge, int maxDrawDuration) {
        float f = (float)charge / (float)maxDrawDuration;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }
}

